/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.webmacro.engine.Block;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Term;
import org.webmacro.engine.Variable;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.PropertyOperator;
import org.webmacro.util.SizedStringWriter;
import org.webmacro.util.java2.HashMap;

final class ForeachDirective
implements Macro {
    private static final boolean _debug = false;
    private final Object _list;
    private final Block _body;
    private final Variable _iterVar;
    private final boolean _macro;

    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        if (parseTool.ttype != -3 && !parseTool.sval.equals("foreach")) {
            return null;
        }
        parseTool.nextToken();
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        if (parseTool.ttype != 36) {
            throw new ParseException(parseTool, "expected $ after foreach key word, got: " + (char)parseTool.ttype);
        }
        Variable variable = (Variable)Variable.parse(parseTool);
        if (variable == null) {
            throw new ParseException(parseTool, "expected TT_WORD, got: " + (char)parseTool.ttype);
        }
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        if (parseTool.ttype != -3 && !parseTool.sval.equals("in")) {
            throw new ParseException(parseTool, "expected in after foreach key word, got: " + (char)parseTool.ttype);
        }
        parseTool.nextToken();
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "(3) expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        Object object = Term.parse(parseTool);
        if (object == null) {
            throw new ParseException(parseTool, "expected TT_WORD, got: " + (char)parseTool.ttype);
        }
        if (!parseTool.parseWhitespace()) {
            throw new ParseException(parseTool, "expected ' ' after iterating variable name: got " + (char)parseTool.ttype);
        }
        if (parseTool.ttype != 123) {
            throw new ParseException(parseTool, "Block open brace required got: " + (char)parseTool.ttype);
        }
        Block block = (Block)Block.parse(parseTool);
        if (block == null) {
            throw new ParseException(parseTool, "Variable  requires a block");
        }
        return new ForeachDirective(object, variable, block);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(Writer var1_1, Object var2_2) throws InvalidContextException, IOException {
        var3_3 = this._list;
        if (this._macro) {
            while (var3_3 instanceof Macro) {
                var3_3 = ((Macro)var3_3).evaluate(var2_2);
            }
        }
        try {
            var4_4 = PropertyOperator.getIterator(var3_3);
        }
        catch (Exception var5_5) {
            throw new InvalidContextException("The object used as the list of values in a foreach statement must have some way of returning a list type, or be a list type itself. See the documentation for PropertyOperator.getIterator() for more details. No such property was found on the supplied object: " + var3_3);
        }
        if (var4_4 != null) ** GOTO lbl35
        var5_6 = "<!--\n " + this._list + ": is empty \n-->";
        try {
            this._iterVar.setValue(var2_2, var5_6);
        }
        catch (InvalidContextException var6_8) {
            Engine.log.exception(var6_8);
            Engine.log.error("Unable to resolve list" + this._list);
            var1_1.write("<!--\n Unable to resolve list " + this._list + " \n-->");
        }
        this._body.write(var1_1, var2_2);
        return;
lbl-1000:
        // 1 sources

        {
            var5_7 = var4_4.next();
            if (var5_7 == null) {
                var5_7 = "<!--\n " + this._list + ": contained a null item \n-->";
            }
            try {
                this._iterVar.setValue(var2_2, var5_7);
                this._body.write(var1_1, var2_2);
                continue;
            }
            catch (InvalidContextException var6_9) {
                Engine.log.exception(var6_9);
                Engine.log.error("unable to set a list item of list: " + this._list);
                var1_1.write("<!--\n Unable to resolve list " + this._list + " \n-->");
            }
lbl35:
            // 3 sources

            ** while (var4_4.hasNext())
        }
lbl36:
        // 1 sources

    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) throws InvalidContextException {
        try {
            SizedStringWriter sizedStringWriter = new SizedStringWriter(512);
            this.write(sizedStringWriter, object);
            return sizedStringWriter.toString();
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.error("evaluate got IO exception on write to StringWriter");
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        try {
            HashMap hashMap = new HashMap();
            Vector<String> vector = new Vector<String>();
            vector.addElement("Dave");
            vector.addElement("Susan");
            vector.addElement("yuenping");
            vector.addElement("justin");
            vector.addElement("anjli");
            vector.addElement("Mark");
            hashMap.put("customers", vector);
            ParseTool parseTool = new ParseTool(new File("examples", "justList.wm"));
            parseTool.nextToken();
            parseTool.nextToken();
            FileWriter fileWriter = new FileWriter(new File("examples", "justList.html"));
            ForeachDirective foreachDirective = (ForeachDirective)ForeachDirective.parse(parseTool);
            System.out.println("Converting justList.wm to justList.html");
            foreachDirective.write(fileWriter, hashMap);
            ((Writer)fileWriter).close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    ForeachDirective(Object object, Variable variable, Block block) {
        this._list = object;
        this._iterVar = variable;
        this._body = block;
        this._macro = object instanceof Macro;
    }
}

