/*
 * @(#) SendException.java 1.0.1
 *
 *
 * Copyright 2003 by UniPro Company (c),
 * www.unipro.ru
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of UniPro Company.
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement
 * you entered into with Unipro.
 */


package com.unipro.smlib;

/**
 * Method sendMessage() of <a href="SmsManager.html">SmsManager</a> throws this exception when there is an error of
 * sending message (Problems with <a href="SmsManager.html#pic"> 'W' connection<a>).
 * Exception occurs while sending message due to CMS Errors <a href="cmserror.html" >(see CMS ERROR)</a>:
 * For example if you have no money on your account to pay for SMS or network is unachievable.
 * To determinate the problem call getLocalizedMessage() method.
 * Additional information about SMLib exceptions: <a href="SmlibExceptions.html">SMLib exceptions</a>.
 */
public class SendException extends Exception {
    private String er, locErr;
    private int CMSError;

    /**
     * Creates new SendException with the specified error message and CMS ERROR.
     * @param er error message
     * @param locErr CMS ERROR
     */
    public SendException(String er, String locErr, int CMS) {
        this.er = er;
        this.locErr = locErr;
        this.CMSError = CMS;
    }

    /**
     * Gets CMS ERROR code.
     * @return CMS ERROR code <a href="cmserror.html" >(see CMS ERROR)</a>.
     */
    public int getStatus() {
        return CMSError;
    }

    /**
     *  Returns the error message.
     *  @return error message string.
     */
    public String getMessage() {
        return er;
    }

    /**
     *  Returns the detail message about CMS ERROR.
     *  @return the detail message string about CMS ERROR.
     */
    public String getLocalizedMessage() {
        return locErr;
    }

    /**
     * Returns a String object representing the exception.
     *  @return a string representation of the value of this object.
     */
    public String toString() {
        return "SendException :" + getMessage() + ", because of "
                + getLocalizedMessage();
    }
}

/*--- Formatted in Sun Java Convention Style on 03 31, '03 ---*/


