package tester;

/**
 * @(#)ExamFrame.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * ExamFrame.
 * This class creates the main exam frame and interacts with the
 * classes that produce the logic of the test engine.
 *
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class ExamFrame extends JFrame implements ActionListener {

    private String title;
    private JPanel eastPanel, answerPanel;
    private JLabel command, dummy1, dummy2, dummy3, dummy4,
        dummy5, dummy6, dummy7, dummy8, dummy9;
    private JTextField answerField, time;
    private JTextArea area;
    private final JButton start, next, log, grade, incorr;
    private JScrollPane scroll;
    private TestLoader load;
    private Answers ans;
    private Grade gr;
    private Font mainFont, answerFont;
    private int nextq, hrs, min, sec;
    public static int h, m, s;
    private TimePanel timePanel;
    private boolean ended = false;
    public float timePerQues = (60 * 60 * 2) / 59;
    private int secondsCounter = (int) (timePerQues * 59);
    private int initTimerVal = secondsCounter;
    private int warningCounterLimit = (int) (secondsCounter / 4);

    /**
     * Creates the main test frame.
     *
     * @param  title   The title String of the test frame.
     */
    public ExamFrame(String title) {
        this.title = title;
        load = new TestLoader();
        ans = new Answers();
        gr = new Grade();
        answerFont = new Font("Arial", Font.BOLD, 16);
        mainFont = new Font("Courier", Font.PLAIN, 14);

        Container pane = getContentPane();

        setTitle(title);

        start = new JButton("Start Exam");
        start.addActionListener(this);

        next = new JButton("Next");
        next.addActionListener(this);

        command = new JLabel("Type your answers here: ", JLabel.CENTER);

        answerPanel = new JPanel();
        answerField = new JTextField(11);
        answerField.setFont(answerFont);
        answerField.addKeyListener(new KeyAdapter() {
                public void keyTyped(KeyEvent ke) {
                    ke.setKeyChar(((String.valueOf(ke.getKeyChar())).toUpperCase()).charAt(0));
                }
            }
        );
        answerPanel.add(answerField);

        grade = new JButton("Grade Test");
        grade.addActionListener(this);
        grade.setEnabled(false);

        log = new JButton("Exam Log");
        log.addActionListener(this);

        incorr = new JButton("View Incorrect");
        incorr.addActionListener(this);
        incorr.setEnabled(false);

        timePanel = new TimePanel(this);

        dummy1 = new JLabel("");
        dummy2 = new JLabel("");
        dummy3 = new JLabel("");
        dummy4 = new JLabel("");
        dummy5 = new JLabel("");
        dummy6 = new JLabel("");
        dummy7 = new JLabel("     ");
        dummy8 = new JLabel(" ");
        dummy9 = new JLabel(" ");

        eastPanel = new JPanel();
        eastPanel.setLayout(new GridLayout(0, 1));
        eastPanel.add(start);
        eastPanel.add(next);
        eastPanel.add(command);
        eastPanel.add(answerPanel);
        eastPanel.add(grade);
        eastPanel.add(log);
        eastPanel.add(incorr);
        eastPanel.add(timePanel);
        eastPanel.add(dummy1);
        eastPanel.add(dummy2);
        eastPanel.add(dummy3);
        eastPanel.add(dummy4);
        eastPanel.add(dummy5);
        eastPanel.add(dummy6);
        eastPanel.add(dummy9);

        area = new JTextArea(27, 250);
        area.setFont(new Font("Courier", Font.PLAIN, 12));
        area.setBackground(new Color(31, 29, 92));
        area.setForeground(Color.white);
        area.setText(new Intro().getIntro());
        area.setEditable(false);

        scroll = new JScrollPane(area);
        pane.add(dummy7, BorderLayout.NORTH);
        pane.add(dummy8, BorderLayout.WEST);
        pane.add(eastPanel, BorderLayout.EAST);
        pane.add(scroll, BorderLayout.CENTER);
    }

    /**
     * Method to handle events for the ActionListener interface.
     * @param e java.awt.event.ActionEvent
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == start) {
            startTest();
        }
        if (e.getSource() == next) {
            getNextQuestion();
        }
        if (e.getSource() == grade) {
            gradeTest();
        }
        if (e.getSource() == log) {
            displayTestHistory();
        }
        if (e.getSource() == incorr) {
            displayIncorrect();
        }
    }

    /**
     * Starts the test loading the first question.
     */
    private void startTest() {
        Thread t1 = new Thread() {
                public void run() {
                    start.setEnabled(false);
                    area.setFont(mainFont);
                    area.setText(load.nextQuestion());
                    area.setCaretPosition(1);
                    timePanel.startTimer();
                    answerField.requestFocus();
                    nextq++;
                }
            };

        new Thread(t1).start();
    }

    /**
     * Loads the next question.
     */
    private void getNextQuestion() {
        if (nextq < load.files.length) {
            ans.collectAnswers(answerField.getText().trim());
            answerField.setText("");
            answerField.requestFocus();
            area.setText(load.nextQuestion());
            area.setCaretPosition(1);
        }
        nextq++;
        if (nextq == load.files.length) {
            next.setEnabled(false);
            next.setText("Press Grade");
            grade.setEnabled(true);
        }
    }

    /**
     * Grading method 1.
     * Grading is broken into 3 methods to make GUI responsive.
     */
    private void gradeTest() {
		area.setText("Please wait. Your test is being graded...");
		grade.setEnabled(false);
		incorr.setEnabled(true);
		startGrading();
    }

    /**
	 * Grading method 2.
     */
    private void startGrading() {
        calculateGrade();
	}

	/**
	 * Grading method 3.
     */
	private void calculateGrade() {
         Thread grade = new Thread() {
	     public void run() {
	     h = 1 - timePanel.getHours();
    	 m = 60 - timePanel.getMinutes();
		 s = 60 - timePanel.getSeconds();
	     timePanel.stopTimer();
		 ans.collectAnswers(answerField.getText().trim());
		 answerField.setText("");
		 gr.calculateGrade();
		 area.setText(gr.getWrong() + "\n  Your score is : " + (gr.getScore()) + " %\n" +
		              "  You answered " + gr.getCorrect() + " of " + load.files.length);
		 }
	     };
	     new Thread(grade).start();
		 Thread save = new Thread() {
		 public void run() {
		 gr.saveScore();
		 }
		 };
		 new Thread(save).start();
	}

    /**
     * Displays the performance in previously taken tests.
     */
    private void displayTestHistory() {
        area.setText(load.history());
        area.setCaretPosition(1);
    }

    /**
     * Displays a list of all incorrectly answered questions
     * with their correct answers.
     */
    private void displayIncorrect() {
        Thread t1 = new Thread() {
                public void run() {
                    area.setText(gr.wrongList());
                    area.setCaretPosition(1);
                }
            };

        new Thread(t1).start();
        incorr.setEnabled(false);
    }
} //end class
