/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagLISTITEM: For some reasons it would be nice to have a tag which can 
 *                  access an item, specified with a key. Of course this must 
 *                  be a list which is composed with a key and a text which would 
 *                  look as follows: key::text. 
 *
 * History: - Creation 01/27/99 nh
 *
 * Date: 01/27/99
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

public class PRePTagLISTITEM extends PRePTagCode
{

	public PRePTagLISTITEM()
	{
		super("LISTITEM");
	}


	public String getItem(String strKey, String strList)
	{
		String strDefault = "";

		final String DEFAULT = "default::";

		int iBegin = 0;

		int iDefaultIndex = strList.indexOf(DEFAULT);

		int iRIndex = strList.indexOf("\r");		
		int iNIndex = strList.indexOf("\n");

		if ( iRIndex < strList.indexOf("::") && iRIndex > 0)
		{
			strList.substring(iRIndex);
		}

		if ( iNIndex < strList.indexOf("::") && iNIndex > 0)
		{
			strList.substring(iNIndex);
		}

		if ( iDefaultIndex != -1 )
		{

			int iRDefIndex = strList.indexOf("\r", iDefaultIndex);
			int iNDefIndex = strList.indexOf("\n", iDefaultIndex);

			if ( iRDefIndex != -1 )
			{
				strDefault = strList.substring(iDefaultIndex+DEFAULT.length(), iRDefIndex);
			}
			else if ( iNDefIndex != -1 )
			{
				strDefault = strList.substring(iDefaultIndex+DEFAULT.length(), iRDefIndex);
			}
			else
			{
				strDefault = strList.substring(iDefaultIndex+DEFAULT.length());
			}

		}

		while ( strList.length() > 2 )
		{

			if ( strList.indexOf("::") != -1 )
			{

				String strKeyInList = strList.substring(iBegin, strList.indexOf("::")).trim();

				if ( strKeyInList.equals(strKey.trim()) )
				{

					// key found in list
					if ( (strList.indexOf("\r", 1) != -1) && (strList.indexOf("\r", 1) > strList.indexOf("::")) )
					{
						return strList.substring(strList.indexOf("::")+2, strList.indexOf("\r", 1));
					}
					else if ( (strList.indexOf("\n", 1) != -1) && (strList.indexOf("\n", 1) > strList.indexOf("::")) )
					{
						return strList.substring(strList.indexOf("::")+2, strList.indexOf("\n", 1));
					}
					else
					{
						return strList.substring(strList.indexOf("::")+2);
					}
				}
				else
				{
					if ( strList.indexOf("\r", strList.indexOf("::")) != -1 )
					{
						strList = strList.substring(strList.indexOf("\r", strList.indexOf("::")));
					}
					else if ( strList.indexOf("\n", strList.indexOf("::")) != -1 )
					{
						strList = strList.substring(strList.indexOf("\n", strList.indexOf("::")));
					}
					else
					{
						strList = "";
					}
				}

			}
		}

		return strDefault;

	}



	public void compile(Session session)
	{
		TagList tagList = session.getTagList();
		PRePTagCount prepTagCount = (PRePTagCount)tagList.find("ARG0");

		if ( prepTagCount != null )
		{
			int iArgs = prepTagCount.getIntValue();

			if ( iArgs == 3 )
			{
				PRePTag prepTagKey = tagList.find("ARG1");
				PRePTag prepTagList = tagList.find("ARG2");
				PRePTag prepTagOutput = tagList.find("ARG3");

				prepTagList = tagList.find(prepTagList.getValue());

				if ( prepTagList != null )
				{
					if ( prepTagKey.equals("") )
					{
						session.getExceptionList().addElement(new PRePException(this, "'no value as first argument'"));
					}
					else
					{
						String strKey = prepTagKey.getValue().trim();
						String strList = prepTagList.getAllValue().trim();

						String strText = getItem(strKey, strList);
						PRePTagText prepTagText = new PRePTagText("dummy");

						strText = "{"+prepTagOutput.getValue()+"::"+strText+"}";

						prepTagText.setValue(strText);
						prepTagText.compile(session);
					}
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'list tag not valid'"));
				}
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'arguments missing'")); 
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'no arguments'")); 
		}
	}
}
