/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagIF: Defines IF - if a specified texttag has a specified value, then do something, else do something else
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
 
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagIF extends PRePTagCode
{
	/**
	 * value of the tag
	 */
	String value;

	/**
	 * Constructor
	 */
	public PRePTagIF()
	{
		super("IF");
	}

	/**
	 * @param PrintWriter writer to compile the tag to
	 * @param TagList where the tags are stored
	 */
	public void compile(Session session)
	{
		PRePTag tagNewValue = session.getTagList().find("ARG1");
		String strNewValue = "";
		if ( tagNewValue != null )
		{
			PRePTagCount tagCount = (PRePTagCount) session.getTagList().find("ARG0");
			int iCount = tagCount.getIntValue();
			if ( tagCount.getIntValue() >= 3 )
			{
				strNewValue = tagNewValue.getValue();
				PRePTag tagSecond = session.getTagList().find(strNewValue);
				tagNewValue = session.getTagList().find("ARG2");

				if ( tagSecond != null )
				{
					String strTagSecond = tagSecond.getAllValue().trim();

					if ( strTagSecond.equals(tagNewValue.getAllValue().trim()) )
					{
						tagNewValue = session.getTagList().find("ARG3"); 
						tagNewValue.compile(session);
					}

					else
					{
						tagNewValue = session.getTagList().find("ARG4");
						if ( tagNewValue != null )
						{
							tagNewValue.compile(session);
						}
					}
				}
				else
				{
					tagNewValue = session.getTagList().find("ARG4");
					if ( tagNewValue != null )
					{
						tagNewValue.compile(session);
					}
				}
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'no arguments'"));
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'Tag not found!'"));
		} 
	}
}

