/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagEXCEPTION: gets an errorlevel as argument and returns all errors with errorlevels 
 *                   smaller or equal than this errorlevel
 *
 * History: - Creation 12/21/98
 *
 * Date: 12/21/98
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

import java.io.*;

public class PRePTagEXCEPTION extends PRePTagCode
{

	/**
	 * Constructor
	 */
	public PRePTagEXCEPTION()
	{
		super("EXCEPTION");
	}

	public void compile(Session session)
	{
		PRePTag prepTag = session.getTagList().find("ARG1");
		PrintWriter pWriter = session.getPrintWriter();
		if ( prepTag != null )
		{
			Integer integer = new Integer(prepTag.getValue());
			session.getExceptionList().outErrorlevel(pWriter, integer.intValue());
		}
		else
		{
			session.getExceptionList().outExceptionList(pWriter);
		}
	}
}
