/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.ui.dialogs.OpenSaveFileDialog;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Class SelectFileField is component for selecting file that uses OpenSaveFileDialog.
 *
 * @author Serge Piletsky
 */
public class SelectFileField extends AbstractChooserField
{
    public static final String PROPERTY_FILE = "file";

    public static final int MODE_OPEN_FILE = 0;
    public static final int MODE_SAVE_FILE = 1;

    private int _mode = MODE_OPEN_FILE;
    private OpenSaveFileDialog _dialog;

    public SelectFileField()
    {
    }

    public SelectFileField(int mode)
    {
        _mode = mode;
    }

    /**
     * Returns dialog mode.
     * @return dialog mode
     */
    public int getMode()
    {
        return _mode;
    }

    /**
     * Sets dialog mode.
     * @param mode is a dialog mode
     */
    public void setMode(int mode)
    {
        _mode = mode;
    }

    /**
     * Returns selected file.
     * @return selected file
     */
    public String getFileName()
    {
        return getTextField().getText();
    }

    /**
     * Sets file name
     * @param value is file name
     */
    public void setFileName(String value)
    {
        getTextField().setText(value);
    }

    public void actionPerformed(ActionEvent e)
    {
        OpenSaveFileDialog dialog = getDialog();
        boolean executed = false;
        if (getMode() == MODE_OPEN_FILE)
        {
            executed = dialog.getOpenFileName();
        }
        else if (getMode() == MODE_SAVE_FILE)
        {
            executed = dialog.getSaveFileName();
        }
        else
            throw new IllegalArgumentException();

        if (executed)
        {
            String oldFileName = getFileName();
            String newFileName = dialog.getFileName();
            setFileName(newFileName);
            firePropertyChange(PROPERTY_FILE, oldFileName, newFileName);
        }
    }

    /**
     * Returns dialog.
     * @return dialog
     */
    public OpenSaveFileDialog getDialog()
    {
        if (_dialog == null)
        {
            Window parent = SwingUtilities.getWindowAncestor(this);
            _dialog = new OpenSaveFileDialog(parent);
        }
        return _dialog;
    }
}
