/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.win32.Handle;

/**
 * This class represents BITMAP structure.
 *
 * @author Andrew Kharchenko
 * @author Serge Piletsky
 */
public class BitmapStructure extends Structure
{
    private LongInt _bmType = new LongInt();
    private LongInt _bmWidth = new LongInt();
    private LongInt _bmHeight = new LongInt();
    private LongInt _bmWidthBytes = new LongInt();
    private UInt16 _bmPlanes = new UInt16();
    private UInt16 _bmBitsPixel = new UInt16();
    private Handle _bmBits = new Handle();

    public BitmapStructure()
    {
        init(new Parameter[]{_bmType, _bmWidth, _bmHeight, _bmWidthBytes, _bmPlanes, _bmBitsPixel, _bmBits});
    }

    public BitmapStructure(long width,
                        long height,
                        long widthBytes,
                        long planes,
                        long bitsPixel)
    {
        this();
        setBitmapWidth(width);
        setBitmapHeight(height);
        setBitmapWidthBytes(widthBytes);
        setPlanes(planes);
        setBitsPixel(bitsPixel);
    }

    public void setBitmapWidth(long width)
    {
        _bmWidth.setValue(width);
    }

    public long getBitmapWidth()
    {
        return _bmWidth.getValue();
    }

    public void setBitmapHeight(long height)
    {
        _bmHeight.setValue(height);
    }

    public long getBitmapHeight()
    {
        return _bmHeight.getValue();
    }

    public void setBitmapWidthBytes(long width)
    {
        _bmWidthBytes.setValue(width);
    }

    public long getBitmapWidthBytes()
    {
        return _bmWidthBytes.getValue();
    }

    public void setPlanes(long count)
    {
        _bmPlanes.setValue(count);
    }

    public long getPlanes()
    {
        return _bmPlanes.getValue();
    }

    public void setBitsPixel(long count)
    {
        _bmBitsPixel.setValue(count);
    }

    public long getBitsPixel()
    {
        return _bmBitsPixel.getValue();
    }
}
