/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.SystemColor;
import com.jniwrapper.win32.ui.controls.ChooseColorField;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * @author Serge Piletsky
 */
class SystemColorsSample extends LazyPanel implements PropertyChangeListener
{
    private JLabel lblAdvisoryText;
    private JLabel lblDesktopColor;
    private ChooseColorField fldDesktopColor;
    private JLabel lblMenuColor;
    private ChooseColorField fldMenuColor;
    private JLabel lblMenuTextColor;
    private ChooseColorField fldMenuTextColor;
    private JLabel lblInactiveCaptionColor;
    private ChooseColorField fldInactiveCaptionColor;
    private JLabel lblActiveCaptionColor;
    private ChooseColorField fldActiveCaptionColor;

    public SystemColorsSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page shows colors set in your Windows Appearance schema using the SystemColor class functions." +
                "<br><br><b>NOTE:</b> The WinPackSet uses these colors as well.<br><br>Be carefull" +
                " changing colours as the changes are applied automatically to your Windows Appearance schema.");

        lblDesktopColor = new JLabel("Desktop Color:");
        fldDesktopColor = new ChooseColorField(SystemColor.DESKTOP.getColor());
        fldDesktopColor.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);

        lblMenuColor = new JLabel("Menu Color:");
        fldMenuColor = new ChooseColorField(SystemColor.MENU.getColor());
        fldMenuColor.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);

        lblMenuTextColor = new JLabel("Menu Text Color:");;
        fldMenuTextColor = new ChooseColorField(SystemColor.MENUTEXT.getColor());
        fldMenuTextColor.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);

        lblInactiveCaptionColor = new JLabel("Inactive Caption Color:");
        fldInactiveCaptionColor = new ChooseColorField(SystemColor.INACTIVECAPTION.getColor());
        fldInactiveCaptionColor.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);

        lblActiveCaptionColor = new JLabel("Active Caption Color:");
        fldActiveCaptionColor = new ChooseColorField(SystemColor.ACTIVECAPTION.getColor());
        fldActiveCaptionColor.addPropertyChangeListener(ChooseColorField.PROPERTY_COLOR, this);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 20, 10), 0, 0));

        add(lblDesktopColor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(fldDesktopColor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblMenuColor , new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(fldMenuColor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblMenuTextColor , new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(fldMenuTextColor, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblInactiveCaptionColor , new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(fldInactiveCaptionColor, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(lblActiveCaptionColor , new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(fldActiveCaptionColor, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        if (evt.getSource().equals(fldDesktopColor))
        {
            SystemColor.DESKTOP.setColor((Color)evt.getNewValue());
        }
        else if (evt.getSource().equals(fldMenuColor))
        {
            SystemColor.MENU.setColor((Color)evt.getNewValue());
        }
        else if (evt.getSource().equals(fldMenuTextColor))
        {
            SystemColor.MENUTEXT.setColor((Color)evt.getNewValue());
        }
        else if (evt.getSource().equals(fldInactiveCaptionColor))
        {
            SystemColor.INACTIVECAPTION.setColor((Color)evt.getNewValue());
        }
        else if (evt.getSource().equals(fldActiveCaptionColor))
        {
            SystemColor.ACTIVECAPTION.setColor((Color)evt.getNewValue());
        }
    }
}
