/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Kernel32;

public class VersionInfo
extends Structure {
    static final String FUNCTION_GET_VERSIONEX = "GetVersionExA";
    public static final int VER_PLATFORM_WIN32s = 0;
    public static final int VER_PLATFORM_WIN32_WINDOWS = 1;
    public static final int VER_PLATFORM_WIN32_NT = 2;
    public static final int VER_PLATFORM_WIN32_CE = 3;
    private UInt32 _dwOSVersionInfoSize = new UInt32();
    private UInt32 _dwMajorVersion = new UInt32();
    private UInt32 _dwMinorVersion = new UInt32();
    private UInt32 _dwBuildNumber = new UInt32();
    private UInt32 _dwPlatformId = new UInt32();
    private AnsiString _szCSDVersion = new AnsiString(128);

    public VersionInfo() {
        this.init(new Parameter[]{this._dwOSVersionInfoSize, this._dwMajorVersion, this._dwMinorVersion, this._dwBuildNumber, this._dwPlatformId, this._szCSDVersion});
        this._dwOSVersionInfoSize.setValue(this.getLength());
        Function function = Kernel32.get(FUNCTION_GET_VERSIONEX);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Pointer(this));
    }

    public long getBuildNumber() {
        long l2 = this._dwBuildNumber.getValue();
        if (this.isNT()) {
            return l2;
        }
        return l2 & 0xFFFFL;
    }

    public long getMajor() {
        return this._dwMajorVersion.getValue();
    }

    public long getMinor() {
        return this._dwMinorVersion.getValue();
    }

    public long getPlatformId() {
        return this._dwPlatformId.getValue();
    }

    public String getServicePack() {
        return this._szCSDVersion.getValue();
    }

    public boolean isNT() {
        return this.getPlatformId() == 2L;
    }

    public boolean isWin9x() {
        return this.getPlatformId() == 1L;
    }

    public boolean isWin2k() {
        return this.getMajor() >= 5L & this.getPlatformId() == 2L;
    }

    public boolean isWinMe() {
        return this.getPlatformId() == 1L & this.getMajor() >= 4L & this.getMinor() >= 90L;
    }

    static {
        FUNCTION_GET_VERSIONEX = FUNCTION_GET_VERSIONEX;
        VER_PLATFORM_WIN32s = 0;
        VER_PLATFORM_WIN32_WINDOWS = 1;
        VER_PLATFORM_WIN32_NT = 2;
        VER_PLATFORM_WIN32_CE = 3;
    }
}

