/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Char;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideChar;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.Shell32;

public class SHFileInfo
extends Structure {
    static final FunctionName FUNCTION_GET_FILE_INFO = new FunctionName("SHGetFileInfo");
    public static final int SHGFI_ICON = 256;
    public static final int SHGFI_DISPLAYNAME = 512;
    public static final int SHGFI_TYPENAME = 1024;
    public static final int SHGFI_ATTRIBUTES = 2048;
    public static final int SHGFI_ICONLOCATION = 4096;
    public static final int SHGFI_EXETYPE = 8192;
    public static final int SHGFI_SYSICONINDEX = 16384;
    public static final int SHGFI_LINKOVERLAY = 32768;
    public static final int SHGFI_SELECTED = 65536;
    public static final int SHGFI_ATTR_SPECIFIED = 131072;
    public static final int SHGFI_LARGEICON = 0;
    public static final int SHGFI_SMALLICON = 1;
    public static final int SHGFI_OPENICON = 2;
    public static final int SHGFI_SHELLICONSIZE = 4;
    public static final int SHGFI_PIDL = 8;
    public static final int SHGFI_USEFILEATTRIBUTES = 16;
    private Icon _icon = new Icon();
    private Int _iconIndex = new Int();
    private UInt16 _attributes = new UInt16();
    private PrimitiveArray _displayName;
    private PrimitiveArray _typeName;
    static final int MAX_PATH = 260;

    public SHFileInfo() {
        Kernel32 kernel32 = Kernel32.getInstance();
        boolean unicode = kernel32.isUnicode();
        if (unicode) {
            this._displayName = new PrimitiveArray((Parameter)new WideChar(), 260);
            this._typeName = new PrimitiveArray((Parameter)new WideChar(), 80);
        } else {
            this._displayName = new PrimitiveArray((Parameter)new Char(), 260);
            this._typeName = new PrimitiveArray((Parameter)new Char(), 80);
        }
        this.init(new Parameter[]{this._icon, this._iconIndex, this._attributes, this._displayName, this._typeName});
    }

    public Icon getIcon() {
        return this._icon;
    }

    public static SHFileInfo getFileInfo(String path, int fileAttributes, int flags) {
        SHFileInfo result = new SHFileInfo();
        Shell32 shell32 = Shell32.getInstance();
        Function function = shell32.getFunction(FUNCTION_GET_FILE_INFO.toString());
        function.invoke(null, new Parameter[]{shell32.stringParam(path), new UInt32((long)fileAttributes), new Pointer((Parameter)result), new UInt((long)result.getLength()), new UInt((long)flags)});
        return result;
    }

    public static SHFileInfo getFileInfo(String path, int flags) {
        return SHFileInfo.getFileInfo(path, 0, flags);
    }

    static {
        SHGFI_ICON = 256;
        SHGFI_DISPLAYNAME = 512;
        SHGFI_TYPENAME = 1024;
        SHGFI_ATTRIBUTES = 2048;
        SHGFI_ICONLOCATION = 4096;
        SHGFI_EXETYPE = 8192;
        SHGFI_SYSICONINDEX = 16384;
        SHGFI_LINKOVERLAY = 32768;
        SHGFI_SELECTED = 65536;
        SHGFI_ATTR_SPECIFIED = 131072;
        SHGFI_LARGEICON = 0;
        SHGFI_SMALLICON = 1;
        SHGFI_OPENICON = 2;
        SHGFI_SHELLICONSIZE = 4;
        SHGFI_PIDL = 8;
        SHGFI_USEFILEATTRIBUTES = 16;
        MAX_PATH = 260;
    }
}

