/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.Callback;
import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.Int;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.system.Beeper;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.system.Mutex;
import com.jniwrapper.win32.ui.DesktopWindow;
import com.jniwrapper.win32.ui.MessageBox;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.Timer;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.WndClass;

public class Buzzer {
    private static final int TIMER_ID = 1;
    private static final String WINDOW_CLASS_NAME = "BuzzerWindowClass";
    private Wnd _hSplash;
    private Bitmap _hSplashImage;
    private static final int SPLASH_WIDTH = 122;
    private Timer _timer;

    public Buzzer() {
        Brush bgBrush = Brush.getStockObject((Brush.StockBrush)Brush.StockBrush.NULL_BRUSH);
        BuzzerWndClass wndClass = new BuzzerWndClass((Callback)new BuzzerWindowProc(), WINDOW_CLASS_NAME, (Pointer.Void)bgBrush);
        wndClass.register();
        Module hModule = Module.getCurrent();
        Wnd nullParent = new Wnd();
        Handle NULL = new Handle();
        this._hSplash = Wnd.createWindow((String)WINDOW_CLASS_NAME, (String)"Buzzer", (int)Integer.MIN_VALUE, (long)0L, (long)0L, (long)0L, (long)0L, (Wnd)nullParent, (Handle)NULL, (Handle)hModule, (Handle)NULL);
        if (this._hSplash.getValue() == 0L) {
            throw new LastErrorException("Failed to create splash window.");
        }
    }

    public static void main(String[] args) {
        DefaultLibraryLoader.getInstance().addPath("Bin");
        Buzzer buzzer = new Buzzer();
        if (!buzzer.checkOneInstance()) {
            buzzer.error("Buzzer is already running");
            System.exit(0);
        }
        buzzer.startTimer(10000L);
        buzzer.run();
    }

    private void run() {
        DesktopWindow hDesktop = DesktopWindow.getInstance();
        Int width = new Int();
        Int height = new Int();
        Wnd.getWindowRect((Wnd)hDesktop, (Int)width, (Int)height);
        Region hRgn = Region.createElliptic((int)0, (int)0, (int)122, (int)122);
        Wnd.setWindowRgn((Wnd)this._hSplash, (Region)hRgn, (boolean)true);
        boolean result = Wnd.setWindowPos((Wnd)this._hSplash, (Wnd)new Wnd(-1L), (long)((width.getValue() - 122L) / 2L), (long)((height.getValue() - 122L) / 2L), (long)122L, (long)122L, (long)64L);
        if (!result) {
            throw new LastErrorException("Failed to show splash.", true);
        }
        this._hSplash.eventLoop();
    }

    private void paintSplash() {
        PaintStruct paintStruct = new PaintStruct();
        DC hDC = this._hSplash.beginPaint(paintStruct);
        DC splashDC = DC.createCompatibleDC((DC)hDC);
        splashDC.selectObject(this.getSplashImage());
        DC.bitBlt((DC)hDC, (int)0, (int)0, (int)122, (int)122, (DC)splashDC, (int)0, (int)0, (DC.RasterOperation)DC.RasterOperation.SRCCOPY);
        splashDC.release();
        this._hSplash.endPaint(paintStruct);
    }

    private Bitmap getSplashImage() {
        if (this._hSplashImage == null) {
            this._hSplashImage = new Bitmap("Buzzer.bmp");
        }
        return this._hSplashImage;
    }

    private void startTimer(long timeout) {
        TimeOutCallback timeOutCallback = new TimeOutCallback();
        this._timer = new Timer(this._hSplash, 1L, timeout, (Timer.Callback)timeOutCallback);
        this._timer.start();
    }

    private void showMessageBox(String message, int flags) {
        MessageBox.show((String)"Buzzer", (String)message, (int)flags);
    }

    private void message(String message) {
        this.showMessageBox(message, 48);
    }

    private void error(String message) {
        this.showMessageBox(message, 16);
    }

    private boolean checkOneInstance() {
        String mutexName = "com.jniwrapper.win32.samples.BuzzerMutex";
        Mutex mutex = Mutex.openMutex((int)0x1F0001, (boolean)false, (String)mutexName);
        if (mutex.exists()) {
            return false;
        }
        mutex = Mutex.createMutex((boolean)false, (String)mutexName);
        if (mutex.isNull()) {
            throw new LastErrorException("Mutex creation failed.", true);
        }
        return true;
    }

    private void buzz() {
        Beeper.beep((long)600L, (long)100L);
        Beeper.beep((long)400L, (long)200L);
    }

    private void hideSplash() {
        this._hSplash.show(0);
    }

    static {
        TIMER_ID = 1;
        WINDOW_CLASS_NAME = WINDOW_CLASS_NAME;
        SPLASH_WIDTH = 122;
    }

    private class BuzzerWindowProc
    extends WindowProc {
        private BuzzerWindowProc() {
        }

        public void callback() {
            switch ((int)this._msg.getValue()) {
                case 15: {
                    Buzzer.this.paintSplash();
                    break;
                }
                default: {
                    super.callback();
                }
            }
        }
    }

    private static class BuzzerWndClass
    extends WndClass {
        public BuzzerWndClass(Callback windowProc, String className, Pointer.Void bgBrushHandle) {
            super(windowProc, className);
            this._style.setValue(3L);
            this._hbrBackground.setValue(bgBrushHandle.getValue());
        }
    }

    private class TimeOutCallback
    extends Timer.Callback {
        public void callback() {
            Buzzer.this._timer.stop();
            Buzzer.this.buzz();
            Buzzer.this.hideSplash();
            Buzzer.this.message("Timer has elapsed!");
            System.exit(0);
        }
    }
}

