/*
 * Decompiled with CFR 0.152.
 */
import com.jniwrapper.AnsiString;
import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.WideString;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryItem;

public class RegistrySample {
    private static final String TEST_KEY_PATH = "Software\\JNIWrapper\\TestPath";

    public static void main(String[] args) {
        RegistrySample registry = new RegistrySample();
        try {
            registry.testDeletingKey();
            registry.testSimpleString();
            registry.testUnicodeSimpleString();
            registry.testBinaryData();
            registry.testCInt32();
            registry.testDoubleZeroEndianSimpleString();
            registry.testDoubleZeroEndianWideString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void testDeletingKey() {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = "Software\\JNIWrapper";
        String keyName = "TestPath";
        RegistryItem regItem = new RegistryItem(keyHandle, "Software\\JNIWrapper", "TestPath", null, 7);
        regItem.delete();
        try {
            regItem = new RegistryItem(keyHandle, "Software\\JNIWrapper", "TestPath", null, 7);
            regItem.delete();
            throw new RuntimeException("Registry key is present before edding it");
        }
        catch (RegistryException e) {
            String errorMessage = e.getMessage();
            if (errorMessage.charAt(errorMessage.length() - 1) != '2') {
                throw new RuntimeException("Registry key is not deleted");
            }
            System.out.println("Checked failing when deleting non-existent key");
            return;
        }
    }

    public void testSimpleString() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "SimpleStringTest";
        AnsiString keyValue = new AnsiString("passed");
        AnsiString emptyKey = new AnsiString(7);
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "SimpleStringTest", (Parameter)keyValue, (Parameter)emptyKey, 1);
        System.out.println("Checked storing simple string");
    }

    public void testUnicodeSimpleString() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "WideStringTest";
        AnsiString keyValue = new AnsiString("passed\u0430");
        AnsiString emptyKey = new AnsiString(8);
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "WideStringTest", (Parameter)keyValue, (Parameter)emptyKey, 1);
        System.out.println("Checked storing simple Unicode string");
    }

    public void testBinaryData() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "BinaryDataTest";
        PrimitiveArray keyValue = new PrimitiveArray((Parameter)new Int32(5), 10);
        PrimitiveArray emptyKey = new PrimitiveArray((Parameter)new Int32(), 10);
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "BinaryDataTest", (Parameter)keyValue, (Parameter)emptyKey, 3);
        System.out.println("Checked storing binary data");
    }

    public void testCInt32() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "DWORDTest";
        Int32 keyValue = new Int32(2000);
        Int32 emptyKey = new Int32();
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "DWORDTest", (Parameter)keyValue, (Parameter)emptyKey, 4);
        System.out.println("Checked storing simple string");
    }

    public void testDoubleZeroEndianSimpleString() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "DoubleZeroEndianSimpleStringTest";
        AnsiString CkeyValue = new AnsiString("passed\u0000");
        AnsiString emptyKey = new AnsiString(9);
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "DoubleZeroEndianSimpleStringTest", (Parameter)CkeyValue, (Parameter)emptyKey, 7);
        System.out.println("Checked storing double zero endian simple string");
    }

    public void testDoubleZeroEndianWideString() throws Exception {
        int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        String keyPath = TEST_KEY_PATH;
        String keyName = "DoubleZeroEndianWideStringTest";
        WideString CkeyValue = new WideString("passed\u0430\u0000");
        WideString emptyKey = new WideString(10);
        this.readWriteRegistry(keyHandle, TEST_KEY_PATH, "DoubleZeroEndianWideStringTest", (Parameter)CkeyValue, (Parameter)emptyKey, 7);
        System.out.println("Checked storing double zero endian wide string");
    }

    private void readWriteRegistry(int keyHandle, String keyPath, String keyName, Parameter keyValue, Parameter emptyKey, int keyType) {
        RegistryItem regItem = new RegistryItem(keyHandle, keyPath, keyName, keyValue, keyType);
        regItem.write();
        regItem = new RegistryItem(keyHandle, keyPath, keyName, emptyKey, keyType);
        regItem.read();
        Parameter value = regItem.getValue();
        if (!keyValue.equals((Object)value)) {
            throw new RuntimeException("registry value");
        }
    }

    static {
        TEST_KEY_PATH = TEST_KEY_PATH;
        DefaultLibraryLoader.getInstance().addPath("Bin");
    }
}

