/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.StringTokenizer;
import jdbees.JBeesConfInfo;
import jdbees.JBeesNetworkIO;
import jdbees.ftp.JBeesFtpDataChannel;
import jdbees.ftp.JBeesFtpDataServer;
import jdbees.ftp.JBeesFtpFileNotExistException;
import jdbees.ftp.JBeesFtpUserNotSupportedException;

public class JBeesFtpControlChannel {
    private boolean debug = false;
    private JBeesNetworkIO jnio;
    private OutputStream outs;
    private BufferedReader br;
    private URL url;
    private JBeesConfInfo jbconf;
    private String user;
    private String passwd;
    private boolean pasvSupported = false;
    private boolean restSupported = false;
    private long fileLength = 0L;
    private static final int USER = 1;
    private static final int PASSWD = 2;
    private static final int REST = 3;
    private static final int PASV = 4;
    private static final int LIST = 5;
    private static final int TYPE = 6;
    private static final int PORT = 7;
    private String dataIP;
    private int dataPort;
    private String statusStr;
    JBeesFtpDataChannel jfdc;
    JBeesFtpDataServer jfs;
    private int localActivePort;
    private String localIP;

    public JBeesFtpControlChannel(URL url, JBeesConfInfo jbconf) throws IOException {
        this.url = url;
        this.jbconf = jbconf;
        this.user = jbconf.getFtpUser();
        this.passwd = jbconf.getFtpPasswd();
        this.getStreams();
    }

    public JBeesFtpControlChannel(URL url, JBeesConfInfo jbconf, String user, String passwd) throws IOException {
        this.url = url;
        this.jbconf = jbconf;
        this.user = user;
        this.passwd = passwd;
        this.getStreams();
    }

    private void getStreams() throws IOException {
        this.jnio = new JBeesNetworkIO(this.url);
        this.localActivePort = this.jnio.getLocalPort() + 10;
        this.localIP = this.jnio.getLocalIP();
        if (this.jbconf.getSocketTimeout() > 0) {
            this.jnio.setTimeout(this.jbconf.getSocketTimeout());
        }
        this.outs = this.jnio.getOutputStream();
        this.br = this.jnio.getBufferedReader();
        String str = this.br.readLine();
        if (this.debug) {
            System.out.println(str);
        }
    }

    public void close() throws IOException {
        this.outs.close();
        this.br.close();
        this.jnio.close();
    }

    public long getFileLength() throws IOException, JBeesFtpFileNotExistException {
        if (this.pasvSupported) {
            if (this.debug) {
                System.out.println("Enter getFileLength");
            }
            this.jfdc = new JBeesFtpDataChannel(this.dataIP, this.dataPort, this.jbconf);
            if (this.debug) {
                System.out.println("data channel created");
            }
        } else {
            this.jfs = new JBeesFtpDataServer(this.localActivePort);
            this.setPort();
        }
        if (this.debug) {
            System.out.println("LIST " + this.url.getPath());
        }
        this.println("LIST " + this.url.getPath());
        this.getResp(5);
        if (this.fileLength == 0L) {
            this.close();
            throw new JBeesFtpFileNotExistException();
        }
        return this.fileLength;
    }

    public String getDataIP() {
        return this.dataIP;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public int getLocalActivePort() {
        return this.localActivePort;
    }

    public void authenticate() throws IOException, JBeesFtpUserNotSupportedException {
        if (this.debug) {
            System.out.println("USER " + this.user);
        }
        this.println("USER " + this.user);
        if (!this.getResp(1)) {
            this.close();
            throw new JBeesFtpUserNotSupportedException();
        }
        if (this.debug) {
            System.out.println("PASS " + this.passwd);
        }
        this.println("PASS " + this.passwd);
        if (!this.getResp(2)) {
            this.close();
            throw new JBeesFtpUserNotSupportedException();
        }
    }

    public void setCharType() throws IOException {
        this.setType("A");
    }

    public void setByteType() throws IOException {
        this.setType("I");
    }

    public void setPort() throws IOException {
        String portStr = "PORT " + this.localIP.replace('.', ',') + "," + this.localActivePort / 256 + "," + this.localActivePort % 256;
        if (this.debug) {
            System.out.println("Port str: " + portStr);
        }
        this.println(portStr);
        this.getResp(7);
    }

    public void setRetr(String filename) throws IOException {
        if (this.debug) {
            System.out.println("RETR " + filename);
        }
        this.println("RETR " + filename);
    }

    public boolean isPasvSupported() throws IOException {
        if (this.debug) {
            System.out.println("PASV");
        }
        this.println("PASV");
        this.pasvSupported = this.getResp(4);
        return this.pasvSupported;
    }

    public boolean isRestSupported(long l) throws IOException {
        if (this.debug) {
            System.out.println("REST " + l);
        }
        this.println("REST " + l);
        this.restSupported = this.getResp(3);
        return this.restSupported;
    }

    private void setType(String type) throws IOException {
        if (this.debug) {
            System.out.println("TYPE " + type);
        }
        this.println("TYPE " + type);
        String str = this.br.readLine();
        if (this.debug) {
            System.out.println("response for TYPE command: " + str);
        }
    }

    private boolean getResp(int flag) throws IOException {
        boolean ret = false;
        switch (flag) {
            case 1: {
                ret = this.getUserResp();
                break;
            }
            case 2: {
                ret = this.getPassResp();
                break;
            }
            case 4: {
                ret = this.getPasvResp();
                break;
            }
            case 5: {
                ret = this.getListResp();
                break;
            }
            case 3: {
                ret = this.getRestResp();
                break;
            }
            case 7: {
                ret = this.getPortResp();
            }
        }
        return ret;
    }

    private boolean getPortResp() throws IOException {
        return this.getStatusLine("reponse for PORT command: ");
    }

    private boolean getRestResp() throws IOException {
        return this.getStatusLine("response for REST command: ");
    }

    private boolean getListResp() throws IOException {
        String str;
        if (this.pasvSupported) {
            this.getStatusLine("response for LIST command in passive mode: ");
            str = this.getFileStatus();
            this.getStatusLine("finish read file status");
        } else {
            this.jfs.accept(this.jbconf.getSocketTimeout());
            this.jfs.getDataInputStream();
            this.getStatusLine("response for LIST command in active mode: ");
            str = this.getFileStatus();
            this.getStatusLine("finish read file status");
        }
        if (str == null) {
            this.fileLength = 0L;
            return false;
        }
        StringTokenizer stk = new StringTokenizer(str);
        int i = 0;
        while (i < 4) {
            stk.nextToken();
            ++i;
        }
        this.fileLength = Long.parseLong(stk.nextToken());
        return true;
    }

    private String getFileStatus() {
        String str = null;
        try {
            if (this.pasvSupported) {
                str = this.jfdc.readLine();
                this.jfdc.close();
            } else {
                if (this.debug) {
                    System.out.println("enter active mode");
                }
                str = this.jfs.readLine();
                this.jfs.close();
            }
            if (this.debug) {
                System.out.println(str);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return str;
    }

    private boolean getPasvResp() throws IOException {
        if (!this.getStatusLine("response for PASV command: ")) {
            return false;
        }
        int i = this.statusStr.indexOf("(");
        String nstr = this.statusStr.substring(i + 1, this.statusStr.length() - 1);
        if (this.debug) {
            System.out.println(nstr);
        }
        StringTokenizer stk = new StringTokenizer(nstr, ",");
        StringBuffer sb = new StringBuffer();
        i = 0;
        while (i < 4) {
            sb.append(stk.nextToken());
            if (i != 3) {
                sb.append(".");
            }
            ++i;
        }
        this.dataIP = sb.toString();
        this.dataPort = Integer.parseInt(stk.nextToken()) * 256 + Integer.parseInt(stk.nextToken());
        if (this.debug) {
            System.out.println("Data channel at " + this.dataIP + ":" + this.dataPort);
        }
        return true;
    }

    private boolean getUserResp() throws IOException {
        return this.getStatusLine("response for USER command: ");
    }

    private boolean getStatusLine(String s) throws IOException {
        this.statusStr = this.br.readLine();
        if (this.debug) {
            System.out.println(String.valueOf(s) + this.statusStr);
        }
        if (this.statusStr == null || this.statusStr.trim().length() == 0) {
            return false;
        }
        int resp = Integer.parseInt(this.statusStr.trim().substring(0, 3));
        return resp < 400;
    }

    private boolean getPassResp() throws IOException {
        if (!this.getStatusLine("response for PASS command: ")) {
            return false;
        }
        while (true) {
            String str;
            if ((str = this.br.readLine()).indexOf("ok") != -1) {
                if (!this.debug) break;
                System.out.println(str);
                break;
            }
            if (!this.debug) continue;
            System.out.println(str);
        }
        return true;
    }

    private void println(String s) throws IOException {
        String str = String.valueOf(s) + "\r\n";
        this.outs.write(str.getBytes());
    }
}

