/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import jdbees.JBeesConfInfo;
import jdbees.JBeesLocalFile;
import jdbees.JBeesTeam;
import jdbees.ftp.JBeesFtpControlChannel;
import jdbees.ftp.JBeesFtpDataChannel;
import jdbees.ftp.JBeesFtpDataServer;

public class JBeesFtpBee
implements Runnable {
    private boolean debug = false;
    private URL url;
    private JBeesConfInfo jbconf;
    private JBeesLocalFile localFile;
    private JBeesTeam jbt;
    private long remoteBegin;
    private long remoteEnd;
    private int index;
    private boolean interrupted = false;
    private String user;
    private String passwd;
    private JBeesFtpControlChannel jfcc;
    private JBeesFtpDataChannel jfdc;
    private JBeesFtpDataServer jfds;

    public JBeesFtpBee(URL url, JBeesConfInfo jbconf, JBeesLocalFile jblf, JBeesTeam jbt, long begin, long end, int index) {
        this(url, null, null, jbconf, jblf, jbt, begin, end, index);
    }

    public JBeesFtpBee(URL url, String user, String passwd, JBeesConfInfo jbconf, JBeesLocalFile jblf, JBeesTeam jbt, long begin, long end, int index) {
        this.url = url;
        this.jbconf = jbconf;
        this.localFile = jblf;
        this.jbt = jbt;
        this.remoteBegin = begin;
        this.remoteEnd = end;
        this.index = index;
        this.user = user;
        this.passwd = passwd;
    }

    public void run() {
        block7: {
            try {
                this.getControlChannel();
                this.jfcc.authenticate();
                this.jfcc.setByteType();
                if (this.jfcc.isPasvSupported()) {
                    String dataIP = this.jfcc.getDataIP();
                    int dataPort = this.jfcc.getDataPort();
                    this.jfdc = new JBeesFtpDataChannel(dataIP, dataPort, this.jbconf);
                } else {
                    int localActivePort = this.jfcc.getLocalActivePort();
                    if (this.debug) {
                        System.out.println("data server listen at " + localActivePort);
                    }
                    this.jfds = new JBeesFtpDataServer(localActivePort);
                    this.jfcc.setPort();
                }
                this.jfcc.isRestSupported(this.remoteBegin);
                this.jfcc.setRetr(this.url.getPath());
                this.getContentBody();
                if (this.jfdc != null) {
                    this.jfdc.close();
                } else {
                    this.jfds.close();
                }
                this.jfcc.close();
            }
            catch (Exception e) {
                if (!this.debug) break block7;
                System.out.println(e);
            }
        }
    }

    private void getContentBody() throws IOException {
        DataInputStream dis;
        if (this.jfdc != null) {
            dis = this.jfdc.getDataInputStream();
        } else {
            this.jfds.accept(this.jbconf.getSocketTimeout());
            dis = this.jfds.getDataInputStream();
        }
        long readLn = 0L;
        long length = this.remoteEnd - this.remoteBegin + 1L;
        while (readLn < length && !this.interrupted) {
            byte[] byteArr = length - readLn > 1024L ? new byte[1024] : new byte[(int)(length - readLn)];
            int l = dis.read(byteArr);
            if (l == -1) {
                throw new EOFException("Abnormal end of file.");
            }
            if (l > 0) {
                this.localFile.writeBytes(byteArr, this.remoteBegin + readLn);
                this.jbt.updateRate(l);
            }
            readLn += (long)l;
            if (this.jbt == null) continue;
            this.jbt.updateResumeBegin(this.index, this.remoteBegin + readLn);
        }
        if (this.debug) {
            System.out.println("OK");
        }
    }

    public void setInterrupted(boolean v) {
        this.interrupted = v;
    }

    private void getControlChannel() throws IOException {
        this.jfcc = this.user == null ? new JBeesFtpControlChannel(this.url, this.jbconf) : new JBeesFtpControlChannel(this.url, this.jbconf, this.user, this.passwd);
    }
}

