/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jdbees.JBeesUtils;

class JBeesDateTimePanel
extends JPanel {
    private JLabel monthLabel;
    private JLabel dayLabel;
    private JLabel hourLabel;
    private JLabel minuteLabel;
    private JLabel ampmLabel;
    private JComboBox monthBox;
    private JComboBox dayBox;
    private JComboBox hourBox;
    private JComboBox ampmBox;
    private JTextField minuteText;
    private String[] monthValue = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "NOV", "DEC"};
    private String[] dayValue = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private String[] hourValue = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private String[] ampmValue = new String[]{"AM", "PM"};
    private String year;

    public JBeesDateTimePanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Schedule Time"));
        GregorianCalendar calendar = new GregorianCalendar();
        this.year = "" + calendar.get(1);
        this.monthLabel = new JLabel("Month");
        this.dayLabel = new JLabel("Day");
        this.hourLabel = new JLabel("Hour");
        this.minuteLabel = new JLabel("Minute");
        this.ampmLabel = new JLabel("AM/PM");
        this.monthBox = new JComboBox<String>(this.monthValue);
        this.monthBox.setSelectedIndex(calendar.get(2) - 1);
        this.dayBox = new JComboBox<String>(this.dayValue);
        this.dayBox.setSelectedIndex(calendar.get(5) - 1);
        this.hourBox = new JComboBox<String>(this.hourValue);
        int currentHour = calendar.get(10);
        int ampmIndex = calendar.get(9);
        if (currentHour == 0) {
            if (ampmIndex == 0) {
                this.hourBox.setSelectedIndex(0);
            } else {
                this.hourBox.setSelectedIndex(12);
            }
        } else {
            this.hourBox.setSelectedIndex(calendar.get(10));
        }
        this.minuteText = new JTextField(4);
        this.minuteText.setText("" + calendar.get(12));
        this.ampmBox = new JComboBox<String>(this.ampmValue);
        this.ampmBox.setSelectedIndex(calendar.get(9));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        JBeesUtils.add(this.monthLabel, gbc, this, 0, 0, 1, 1);
        JBeesUtils.add(this.dayLabel, gbc, this, 1, 0, 1, 1);
        JBeesUtils.add(this.hourLabel, gbc, this, 2, 0, 1, 1);
        JBeesUtils.add(this.minuteLabel, gbc, this, 3, 0, 1, 1);
        JBeesUtils.add(this.ampmLabel, gbc, this, 4, 0, 1, 1);
        JBeesUtils.add(this.monthBox, gbc, this, 0, 1, 1, 1);
        JBeesUtils.add(this.dayBox, gbc, this, 1, 1, 1, 1);
        JBeesUtils.add(this.hourBox, gbc, this, 2, 1, 1, 1);
        JBeesUtils.add(this.minuteText, gbc, this, 3, 1, 1, 1);
        JBeesUtils.add(this.ampmBox, gbc, this, 4, 1, 1, 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 100);
    }

    public String getMonth() {
        return (String)this.monthBox.getSelectedItem();
    }

    public String getDay() {
        return (String)this.dayBox.getSelectedItem();
    }

    public String getHour() {
        return (String)this.hourBox.getSelectedItem();
    }

    public String getMinute() {
        return this.minuteText.getText().trim();
    }

    public String getAMPM() {
        return (String)this.ampmBox.getSelectedItem();
    }

    public String getYear() {
        return this.year;
    }

    public void setDateTime(String dateStr) {
        dateStr = dateStr.replace('-', ':');
        dateStr = dateStr.replace(' ', ':');
        StringTokenizer stk = new StringTokenizer(dateStr, ":");
        String dayStr = stk.nextToken();
        String monStr = stk.nextToken();
        this.year = stk.nextToken();
        String hourStr = stk.nextToken();
        this.minuteText.setText(stk.nextToken());
        stk.nextToken();
        String ampmStr = stk.nextToken();
        this.dayBox.setSelectedIndex(this.getIndex(this.dayValue, dayStr));
        this.monthBox.setSelectedIndex(this.getIndex(this.monthValue, monStr));
        this.hourBox.setSelectedIndex(this.getIndex(this.hourValue, hourStr));
        this.ampmBox.setSelectedIndex(this.getIndex(this.ampmValue, ampmStr));
    }

    private int getIndex(String[] v, String key) {
        int i = 0;
        while (i < v.length) {
            if (key.equalsIgnoreCase(v[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

