/****************************************************

	JConfig Source Code Distribution
	version: 2.2.0      written: 08/23/2002 12:23 PM PDT

	Unless otherwise noted, all contents
	Copyright (c) 1997-2002 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

package com.jconfig;

import java.io.*;
import java.util.Vector;

/**
Stores a default version of the file 'jconfig.cfg' as an array of Strings. Each character
of a String.represents one nibble (.5 bytes) of the reconstituted file.

<P>
The 'getBuf()' method returns a byte array containing the bytes of the default 'jconfig.cfg' file.
Note that the buffer itself is returned, not a copy. This class is currently only used by ConfigListFile,
and is intended for internal use only.

@author Copyright (c) 1997-2002 Samizdat Productions. All Rights Reserved.
*/

class ConfigListDefault {
	private static final String copyrightString = "JConfig Copyright (c) 1997-2002 Samizdat Productions. All Rights Reserved.";

	private static final String		kNumStr = "0123456789";
	private static final String		kAlphaStr = "ABCDEF";

	private static byte theBuf[] = null;

	private static String data[] = {
				"00000000004D0016000042494E4168446D70000000000000000500074865784564697400186170706C69636174696F6E2F6F",
				"637465742D73747265616D13556E74797065642042696E61727920446174610036001600005354726B5354726B0000000000",
				"000005052E386D65640D536F756E642D547265636B65720000094D4F44204D75736963003B001600003853565842536E6400",
				"00000000000005052E3873767812427269616E277320536F756E6420546F6F6C00000957415620536F756E64003500160000",
				"544558544D5053200000000000000004022E61094D5057205368656C6C00000F417373656D626C7920536F75726365004100",
				"16000041494646534E444D0000000000000005042E6169660C536F756E644D616368696E65000C617564696F2F782D616966",
				"660A4149464620536F756E6400420016000041494646534E444D0000000000000005052E616966630C536F756E644D616368",
				"696E65000C617564696F2F782D616966660A4149464620536F756E6400420016000041494646534E444D0000000000000005",
				"052E616966660C536F756E644D616368696E65000C617564696F2F782D616966660A4149464620536F756E64003F00160000",
				"42494E4161726340534954780000000D042E617263064172634D6163105374756666497420457870616E646572000A504320",
				"41524368697665003D0016000054455854747478740000000000000024042E6173630A53696D706C6554657874000A746578",
				"742F706C61696E0A41534349492054657874003F0016000054455854747478740000000000000024062E61736369690A5369",
				"6D706C6554657874000A746578742F706C61696E0A41534349492054657874003E00160000554C4157534E444D0000000000",
				"000005032E61750C536F756E644D616368696E65000B617564696F2F62617369630953756E20536F756E6400420016000042",
				"494E41415649430000000000000005042E6176691141564920746F205154205574696C6974790009766964656F2F61766909",
				"415649204D6F76696500350016000042415246533639310000000000000005042E6261720653756E546172000010556E6978",
				"204241522041726368697665003A0016000054455854747478740000000000000004042E6261740A53696D706C6554657874",
				"0000114D532D444F532042617463682046696C65005A0016000042494E414D423250534954780000000D042E62696E0D4D61",
				"6342696E6172792049492B105374756666497420457870616E646572156170706C69636174696F6E2F6D616362696E617279",
				"094D616342696E61727900540016000042494E4168446D700000000000000005072E62696E61727907486578456469740018",
				"6170706C69636174696F6E2F6F637465742D73747265616D13556E74797065642042696E6172792044617461003500160000",
				"424D50704A5657520000000000000005042E626D70084A5045475669657700000E57696E646F7773204269746D6170003100",
				"160000544558544D4D43430000000000000004022E630C4D6574726F7765726B7320430000084320536F7572636500370016",
				"0000504346415357494E0000000000000005042E636F6D0B536F667457696E646F777300000D4D532D444F532042696E6172",
				"79003400160000544558544D4D43430000000000000004032E63700C4D6574726F7765726B73204300000A432B2B20536F75",
				"726365003500160000544558544D4D43430000000000000004042E6370700C4D6574726F7765726B73204300000A432B2B20",
				"536F75726365004D001600005041435443504354534954780000000D042E6370740B436F6D706163742050726F1053747566",
				"66497420457870616E6465720013436F6D706163742050726F2041726368697665003500160000434F4D50464F582B000000",
				"0000000005042E64626608466F78426173652B00000E444261736520446F63756D656E74003800160000444C2020416E5677",
				"0000000000000005032E646C0E4D6163416E696D2056696577657200000C444C20416E696D6174696F6E0035001600005043",
				"464C5357494E0000000000000005042E646C6C0B536F667457696E646F777300000B57696E646F777320444C4C0045001600",
				"005744424E4D5357440000000000000005042E646F63074D5320576F726400126170706C69636174696F6E2F6D73776F7264",
				"0D576F726420446F63756D656E740034001600004F4456494F5445580000000000000005042E647669054F7A546558000010",
				"5465582044564920446F63756D656E74004C0016000045505346766772640000000000000005042E6570730D4C6173657257",
				"7269746572203800166170706C69636174696F6E2F706F73747363726970740A506F7374736372697074004D001600004550",
				"5346766772640000000000000005052E657073660D4C61736572577269746572203800166170706C69636174696F6E2F706F",
				"73747363726970740A506F737473637269707400380016000054455854522A63680000000000000004042E65747806424245",
				"646974000D746578742F782D73657465787406534554657874003200160000454E5944454E56590000000000000005042E65",
				"767905456E766F7900000E456E766F7920446F63756D656E74003700160000504346415357494E0000000000000005042E65",
				"78650B536F667457696E646F777300000D4D532D444F532042696E617279003A00160000464C4920416E5677000000000000",
				"0005042E666C690E4D6163416E696D2056696577657200000D464C4920416E696D6174696F6E004100160000464D5052464D",
				"50520000000000000005032E666D0D46696C654D616B65722050726F00001646696C654D616B65722050726F204461746162",
				"617365003B00160000474946664A5657520000000000000005042E676966084A504547566965770009696D6167652F676966",
				"0B474946205069637475726500380016000042494E41416E56770000000000000005032E676C0E4D6163416E696D20566965",
				"77657200000C474C20416E696D6174696F6E004400160000477A6970477A6970534954780000000D032E677A074D6163477A",
				"6970105374756666497420457870616E646572000F476E75205A49502041726368697665003700160000544558544D4D4343",
				"0000000000000004022E680C4D6574726F7765726B73204300000E4320496E636C7564652046696C65003800160000544558",
				"544D4D43430000000000000004032E68700C4D6574726F7765726B73204300000E4320496E636C7564652046696C65003900",
				"160000544558544D4D43430000000000000004042E6870700C4D6574726F7765726B73204300000E4320496E636C75646520",
				"46696C6500530016000054455854522A6368534954780000000C042E68717806424245646974105374756666497420457870",
				"616E646572186170706C69636174696F6E2F6D61632D62696E68657834300642696E486578003800160000544558544D4F53",
				"210000000000000004052E68746D6C064D6F736169630009746578742F68746D6C0948797065725465787400410016000049",
				"454620474B4F4E0000000000000005042E6965661047726170686963436F6E7665727465720009696D6167652F6965660949",
				"454620696D616765003D001600004A5045474A5657520000000000000005042E6A7065084A50454756696577000A696D6167",
				"652F6A7065670C4A5045472050696374757265003E001600004A5045474A5657520000000000000005052E6A706567084A50",
				"454756696577000A696D6167652F6A7065670C4A5045472050696374757265003D001600004A5045474A5657520000000000",
				"000005042E6A7067084A50454756696577000A696D6167652F6A7065670C4A5045472050696374757265003E001600005445",
				"58544F5445580000000000000004062E6C61746578054F7A54657800136170706C69636174696F6E2F782D6C61746578054C",
				"617465780032001600004C4841204C4152430000000000000005042E6C6861064D61634C484100000D4C4841726320417263",
				"686976650032001600004C4841204C4152430000000000000005042E6C7A68064D61634C484100000D4C4841726320417263",
				"686976650033001600004D696469747478740000000000000005042E6D69640A53696D706C655465787400000A4D49444920",
				"536F756E64003700160000544558544672616D0000000000000004042E6D69660A4672616D654D616B657200000E4672616D",
				"654D616B6572204D4946003F00160000544558546D50414B0000000000000004052E6D696D65054D7061636B000E6D657373",
				"6167652F7266633832320C4D494D45204D6573736167650039001600005354726B5354726B0000000000000005042E6D6F64",
				"1154686520536F756E642D547265636B65720000094D4F4420536F756E640048001600004D6F6F5674747874000000000000",
				"0005052E6D6F6F760A53696D706C6554657874000F766964656F2F717569636B74696D650F517569636B54696D65204D6F76",
				"69650047001600004D6F6F56747478740000000000000005042E6D6F760A53696D706C6554657874000F766964656F2F7175",
				"69636B74696D650F517569636B54696D65204D6F766965003A001600004D5045476D4D50470000000000000005042E6D7065",
				"07537061726B6C65000A766964656F2F6D7065670A4D504547204D6F766965003B001600004D5045476D4D50470000000000",
				"000005052E6D70656707537061726B6C65000A766964656F2F6D7065670A4D504547204D6F766965003A001600004D504547",
				"6D4D50470000000000000005042E6D706707537061726B6C65000A766964656F2F6D7065670A4D504547204D6F7669650050",
				"00160000574F52444D5749490000000000000005032E6D770B4D6163577269746520494900166170706C69636174696F6E2F",
				"6D616377726974656969114D6163577269746520446F63756D656E74005200160000574F52444D5749490000000000000005",
				"052E6D7769690B4D6163577269746520494900166170706C69636174696F6E2F6D616377726974656969114D616357726974",
				"6520446F63756D656E74003E001600005043464C5357494E0000000000000005042E6F626A0B536F667457696E646F777300",
				"00144F626A6563742028444F532F57696E646F7773290050001600004F4449464F4441200000000000000005042E6F646116",
				"4D61634F44412058544E44205472616E736C61746F72000F6170706C69636174696F6E2F6F64610C4F444120446F63756D65",
				"6E74003F001600005043464C5357494E0000000000000005042E6F766C0B536F667457696E646F77730000154F7665726C61",
				"792028444F532F57696E646F777329003B00160000544558544D5750530000000000000004022E70114D6574726F7765726B",
				"732050617363616C00000D50617363616C20536F75726365003D00160000544558544D5750530000000000000004042E7061",
				"73114D6574726F7765726B732050617363616C00000D50617363616C20536F757263650055001600005050474D474B4F4E00",
				"00000000000005042E70626D1047726170686963436F6E7665727465720017696D6167652F782D706F727461626C652D6269",
				"746D61700F506F727461626C65204269746D617000410016000050494354747478740000000000000005042E7063740A5369",
				"6D706C6554657874000C696D6167652F782D706963740C504943542050696374757265005300160000504446204341524F00",
				"00000000000005042E7064660E4163726F62617420526561646572000F6170706C69636174696F6E2F70646617506F727461",
				"626C6520446973706C617920466F726D61740057001600005050474D474B4F4E0000000000000005042E70676D1047726170",
				"686963436F6E7665727465720018696D6167652F782D706F727461626C652D677261796D617010506F727461626C65204772",
				"61796D617000420016000050494354747478740000000000000005052E706963740A53696D706C6554657874000C696D6167",
				"652F782D706963740C504943542050696374757265003D0016000050495420534954780000000000000005042E7069741053",
				"74756666497420457870616E64657200000E5061636B497420417263686976650049001600004842534647454F4C53495478",
				"0000000D042E706B67094170706C654C696E6B105374756666497420457870616E64657200114170706C654C696E6B205061",
				"636B616765003000160000544558544D63504C0000000000000004032E706C074D61635065726C00000B5065726C20536F75",
				"726365003A00160000414C4234414C44340000000000000005042E706D3409506167654D616B6572000012506167654D616B",
				"657220446F63756D656E740055001600005050474D474B4F4E0000000000000005042E70706D1047726170686963436F6E76",
				"65727465720017696D6167652F782D706F727461626C652D7069786D61700F506F727461626C65205069786D6170004B0016",
				"000054455854766772640000000000000005032E70730D4C61736572577269746572203800166170706C69636174696F6E2F",
				"706F73747363726970740A506F73745363726970740046001600004D6F6F56747478740000000000000005032E71740A5369",
				"6D706C6554657874000F766964656F2F717569636B74696D650F517569636B54696D65204D6F766965004300160000544558",
				"54522A63680000000000000004072E726561646D650642424564697400106170706C69636174696F6E2F746578740B546578",
				"7420526561646D65003800160000524C4520474B4F4E0000000000000005042E726C651047726170686963436F6E76657274",
				"6572000009524C4520696D61676500360016000046524C21524550210000000000000005042E72706C075265706C69636100",
				"00105265706C69636120446F63756D656E74004500160000544558544D5357440000000000000004042E727466074D532057",
				"6F7264000F6170706C69636174696F6E2F7274661052696368205465787420466F726D6174003B0016000054455854522A63",
				"680000000000000004042E72747806424245646974000D746578742F726963687465787409526963682054657874004D0016",
				"00004150504C3F3F3F3F0000000000000007042E7365611753656C662045787472616374696E672041726368697665000017",
				"53656C662D45787472616374696E6720417263686976650045001600005349544453495421534954780000000D042E736974",
				"0753747566664974105374756666497420457870616E646572000F5374756666497420417263686976650068001600005445",
				"5854522A6368534954780000000C072E73697468717806424245646974105374756666497420457870616E64657218617070",
				"6C69636174696F6E2F6D61632D62696E68657834301842696E48657865642053747566664974204172636869766500340016",
				"0000544558545843454C0000000000000005042E73796B05457863656C00001053594C4B2053707265616473686565740035",
				"00160000544558545843454C0000000000000005052E73796C6B05457863656C00001053594C4B2053707265616473686565",
				"7400360016000054415246533639310000000000000005042E7461720653756E546172000011556E69782054617065204152",
				"63686976650046001600005A49564D534954780000000000000005042E74617A105374756666497420457870616E64657200",
				"0017436F6D7072657373656420546170652041526368697665003000160000544558544F5445580000000000000004042E74",
				"6578054F7A54655800000C54655820446F63756D656E74003100160000544558544F5445580000000000000004052E746578",
				"69054F7A54655800000C54655820446F63756D656E74003400160000544558544F5445580000000000000004082E74657869",
				"6E666F054F7A54655800000C54655820446F63756D656E74003E0016000054455854747478740000000000000024052E7465",
				"78740A53696D706C6554657874000A746578742F706C61696E0A41534349492054657874004500160000477A697053495478",
				"0000000000000005042E74677A105374756666497420457870616E646572000016476E75205A495065642054617065204152",
				"6368697665003D00160000544946464A5657520000000000000005042E746966084A50454756696577000A696D6167652F74",
				"6966660C544946462050696374757265003E00160000544946464A5657520000000000000005052E74696666084A50454756",
				"696577000A696D6167652F746966660C54494646205069637475726500520016000054455854522A63680000000000000004",
				"042E747376064242456469740019746578742F7461622D7365706172617465642D76616C7565731454616220536570657261",
				"7465642056616C756573003D0016000054455854747478740000000000000004042E7478740A53696D706C6554657874000A",
				"746578742F706C61696E0A41534349492054657874003F0016000054455854522A63680000000000000004042E7478740F42",
				"4245646974204C69746520342E30000A746578742F706C61696E0745726173654D450048001600004155524C417263680000",
				"000000000005042E75726C08416E61726368696500156D6573736167652F65787465726E616C2D626F64790C55524C20426F",
				"6F6B6D61726B00320016000054455854522A63687575554E0000000C032E757506424245646974067575556E646F00085555",
				"456E636F646500330016000054455854522A63687575554E0000000C042E75756506424245646974067575556E646F000855",
				"55456E636F6465003A001600006F76632042536E640000000000000005042E766F6312427269616E277320536F756E642054",
				"6F6F6C000009564F4320536F756E6400580016000057505043575043320000000000000005042E7735310B576F7264506572",
				"66656374001A6170706C69636174696F6E2F776F726470657266656374352E3114576F72645065726665637420446F63756D",
				"656E74003400160000574156455343504C0000000000000005042E77617608536F756E6441707000000D57696E646F777320",
				"536F756E64003500160000544558545843454C0000000000000005042E776B3105457863656C0000114C6F74757320537072",
				"6561647368656574003500160000544558545843454C0000000000000005042E776B7305457863656C0000114C6F74757320",
				"537072656164736865657400570016000057505043575043320000000000000005032E77700B576F72645065726665637400",
				"1A6170706C69636174696F6E2F776F726470657266656374352E3114576F72645065726665637420446F63756D656E740058",
				"0016000057505043575043320000000000000005042E7770350B576F726450657266656374001A6170706C69636174696F6E",
				"2F776F726470657266656374352E3114576F72645065726665637420446F63756D656E74004B0016000058424D20474B4F4E",
				"0000000000000005042E78626D1047726170686963436F6E766572746572000B696D6167652F782D78626D11582057696E64",
				"6F77732050696374757265003700160000584C53345843454C0000000000000005032E786C084D5320457863656C00001145",
				"7863656C205370726561647368656574003200160000584C43345843454C0000000000000005042E786C63084D5320457863",
				"656C00000B457863656C204368617274003200160000584C4D345843454C0000000000000005042E786C6D084D5320457863",
				"656C00000B457863656C204D6163726F003800160000584C53345843454C0000000000000005042E786C73084D5320457863",
				"656C000011457863656C205370726561647368656574004D001600005A49564D4C5A4956534954780000000D022E5A0B4D61",
				"63436F6D7072657373105374756666497420457870616E6465720015556E697820436F6D7072657373204172636869766500",
				"51001600005A4950205A495020534954780000000D042E7A6970055A69704974105374756666497420457870616E6465720F",
				"6170706C69636174696F6E2F7A69700E5043205A4950204172636869766500420016000054455854522A6368000000000000",
				"000406726561646D650642424564697400106170706C69636174696F6E2F746578740B5465787420526561646D6500490016",
				"000054455854522A63680000000000000004052E6A6176610F424245646974204C69746520342E30000A746578742F706C61",
				"696E104A61766120536F757263652046696C65"
};


	static byte[] getBuf() {
		if ( theBuf == null )
			theBuf = reconstitute( data );

		return theBuf;
	}

	private static byte[] reconstitute( String st[] ) {
		int			numStrs, numBytes, i, offset;
		byte		retBuf[];

		numStrs = st.length;
		numBytes = 0;
		for ( i = 0; i < numStrs; i++ )
			numBytes += st[ i ].length();

		numBytes /= 2;
		retBuf = new byte[ numBytes ];

		for ( i = 0, offset = 0; i < numStrs; i++ ) {
			readString( st[ i ], retBuf, offset );
			offset += st[ i ].length() / 2;
		}

		return retBuf;
	}

	private static void readString( String s, byte buf[], int offset ) {
		int				i, len, up, dn;
		char			cc1, cc2;

		len = s.length();
		for ( i = 0; i < len; i += 2, offset++ ) {
			cc1 = s.charAt( i );
			cc2 = s.charAt( i + 1 );

			up = kNumStr.indexOf( cc1 );
			if ( up < 0 )
				up = kAlphaStr.indexOf( cc1 ) + 10;

			dn = kNumStr.indexOf( cc2 );
			if ( dn < 0 )
				dn = kAlphaStr.indexOf( cc2 ) + 10;

			up = up << 4;
			up = up & 0xF0;
			dn = dn & 0xF;

			buf[ offset ] = (byte) ( up | dn );
		}
	}
} 


