package com.tolstoy.imagemeister;

import com.jconfig.*;
import java.io.*;
import java.awt.*;
import java.util.*;

/**
This class contains the main() method which initializes JConfig and creates a Browser object.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

public class Starter {
	private static final String copyright="ImageMeister Copyright (c) 1998,1999,2000 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	private static final String		kDataFolderName = "data";

	public static void main( String args[] ) {
		File			tempFile;
		String			dataDir;

		try {
			dataDir = System.getProperty( "user.dir" );
			if ( !dataDir.endsWith( File.separator ) )
				dataDir += File.separator;

			dataDir += kDataFolderName + File.separator;

			tempFile = new File( dataDir );

				//	output all trace messages to System.out
			Trace.setDestination( Trace.TRACE_SYSOUT );

			FileRegistry.initialize( tempFile, 0 );
			if ( !FileRegistry.isInited() ) {
				Trace.println( "Please check your configuration." );
				return;
			}

			new Browser( dataDir );
		}
		catch ( Exception e ) {
			Trace.println( "problems: " + e );
			e.printStackTrace( Trace.getOut() );
		}
	}
}
