package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
Displays information on an alias.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class SInfoVAlias extends SInfoViewer {
	DiskAlias		alias;

	public SInfoVAlias( DiskAlias da, OwnedFrame oldFrame, InfoViewerOwner onr,
						FileSpecifier spec, Rectangle rect ) {
		super( oldFrame, onr, spec, rect );
		alias = da;
	}

	void showInformation( Graphics g, int x, int y ) {
		DiskObject		resolvedObject;
		DiskAlias		da;
		String			s1, s2;
		int				type;

		s1 = "ALIAS @" + Integer.toHexString( alias.hashCode() ) + ": " +  alias.getName();

		type = alias.getAliasType();
		if ( type == DiskAlias.ALIAS_VOL ) s2 = "to volume";
		else if ( type == DiskAlias.ALIAS_DIR ) s2 = "to folder";
		else if ( type == DiskAlias.ALIAS_FILE ) s2 = "to file";
		else if ( type == DiskAlias.ALIAS_OTHER ) s2 = "to unknown";
		else if ( type == DiskAlias.ALIAS_NOLONGER ) s2 = "no longer alias";
		else s2 = "unknown type value";

		try {
			resolvedObject = FileRegistry.resolveAlias( alias, FileRegistry.ALIAS_NO_UI );
			if ( resolvedObject == null )
				s2 += ", resolveAlias returned null";
			else
				s2 += ": to " + resolvedObject.getName();
		}
		catch ( Exception e ) {
			s2 += " got exception resolving: " + e;
		}

		g.setColor( Color.red );
		g.drawString( s1, x, y );
		g.drawString( s2, x, y + 15 );
	}
}
