/*
	Gubshell(tm) is a test shell program for the Gubcast page
	push system.  It provides a GUI for pushing pages to Gubcast
	clients via Gubd.

	Author: Scott Burleigh
	Copyright 2000, 2001 by Glass Key Laboratories, Inc.
									*/
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

class Testclient
{
	String		clientName;
	InetAddress	host;
	int		portNbr;

	Testclient(String nm, InetAddress ia, int pn)
	{
		clientName = nm;
		host = ia;
		portNbr = pn;
	}	
};

class AboutGubshell extends Frame
{
	private TextArea	aboutText;

	//	Instance constructor

	AboutGubshell()
	{
		super("About Gubshell");
		aboutText = new TextArea("", 6, 44, TextArea.SCROLLBARS_NONE);
		aboutText.setEditable(false);
		aboutText.setFont(new Font("Monospaced", Font.PLAIN, 12));
		aboutText.append("Gubshell(tm) is a demonstration and test\n");
		aboutText.append("shell program for Gubcast, a Glass Key\n");
		aboutText.append("product.  Version 1.1\n");
		aboutText.append("\n");
		aboutText.append("http://www.glasskeylabs.com\n");
		aboutText.append("Copyright 2001 Glass Key Laboratories, Inc.");
		add(aboutText, BorderLayout.CENTER);
		addWindowListener
		(
		 //	Instance of anonymous inner class.
	 	 new WindowAdapter()
	 	 {
	  	  public void windowClosing(WindowEvent evt)
	  	  {
			setVisible(false);	//	Just pop down.
 	  	  }
 	 	 }
		);

		pack();
	}
}

class Gubshlistener extends Thread
{
	private DataInputStream	instream;
	private Vector		clients;
	private GubshellGUI	gui;

	void	gainClient(String clientName, InetAddress host, int portNbr)
	{
		Testclient	client;

		if (clientName == null || host == null
		|| portNbr < 1 || portNbr > 65535)
		{
			return;
		}

		client = new Testclient(clientName, host, portNbr);
		clients.add(client);
		gui.clientMenu.add(clientName);
		gui.clientMenu.invalidate();
		gui.validate();
	}

	void	loseClient(String clientName, InetAddress host,
			int portNbr)
	{
		int		length;
		int		i;
		Testclient	client;

		length = clients.size();
		for (i = 0; i < length; i++)
		{
			client = (Testclient) clients.get(i);
			if (client.portNbr == portNbr
			&& client.clientName.equals(clientName)
			&& client.host.equals(host))
			{
				clients.removeElementAt(i);
				gui.clientMenu.remove(i);
				return;
			}
		}
	}

	public void	run()
	{
		boolean		newClient;
		int		stringLength;
		byte		stringBuffer[];
		String		clientName;
		String		addressName;
		InetAddress	clientHost;
		int		clientPortNbr;

		//	Start registration handling loop.

		while (true)
		{
			try
			{
				//	Get nature of registration change.

				newClient = instream.readBoolean();

				//	Get name of client.

				stringLength = instream.readInt();
				if (stringLength == 0)
				{
					break;
				}

				stringBuffer = new byte[stringLength];
				instream.readFully(stringBuffer);
				clientName = new String(stringBuffer);

				//	Get IP address of client.

				stringLength = instream.readInt();
				if (stringLength == 0)
				{
					break;
				}

				stringBuffer = new byte[stringLength];
				instream.readFully(stringBuffer);
				addressName = new String(stringBuffer);
				clientHost = InetAddress.getByName(addressName);

				//	Get port number of client.

				clientPortNbr = instream.readInt();

				//	Update shell to reflect state change.

				if (newClient)
				{
					gainClient(clientName, clientHost,
							clientPortNbr);
				}
				else
				{
					loseClient(clientName, clientHost,
							clientPortNbr);
				}
			}
			catch (IOException x1)
			{
				if (x1 instanceof EOFException
				|| x1 instanceof SocketException
				|| x1 instanceof ProtocolException)
				{
					System.out.println("Gubd stopped; "
						+ "quitting.");
					System.exit(0);
				}

				System.out.println ("IOException in 'listener' "
					+ "thread of Gubshell: "
					+ x1.getMessage());
				x1.printStackTrace();
				System.exit(-1);
			}
		}
	}

	//	Instance constructor.

	Gubshlistener(DataInputStream instream, Vector clients, GubshellGUI gui)
	{
		super("gubsh_listener");
		this.instream = instream;
		this.clients = clients;
		this.gui = gui;
	}
}

class GubshellGUI extends Frame implements ActionListener
{
	private AboutGubshell		aboutGubshell;
	private MenuBar			menubar;
	private Menu			file;
	private	MenuItem		quit;
	private Menu			help;
	private	MenuItem		about;
		Choice			clientMenu;
	private CheckboxGroup		target;
	private Checkbox		namedFrame;
	private TextField		frameName;
	private Checkbox		newWindow;
	private Checkbox		currentFrame;
	private Checkbox		parentFrame;
	private Checkbox		topFrame;
	private TextField		url;
	private Button			push;
	private Label			errmsg;

	private Vector			clients;
	private DataOutputStream	outstream;

	public void	actionPerformed(ActionEvent evt)
	{
		String	cmd = evt.getActionCommand();
		if (cmd.equals("quit"))
		{
			System.exit(0);
		}

		if (cmd.equals("about"))
		{
			aboutGubshell.show();
		}
	}

	private void	showErrmsg(String text)
	{
		errmsg.setText(text);
		errmsg.invalidate();
		validate();
	}

	private void	constructGUI()
	{
		Panel	panel;

		setTitle("Gubshell");
		setLayout(new GridLayout(9, 1));	
		aboutGubshell = new AboutGubshell();
		menubar = new MenuBar();
		setMenuBar(menubar);
		target = new CheckboxGroup();

		file = new Menu("File");
		menubar.add(file);
		quit = new MenuItem("Quit", new MenuShortcut(KeyEvent.VK_Q));
		quit.addActionListener(this);
		quit.setActionCommand("quit");
		file.add(quit);

		help = new Menu("Help");
		menubar.add(help);
		menubar.setHelpMenu(help);
		about = new MenuItem("About", new MenuShortcut(KeyEvent.VK_A));
		about.addActionListener(this);
		about.setActionCommand("about");
		help.add(about);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    panel.add(new Label("Client: "));
		    clientMenu = new Choice();
		    panel.add(clientMenu);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    namedFrame = new Checkbox("Send to frame named....",
				target, true);
		    panel.add(namedFrame);
		    frameName = new TextField(40);
		    panel.add(frameName);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    newWindow = new Checkbox("Send to new window.", 
				target, false);
		    panel.add(newWindow);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    currentFrame = new Checkbox("Replace current frame.", 
				target, false);
		    panel.add(currentFrame);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    parentFrame = new Checkbox("Replace parent frame.", 
				target, false);
		    panel.add(parentFrame);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    topFrame = new Checkbox("Replace entire page.", 
				target, false);
		    panel.add(topFrame);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    panel.add(new Label("URL: "));
		    url = new TextField(80);
		    panel.add(url);

		panel = new Panel(new FlowLayout(FlowLayout.CENTER));
		add(panel);
		    push = new Button("Push content");
		    panel.add(push);

		push.addActionListener
		(
		 //	Instance of anonymous inner class.
	 	 new ActionListener()
	 	 {
	  	  public void actionPerformed(ActionEvent evt)
	  	  {
			int		clientIndex;
			Testclient	client;
			Checkbox	selectedTarget;
			String		targetName;
			String		urlText;
			String		addressName;

			urlText = url.getText();
			if (urlText == null
			|| urlText.length() < 1)
			{
				showErrmsg("Please enter URL of content.");
				return;
			}

			if (!(urlText.startsWith("http")))
			{
				urlText = "http://" + urlText;
			}

			if (clientMenu.getItemCount() == 0)
			{
				showErrmsg("No clients available to push to.");
				return;
			}

			clientIndex = clientMenu.getSelectedIndex();
			client = (Testclient) clients.get(clientIndex);
			selectedTarget = target.getSelectedCheckbox();
			if (selectedTarget == newWindow)
			{
				targetName = "_blank";
			}
			else if (selectedTarget == currentFrame)
			{
				targetName = "_self";
			}
			else if (selectedTarget == parentFrame)
			{
				targetName = "_parent";
			}
			else if (selectedTarget == topFrame)
			{
				targetName = "_top";
			}
			else	//	named frame
			{
				targetName = frameName.getText();
			}

			if (targetName == null
			|| targetName.length() < 1)
			{
				showErrmsg("Please enter name of frame.");
				return;
			}

			try
			{
				addressName = client.host.getHostAddress();
				outstream.writeInt(addressName.length());
				outstream.writeBytes(addressName);
				outstream.writeInt(client.portNbr);
				outstream.writeInt(targetName.length());
				outstream.writeBytes(targetName);
				outstream.writeInt(urlText.length());
				outstream.writeBytes(urlText);
			}
			catch (NoRouteToHostException x1)
			{
				showErrmsg("Client is not net-reachable.");
				return;
			}
			catch (ConnectException x2)
			{
				showErrmsg("Cannot connect to client.");
				return;
			}
			catch (IOException x3)
			{
				showErrmsg("I/O error contacting client.");
				return;
			}
 	  	  }
 	 	 }
		);

		panel = new Panel(new FlowLayout(FlowLayout.LEFT));
		add(panel);
		    errmsg = new Label("");
		    panel.add(errmsg);

		addWindowListener
		(
		 //	Instance of anonymous inner class.
	 	 new WindowAdapter()
	 	 {
	  	  public void windowClosing(WindowEvent evt)
	  	  {
			System.exit(0);
 	  	  }
 	 	 }
		);

		pack();
	}

	//	Instance constructor.

	GubshellGUI(DataOutputStream outstream, Vector clients)
	{
		super("Gubshell");
		this.outstream = outstream;
		this.clients = clients;
		constructGUI();
	}
}

public class Gubshell
{
	private static Gubshlistener	listener;

	public static void main(String[] args)
	{
		Vector			clients;
		int			daemonPortNbr = 5108;
		InetAddress		daemonHost;
		Socket			sock;
		DataInputStream		instream = null;
		DataOutputStream	outstream = null;
		GubshellGUI		gui;

		clients = new Vector();
		try
		{
			if (args.length == 0)
			{
				daemonHost = InetAddress.getLocalHost();
			}
			else
			{
				daemonHost = InetAddress.getByName(args[0]);
			}

			sock = new Socket(daemonHost, daemonPortNbr);
			instream =
				new DataInputStream(sock.getInputStream());
			outstream =
				new DataOutputStream(sock.getOutputStream());
		}
		catch (Exception x1)
		{
			System.out.println("Can't connect to Gubd: "
					+ x1.getMessage());
			System.exit(-1);
		}

		gui = new GubshellGUI(outstream, clients);
		listener = new Gubshlistener(instream, clients, gui);
		listener.setDaemon(true);
		listener.start();
		gui.show();
	}
}
