/*
	Gubd(tm) is a demonstration program for the Gubcast page
	push system.

	Author: Scott Burleigh
	Copyright 2000, 2001 by Glass Key Laboratories, Inc.
									*/
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import com.glasskeylabs.gubcast.*;

class Gubdregistry implements Gubregistry
{
	private static Hashtable	clients;
	private static Socket		shell;
	private static DataInputStream	instream;
	private static DataOutputStream	outstream;

	void	forwardClientState(Gubclient client, boolean state)
	{
		String		clientName = client.getClientName();
		InetAddress	host = client.getHost();
		int		portNbr = client.getPortNbr();
		String		addressName;

		if (shell == null)
		{
			return;
		}

		try
		{
			outstream.writeBoolean(state);
			outstream.writeInt(clientName.length());
			outstream.writeBytes(clientName);
			addressName = host.getHostAddress();
			outstream.writeInt(addressName.length());
			outstream.writeBytes(addressName);
			outstream.writeInt(portNbr);
		}
		catch (Exception x1)
		{
			System.out.println("Failed forwarding client state: "
					+ x1.getMessage());
			x1.printStackTrace();
		}
	}

	void	attachShell(Socket shell, DataInputStream instream,
			DataOutputStream outstream)
	{
		this.shell = shell;
		this.instream = instream;
		this.outstream = outstream;
	}

	void	detachShell()
	{
		this.shell = null;
		this.instream = null;
		this.outstream = null;
	}

	public void	registerClient(Gubclient client)
	{
		if (client == null)
		{
			return;
		}

		clients.put(client.getID(), client);
		forwardClientState(client, true);
	}

	public void	unregisterClient(InetAddress host, int portNbr)
	{
		String		key;
		Gubclient	client;

		key = Gubclient.composeID(host, portNbr);
		client = (Gubclient) clients.get(key);
		if (client == null)
		{
			return;
		}

		forwardClientState(client, false);
		clients.remove(key);
	}

	//	Instance constructor.

	Gubdregistry(Hashtable clients)
	{
		this.clients = clients;
	}
}

public class Gubd
{
	private static Hashtable	clients;
	private static Gubdregistry	registry;
	private static Gubcaster	gub;
	private static Socket		shell;
	private static DataInputStream	instream;
	private static DataOutputStream	outstream;

	public static void main(String[] args)
	{
		int		clientPortNbr = 4567;	//	5107
		int		shellPortNbr = 5108;
		ServerSocket	dialup = null;
		Enumeration	clientList;
		int		length;
		int		i;
		Gubclient	client;
		int		stringLength;
		byte		stringBuffer[];
		String		addressName;
		InetAddress	host = null;
		int		portNbr = -1;
		String		targetName;
		String		urlText;

		try
		{
			clients = new Hashtable();
			registry = new Gubdregistry(clients);
			gub = new Gubcaster(clientPortNbr, registry);
			dialup = new ServerSocket(shellPortNbr, 50);
		}
		catch (Exception x1)
		{
			System.out.println("Exception constructing Gubcaster: "
					+ x1.getMessage());
			System.exit(-1);
		}

		while (true)
		{
			//	Outer loop: once per shell attachment.

			try
			{
				shell = dialup.accept();
				instream = new DataInputStream
						(shell.getInputStream());
				outstream = new DataOutputStream
						(shell.getOutputStream());
				registry.attachShell(shell, instream,
						outstream);

				//	Tell shell who's registered.

				clientList = clients.elements();
				while (clientList.hasMoreElements())
				{
					registry.forwardClientState((Gubclient)
						clientList.nextElement(), true);
				}

				clientList = null;	//	release for gc
			}
			catch (Exception x1)
			{
				System.out.println("Exception on accept(): "
						+ x1.getMessage());
				break;	//	Shut down Gubd.
			}

			while (true)
			{
				//	Inner loop: once per page push.

				try
				{
					//	Get IP address to push to.

					stringLength = instream.readInt();
					if (stringLength == 0)
					{
						host = null;
					}
					else
					{
						stringBuffer = new
							byte[stringLength];
						instream.readFully
							(stringBuffer);
						addressName = new
							String(stringBuffer);
						host = InetAddress.getByName
							(addressName);
					}

					//	Get port number to push to.

					portNbr = instream.readInt();

					//	Get local interface to use.

					client = (Gubclient) clients.get
						(Gubclient.composeID
							(host, portNbr));
					if (client == null)
					{
						continue;	//	error
					}

					//	Get name of target to push to.

					stringLength = instream.readInt();
					if (stringLength == 0)
					{
						targetName = null;
					}
					else
					{
						stringBuffer = new
							byte[stringLength];
						instream.readFully
							(stringBuffer);
						targetName = new
							String(stringBuffer);
					}

					//	Get URL of page to push.

					stringLength = instream.readInt();
					if (stringLength == 0)
					{
						urlText = null;
					}
					else
					{
						stringBuffer = new
							byte[stringLength];
						instream.readFully
							(stringBuffer);
						urlText = new String
							(stringBuffer);
					}

					//	Push the page.

					if (targetName != null
					&& urlText != null)
					{
						try
						{
							gub.pushPage(client,
								targetName,
								urlText);
						}
						catch (SocketException x1)
						{
							registry.
							unregisterClient
								(host, portNbr);
						}
					}
				}
				catch (EOFException x1)
				{
					break;	//	Normal shell detach.
				}
				catch (SocketException x2)
				{
					break;	//	Abnormal shell detach.
				}
				catch (Exception x3)
				{
					System.out.println
						("Unknown Gubd failure: "
						+ x3.getMessage());
					x3.printStackTrace();
					break;	//	Next shell.
				}
			}

			registry.detachShell();
			try { shell.close(); } catch (Exception x1) {}
			shell = null;
			instream = null;
			outstream = null;
		}

		try { dialup.close(); } catch (Exception x1) {}
	}
}
