/*Data Access Library. v. 1.1.
 *Persistent object event support. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Support class for persistent object event dispatchers.
 *@see POCompleteListener
 *@see PersistentObject#addPOCompleteListener
 *@see PersistentObject#removePOCompleteListener
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public class POCompleteSupport extends ParameterSupport {

    public POCompleteSupport(Object src) {
	super(src);
    }

    public void addPOCompleteListener(POCompleteListener l) {
	addParameterListener(l);
    }

    public void fireCancelComplete() {
	POCompleteEvent ev = new POCompleteEvent(_source,"cancel()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof POCompleteListener)
		((POCompleteListener)_listeners[i]).cancelComplete(ev);
    }

    public void fireRetrieveComplete(String acnN, Object res) {
	POCompleteEvent ev = new POCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof POCompleteListener)
		((POCompleteListener)_listeners[i]).retrieveComplete(ev);
    }

    public void fireSPCComplete(String acnN, Object res) {
	POCompleteEvent ev = new POCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof POCompleteListener)
		((POCompleteListener)_listeners[i]).SPCComplete(ev);
    }

    public void fireUpdateComplete(String acnN) {
	POCompleteEvent ev = new POCompleteEvent(_source,acnN);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof POCompleteListener)
		((POCompleteListener)_listeners[i]).updateComplete(ev);
    }

    public void fireUpdateComplete(String acnN, Object res) {
	POCompleteEvent ev = new POCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof POCompleteListener)
		((POCompleteListener)_listeners[i]).updateComplete(ev);
    }

    public void removePOCompleteListener(POCompleteListener l) {
	removeParameterListener(l);
    }
}
