/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class PickListItemEditor
extends Panel
implements ItemEditor,
ItemListener,
KeyListener,
BlackBox,
Serializable {
    String currentColumnName;
    String[] sourceColumns;
    String[] targetColumns;
    Column[] pickListColumns;
    String[] displayColumns;
    DataSetView pickListDataSet;
    DataSet targetDataSet;
    DataRow locateRow;
    boolean cache;
    Variant value;
    Choice choice = new Choice();
    transient RowFilterListener listener;
    transient ItemEditSite editSite;

    public PickListItemEditor() {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.cache = true;
        this.value = new Variant();
        this.choice.addItemListener(this);
        this.choice.addKeyListener(this);
    }

    public final void setCachePickList(boolean cache) {
        this.cache = cache;
    }

    public final boolean isCachePickList() {
        return this.cache;
    }

    public final void addRowFilterListener(RowFilterListener listener) throws TooManyListenersException {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = listener;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.addRowFilterListener(listener);
        }
    }

    public final void removeRowFilterListener(RowFilterListener listener) {
        this.listener = null;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.removeRowFilterListener(listener);
        }
    }

    protected void loadPickList(PickListDescriptor pickList) {
        if (this.pickListDataSet == null || !this.cache) {
            this.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.pickListDataSet == null) {
                    pickList.getPickListDataSet().open();
                    this.pickListDataSet = pickList.getPickListDataSet().cloneDataSetView();
                    if (this.pickListDataSet.getRowFilterListener() != null) {
                        this.cache = false;
                    }
                    if (this.listener != null) {
                        if (this.pickListDataSet.getRowFilterListener() != null) {
                            this.pickListDataSet.removeRowFilterListener(this.pickListDataSet.getRowFilterListener());
                        }
                        this.pickListDataSet.addRowFilterListener(this.listener);
                    }
                    this.pickListDataSet.close();
                    this.pickListDataSet.setStorageDataSet(pickList.getPickListDataSet().getStorageDataSet());
                    this.sourceColumns = pickList.getPickListColumns();
                    this.targetColumns = pickList.getDestinationColumns();
                    this.displayColumns = pickList.getPickListDisplayColumns();
                    if (this.sourceColumns == null || this.sourceColumns.length == 0 || this.targetColumns == null || this.targetColumns.length == 0 || this.displayColumns == null || this.displayColumns.length == 0) {
                        this.pickListDataSet = null;
                        return;
                    }
                }
                this.pickListDataSet.open();
                this.locateRow = new DataRow((DataSet)this.pickListDataSet, this.sourceColumns);
                if (!this.cache) {
                    this.choice.removeAll();
                }
                int ordinal = this.pickListDataSet.getColumn(this.displayColumns[0]).getOrdinal();
                if (this.listener != null || this.listener == null && this.pickListDataSet.getRowFilterListener() != null) {
                    this.pickListDataSet.refilter();
                }
                this.pickListDataSet.first();
                while (this.pickListDataSet.inBounds()) {
                    this.choice.add(this.pickListDataSet.format(ordinal));
                    this.pickListDataSet.next();
                }
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.choice, "Center");
                }
            }
            catch (Exception ex) {
                this.pickListDataSet = null;
                DataSetModel.handleException(this, ex, true);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public Object getValue() {
        try {
            if (this.pickListDataSet != null) {
                this.pickListDataSet.goToRow(this.choice.getSelectedIndex());
            }
        }
        catch (DataSetException ex) {
            this.value.setUnassignedNull();
            DataSetModel.handleException(this, ex, true);
            Variant variant = this.value;
            return variant;
        }
        return this.pickListDataSet;
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        Column currentColumn = null;
        ColumnVariant currentColumnVariant = null;
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.editSite = editSite;
        if (data instanceof ColumnVariant) {
            currentColumnVariant = (ColumnVariant)data;
            this.value.setVariant(currentColumnVariant);
            currentColumn = currentColumnVariant.getColumn();
            this.currentColumnName = currentColumn.getColumnName();
            this.targetDataSet = currentColumnVariant.getDataSet();
            this.loadPickList(currentColumn.getPickList());
            if (this.pickListDataSet == null) {
                editSite.safeEndEdit(false);
            }
        }
        if (this.pickListDataSet != null && this.locateRow != null) {
            try {
                currentColumnVariant.getDataSet();
                ReadRow.copyTo(this.targetColumns, currentColumnVariant.getDataSet(), this.sourceColumns, this.locateRow);
                if (this.pickListDataSet.locate(this.locateRow, 32) && this.choice.getItemCount() > this.pickListDataSet.getRow()) {
                    this.choice.select(this.pickListDataSet.getRow());
                }
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this, ex, true);
            }
        }
        this.choice.invalidate();
        if (editSite != null) {
            this.choice.setBackground(editSite.getBackground());
            this.choice.setForeground(editSite.getForeground());
            this.choice.setFont(editSite.getFont());
        }
        this.validate();
        this.setVisible(true);
        this.choice.requestFocus();
    }

    public void changeBounds(Rectangle bounds) {
        this.choice.invalidate();
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.validate();
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean post) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        int code = e2.getKeyCode();
        int sel = this.choice.getSelectedIndex();
        switch (code) {
            case 39: 
            case 40: {
                if (sel < this.choice.getItemCount() - 1) {
                    this.choice.select(sel + 1);
                }
                e2.consume();
                break;
            }
            case 37: 
            case 38: {
                if (sel > 0) {
                    this.choice.select(sel - 1);
                }
                e2.consume();
                break;
            }
            case 36: {
                this.choice.select(0);
                e2.consume();
                break;
            }
            case 35: {
                this.choice.select(this.choice.getItemCount() - 1);
                e2.consume();
                break;
            }
            case 34: {
                this.choice.select(Math.min(sel + 10, this.choice.getItemCount() - 1));
                e2.consume();
                break;
            }
            case 33: {
                this.choice.select(Math.max(sel - 10, 0));
                e2.consume();
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void addKeyListener(KeyListener l2) {
        this.choice.addKeyListener(l2);
    }

    public void removeKeyListener(KeyListener l2) {
        this.choice.removeKeyListener(l2);
    }

    public void addFocusListener(FocusListener l2) {
        this.choice.addFocusListener(l2);
    }

    public void removeFocusListener(FocusListener l2) {
        this.choice.removeFocusListener(l2);
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getID() == 701) {
            this.editSite.safeEndEdit(true);
        }
    }
}

