// View.cpp : implementation of the CIPsinkView class
//
//	connection based sockets
//		server: ------------>this app
//			socket
//			bind
//			listen 
//			accept
//
//		client:
//			socket
//			connect
//
//	connectionless
//		server:
//			socket
//			sendto
//
//		client:
//			socket
//			recvfrom

#include "stdafx.h"
#include "ipsink.h"

#include "Doc.h"
#include "View.h"
#include "mainfrm.h"
#include "conndlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_WINSOCK_EVENT_LISTEN WM_APP+4	 // for winsock messages

/////////////////////////////////////////////////////////////////////////////
// CIPsinkView

IMPLEMENT_DYNCREATE(CIPsinkView, CEditView)

BEGIN_MESSAGE_MAP(CIPsinkView, CEditView)
	//{{AFX_MSG_MAP(CIPsinkView)
	ON_COMMAND(ID_CONNECT, OnConnect)
	ON_COMMAND(ID_CLOSECONN, OnCloseconn)
	ON_UPDATE_COMMAND_UI(ID_CLOSECONN, OnUpdateCloseconn)
	ON_UPDATE_COMMAND_UI(ID_CONNECT, OnUpdateConnect)
	ON_COMMAND(ID_CLEARVIEW, OnClearview)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_WINSOCK_EVENT_LISTEN,OnWinsockListenEvent)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIPsinkView construction/destruction
CIPsinkView::CIPsinkView()
{
	m_hSocket = NULL;
	WSAData WsaData;
	int ret = WSAStartup(0x0101, &WsaData);
	if (ret != 0)
	{
		AfxMessageBox("WSAStartup failed");
	}
}

CIPsinkView::~CIPsinkView()
{
	if (m_hSocket != NULL)
	{
		closesocket(m_hSocket); 
	}	
}

/////////////////////////////////////////////////////////////////////////////
BOOL CIPsinkView::PreCreateWindow(CREATESTRUCT& cs)
{
	BOOL bPreCreated = CEditView::PreCreateWindow(cs);

	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping

	cs.style |=	ES_READONLY; // make read only - it is a log window
	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CIPsinkView drawing

void CIPsinkView::OnDraw(CDC* pDC)
{
	CIPsinkDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CIPsinkView diagnostics

#ifdef _DEBUG
void CIPsinkView::AssertValid() const
{
	CEditView::AssertValid();
}

void CIPsinkView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CIPsinkDoc* CIPsinkView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CIPsinkDoc)));
	return (CIPsinkDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CIPsinkView message handlers

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::Log(const char * szBuffer)
{
	int nChars=GetWindowTextLength();    // get the index of the last line

 	// point end of document
	GetEditCtrl().SetSel( nChars,nChars );
	GetEditCtrl().ReplaceSel((LPCSTR)szBuffer);     // display text

	// defeat the final "save document" dialog on app exit
	GetDocument()->SetModifiedFlag(FALSE); 
}
   
/////////////////////////////////////////////////////////////////////////////
LONG CIPsinkView::OnWinsockListenEvent(WPARAM wParam, LPARAM lParam)
{
	// it is possible to get here and find m_hSendRcvSocket as NULL

	char szBuffer[1024];

	switch (WSAGETSELECTEVENT(lParam)) 	  // which message arrived?
	{
		case FD_CLOSE:
			{
			Log("UDPsink Status>Connection closed by client\r\n");
			KillSocket();
			break;
			}
		case FD_READ:
			{
			char * str;
			if (m_hListenSocket)
			{
				memset(szBuffer, 0, 1024);
				recv(m_hListenSocket, szBuffer, 1024, 0);
				str = strtok(szBuffer,"\n");

				while (str && *str)
				{
				   Log((const char *)str);
				   Log("\r\n");
				   str = strtok((char *)NULL,"\n");
				}
			}

			if (m_hListenAcceptSocket)
			{
				memset(szBuffer, 0, 1024);
				recv(m_hListenAcceptSocket, szBuffer, 1024, 0);
				str = strtok(szBuffer,"\n");

				while( str && *str)
				{
				   Log((const char *)str);
				   Log("\r\n");
				   str = strtok((char *)NULL,"\n");
				}
			}
			break;  
			}
		case FD_OOB:
			{
			ASSERT(0);
			break;  
			}
		case FD_ACCEPT:
			{
			if (m_hListenSocket == INVALID_SOCKET)
			{
				m_hListenAcceptSocket = INVALID_SOCKET;
			}
			else
			{
				m_hListenAcceptSocket = accept(m_hListenSocket, NULL, NULL);
			}
			ASSERT(m_hListenAcceptSocket != INVALID_SOCKET);
			break;
			}
		case FD_WRITE:
			{
			break;
			}
		default:
			{	
			ASSERT(0);
			break;
			}
	} // end of switch

	return 0L;
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::OnConnect() 
{
	CConnectDlg dlg;
	dlg.m_sHost = GetLocalDotName();
	dlg.m_sPort = AfxGetApp()->GetProfileString("Connect", "Port", "");
	if (dlg.m_sPort == "")
	{
		dlg.m_sPort = "80";
	}
	dlg.m_nProtocolMode = AfxGetApp()->GetProfileInt("Connect", "Protocol", 0);

	// run dialog
	if (dlg.DoModal() == IDOK)	  
	{
		m_eProtocolMode = (eProtocolMode)dlg.m_nProtocolMode;
		
		// housecleaning?
		if (dlg.m_bClearWindow)
		{
			GetEditCtrl().SetWindowText("");
		}

		if (dlg.m_sPort.GetLength() == 0)
		{
			AfxMessageBox("You must enter a port number.\n\nTry again.");
			return;
		}

		// become a server, too (always use my host IP address)
		eServerFail eSF = BecomeListeningServer((const char *)dlg.m_sHost, (const char *)dlg.m_sPort);

		if (eSF != eServerOK)
		{
			CString sRet;
			sRet.Format(SOCKERR " %d: Error on Listen.\n\n", WSAGetLastError());
			AfxMessageBox(sRet);
			KillSocket();
			return;
		}
		else
		{
			CString sMsg;
			sMsg.Format("Connected to %s on port %s", dlg.m_sHost, dlg.m_sPort);
			// update status bar pane
			CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
			ASSERT(pFWnd != NULL);
			pFWnd->MakePaneText(1, sMsg); 

			// save settings in ini file
			AfxGetApp()->WriteProfileString("Connect", "Port", dlg.m_sPort);
			AfxGetApp()->WriteProfileInt("Connect", "Protocol", dlg.m_nProtocolMode);
		}

	} // end of if on domodal

//	regarding the eSF values above (not the quality or result of a Send)... 
//
//	Port Number of all cases is 80
//
//	Client Destination == Local Machine
//	Server Site == Local Machine
//	------------------------------------
//	UDP		TCP
//	OK		OK

	// defeat the final "save document" dialog on app exit
	GetDocument()->SetModifiedFlag(FALSE); 
}

/////////////////////////////////////////////////////////////////////////////
// assumes no white space in arguments
eServerFail CIPsinkView::BecomeListeningServer(const char *szName, const char *szPort)
{
	SOCKET srv_sock;
	struct sockaddr_in srv_addr;
	LPHOSTENT lpHost;

	int nRet = 0;
   	
	memset((char *) &srv_addr,0,sizeof(srv_addr));

	srv_addr.sin_addr.s_addr = INADDR_ANY;		

	int nPortNumber = atoi(szPort);
	srv_addr.sin_port = htons(nPortNumber); 

	if ((szName[0] >= '0') && (szName[0] <= '9')) 
	{
		// would use this for numeric IP (dot address) 
		// 128.11.120.114 is Honeywell
		srv_addr.sin_family	= AF_INET;
		srv_addr.sin_addr.s_addr = inet_addr(szName);
	}
	else
	{
		// would use this for domain names
		// www.honeywell.com is Honeywell
		lpHost = gethostbyname(szName);
		if (lpHost == NULL)
		{
			return eServerFail1;
		}
		memcpy((char *)&srv_addr.sin_addr, (char *)lpHost->h_addr, lpHost->h_length);
		srv_addr.sin_family = lpHost->h_addrtype;
	}

	// create socket
	if (m_eProtocolMode == eUDP)
	{
		srv_sock = socket(PF_INET, SOCK_DGRAM, 0);
	}
	else
	{
		srv_sock = socket(PF_INET, SOCK_STREAM, 0); //SOCK_STREAM for TCP
	}
	
	if (srv_sock == INVALID_SOCKET)
	{
		return eServerFail2;
	}

	// Bind local socket
	nRet = bind(srv_sock, (LPSOCKADDR)&srv_addr, sizeof(srv_addr));
	if (nRet == SOCKET_ERROR)
	{
		closesocket(srv_sock);
		return eServerFail3;
	}

// DONT connect - that is what clients do and I am a listening server
//	nRet = connect(cli_sock, (LPSOCKADDR)&srv_addr, sizeof(srv_addr));
//	if (nRet == SOCKET_ERROR)
//	{
//		closesocket(cli_sock);
//		return eServerFail4;
//	}

	setsockopt(srv_sock, SOL_SOCKET,SO_LINGER, 0, 0);	
	setsockopt(srv_sock, SOL_SOCKET,SO_REUSEADDR, 0, 0);
	setsockopt(srv_sock, SOL_SOCKET,SO_KEEPALIVE, 0, 0);
	setsockopt(srv_sock, SOL_SOCKET,SO_OOBINLINE, 0, 0);

	nRet = WSAAsyncSelect(	srv_sock, 
							m_hWnd, 
							WM_WINSOCK_EVENT_LISTEN,
							FD_WRITE|FD_READ|FD_CLOSE|FD_OOB|FD_ACCEPT);		
	if (nRet == SOCKET_ERROR)
	{
		closesocket(srv_sock);
		int n = WSAGetLastError();
		return eServerFail5;
	}

	// for reasons I cannot explain nRet is -1 if connecting to local machine
	//	but that is NOT and error
	nRet = listen(srv_sock, SOMAXCONN);
//	if (nRet == SOCKET_ERROR)
//	{
//		closesocket(cli_sock);
//		int n = WSAGetLastError();
//		return eServerFail6;
//	}
	
	m_hListenSocket = srv_sock;
    return eServerOK;
}

/////////////////////////////////////////////////////////////
// use this function to connect to a host on a port
/*SOCKET CIPsinkView::ConnectToListen(const char *name, const char *port)
{
	SOCKET s = INVALID_SOCKET;

	struct sockaddr_in far server;
	struct hostent far *hp;
	char msg[100];

	int portnum = atoi(port);

	while (*name != 0 && *name == ' ')
	{
		name++;
	}

	if (*name == 0 || portnum == 0)
	{
		return INVALID_SOCKET;
	}

	if ((name[0] >= '0') && (name[0] <= '9')) 
	{
		memset((char *) &server,0,sizeof(server));
		server.sin_family = AF_INET;
		server.sin_addr.s_addr = inet_addr(name);
		server.sin_port = htons(portnum);
	}
	else
	{ 
		if ((hp = (hostent far *) gethostbyname(name)) == NULL)
		{
			sprintf(msg,"Error: Connecting to %s.", name);

			if (AfxMessageBox(msg,MB_OK | MB_ICONSTOP ) == IDOK)
			{
				return INVALID_SOCKET;
			}
		}
		memset((char *) &server,0,sizeof(server));
		memcpy((char *) &server.sin_addr,hp->h_addr,hp->h_length);
		server.sin_family = hp->h_addrtype;
		server.sin_port = htons(portnum);  
	}

	// create socket
	s = socket(AF_INET, SOCK_DGRAM, 0); 
	//s = socket(AF_INET, SOCK_STREAM, 0); //SOCK_STREAM for TCP
	if (SOCKET_ERROR == s || INVALID_SOCKET == s)
	{
		sprintf(msg,"Error opening stream socket");
		AfxMessageBox(msg,MB_OK | MB_ICONSTOP);
		return INVALID_SOCKET;
	}
  
	int n = bind(s, (struct sockaddr far *)&server, sizeof(server));
	if (n == SOCKET_ERROR)
	{
		sprintf(msg,"Cannot bind to %s on port %s",name,port);
		AfxMessageBox(msg,MB_OK | MB_ICONSTOP);
		return INVALID_SOCKET;
	}

	m_hSocket = s;
	setsockopt(m_hSocket, SOL_SOCKET,SO_LINGER, 0, 0);	
	setsockopt(m_hSocket, SOL_SOCKET,SO_REUSEADDR, 0, 0);
	setsockopt(m_hSocket, SOL_SOCKET,SO_KEEPALIVE, 0, 0);
	setsockopt(m_hSocket, SOL_SOCKET,SO_OOBINLINE, 0, 0);

	return s;		   
}*/

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::OnCloseconn() 
{
	ASSERT(m_hSocket != NULL);
	KillSocket();
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::OnClearview() 
{
	// clear the user input edit box
	GetEditCtrl().SetWindowText("");
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::KillSocket(void)
{
	ASSERT(m_hSocket != NULL);
	closesocket(m_hSocket);
	m_hSocket = NULL;

	// update status bar pane
	CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
	ASSERT(pFWnd != NULL);

	pFWnd->MakePaneText(1, "No connection"); 
}

/////////////////////////////////////////////////////////////////////////////
CString CIPsinkView::GetLocalDotName(void)
{
	CWaitCursor cwait;

	hostent * pMyHostEnt;
	char szMyName[100];
	memset(szMyName, 0, 100);
	gethostname(szMyName, 100);
	
	CString sLocalDotName = "";
	CString sLocalDotName1 = "";
	CString sLocalDotName1plus4 = "";
	
	pMyHostEnt = gethostbyname(szMyName);
	if (pMyHostEnt)
	{
		int nLenName = strlen(pMyHostEnt->h_name);
		int nLenList = strlen(*pMyHostEnt->h_addr_list);
		BOOL bDo2 = FALSE;
		if (nLenName && nLenList)
		{
			int nDiff = nLenList-nLenName;
			if (nDiff == 8)
			{
				bDo2 = TRUE;
			}
		}
		//////////////////////////////
		char * pChar1 = *(pMyHostEnt->h_addr_list);

		in_addr strMyInAddr1;
		char * pChar1Dest1 = (char *)(&strMyInAddr1);
		memcpy( pChar1Dest1, pChar1, 4); 

		sLocalDotName1 = inet_ntoa(strMyInAddr1);

		//////////////////////////////
		if (bDo2)
		{
			char * pChar1plus4 = pChar1+4;

			in_addr strMyInAddr1plus4;
			char * pChar1Dest1plus4 = (char *)(&strMyInAddr1plus4);
			memcpy( pChar1Dest1plus4, pChar1plus4, 4); 

			sLocalDotName1plus4 = inet_ntoa(strMyInAddr1plus4);
		}

		//////////////////////////////
		if (sLocalDotName1plus4.GetLength())
		{
			sLocalDotName = sLocalDotName1plus4;
		}
		else
		{
			sLocalDotName = sLocalDotName1;
		}
		
		NeatTest();
	}
	else
	{
		printf("\n\nUnable to get local IP address.");
	}
	return sLocalDotName;
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::NeatTest(void) 
{
	hostent * pMyHostEnt;
	char szMyName[100];
	memset(szMyName, 0, 100);
	gethostname(szMyName, 100);
	
	CString sLocalDotName1;
	CString sLocalDotName1plus4;
	
	pMyHostEnt = gethostbyname(szMyName);

	char * pChar1 = *(pMyHostEnt->h_addr_list);
	char * pChar1plus4 = pChar1+4;

	in_addr strMyInAddr1;
	in_addr strMyInAddr1plus4;
	char * pCharDest1 = (char *)(&strMyInAddr1);
	char * pCharDest1plus4 = (char *)(&strMyInAddr1plus4);
	memcpy(pCharDest1, pChar1, 4);
	memcpy(pCharDest1plus4, pChar1plus4, 4);

	CString sLocal1;
	CString sLocal1plus4;
	sLocal1 = inet_ntoa(strMyInAddr1);
	sLocal1plus4 = inet_ntoa(strMyInAddr1plus4);
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::OnUpdateCloseconn(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_hSocket != NULL);
}

/////////////////////////////////////////////////////////////////////////////
void CIPsinkView::OnUpdateConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_hSocket == NULL);
}

