
/*

	 Finger for Windows 95.
	 Copyright (C) 1996  Peter A. Salerno

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software
	 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "general.h"

int ckerror(int err)
{
	 switch(err) {
	 case(WSANOTINITIALISED) :
	 printf("WSANOTINITIALISED	A successful WSAStartup() must occur before using this API.\n");
	 break;

	 case(WSAENETDOWN) :
	 printf("WSAENETDOWN	The Windows Sockets implementation has detected that the network subsystem has failed.\n");
	 break;

	 case(WSAHOST_NOT_FOUND) :
	 printf("WSAHOST_NOT_FOUND	Authoritative Answer Host not found.\n");
	 break;

	 case(WSATRY_AGAIN) :
	 printf("WSATRY_AGAIN	Non-Authoritative Host not found, or SERVERFAIL.\n");
	 break;

	 case(WSANO_RECOVERY) :
	 printf("WSANO_RECOVERY	Non recoverable errors, FORMERR, REFUSED, NOTIMP.\n");
	 break;

	 case(WSANO_DATA) :
	 printf("WSANO_DATA	Valid name, no data record of requested type.\n");
	 break;

	 case(WSAEINPROGRESS) :
	 printf("WSAEINPROGRESS	A blocking Windows Sockets operation is in progress.\n");
	 break;

	 case(WSAEINTR) :
	 printf("The (blocking) call was canceled via WSACancelBlockingCall()\n");
	 break;

	 case(WSAEADDRINUSE) :
	 printf("WSAEADDRINUSE	The specified address is already in use.\n");
	 break;

	 case(WSAEADDRNOTAVAIL) :
	 printf("WSAEADDRNOTAVAIL	The specified address is not available from the local machine.\n");
	 break;

	 case(WSAEAFNOSUPPORT) :
	 printf("WSAEAFNOSUPPORT	Addresses in the specified family cannot be used with this socket.\n");
	 break;

	 case(WSAECONNREFUSED) :
	 printf("WSAECONNREFUSED	The attempt to connect was forcefully rejected.\n");
	 break;

	 case(WSAEFAULT) :
	 printf("WSAEFAULT	The namelen argument is incorrect.\n");
	 break;

	 case(WSAEINVAL) :
	 printf("WSAEINVAL	The socket is not already bound to an address.\n");
	 break;

	 case(WSAEISCONN) :
	 printf("WSAEISCONN	The socket is already connected.\n");
	 break;

	 case(WSAEMFILE) :
	 printf("WSAEMFILE	No more file descriptors are available.\n");
	 break;

	 case(WSAENETUNREACH) :
	 printf("WSAENETUNREACH	The network can't be reached from this host at this time.\n");
	 break;

	 case(WSAENOBUFS) :
	 printf("WSAENOBUFS	No buffer space is available.  The socket cannot be connected.\n");
	 break;


	 case(WSAENOTSOCK) :
	 printf("WSAENOTSOCK	The descriptor is not a socket.\n");
	 break;

	 case(WSAETIMEDOUT) :
	 printf("WSAETIMEDOUT	Attempt to connect timed out without establishing a connection\n");
	 break;

	 case(WSAEWOULDBLOCK) :
	 printf("WSAEWOULDBLOCK 	The socket is marked as non-blocking and the connection cannot be completed immediately.  It is possible to select() the socket while it is connecting by select()ing it for writing.\n");
	 break;

	 case(WSAEHOSTUNREACH) :
	 printf("WSAEHOSTUNREACH  The host is not reachable\n");
	 break;

	 default :
	 printf("Nonstandard Error -- %d\n", err);
	 break;
}
 return(0);
}