/*
 * Decompiled with CFR 0.152.
 */
package jms.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Vector;

public class TraceDomain {
    protected String name;
    protected TraceDomain parent;
    protected Vector subDomains = new Vector();
    protected String fileName;
    protected boolean isActive = false;

    public TraceDomain(String domain_name) {
        this.name = domain_name;
        this.setOutput("tty");
    }

    public TraceDomain(String domain_name, String output) {
        this.name = domain_name;
        this.setOutput(output);
    }

    public void makeSubdomainOf(TraceDomain parent_domain) {
        this.parent = parent_domain;
        parent_domain.addSubdomain(this);
        this.setOutput(parent_domain.getOutput());
    }

    public synchronized Vector getSubdomains() {
        return (Vector)this.subDomains.clone();
    }

    public String getName() {
        return this.name;
    }

    public boolean getState() {
        return this.isActive;
    }

    public boolean setState(boolean activation_state) {
        boolean previous = this.isActive;
        this.isActive = true;
        if (previous != activation_state) {
            this.out("Domain " + (activation_state ? "activated." : "disactivated."));
        }
        this.isActive = activation_state;
        return previous;
    }

    public boolean isTopDomain() {
        return this.parent == null;
    }

    public String getOutput() {
        return this.getTopdomain().fileName;
    }

    public void setOutput(String output) {
        File file;
        TraceDomain top_domain = this.getTopdomain();
        if (top_domain != this) {
            this.fileName = top_domain.getOutput();
            return;
        }
        this.fileName = output;
        if (!this.fileName.equals("tty") && (file = new File(this.fileName)).exists() && !file.delete()) {
            System.out.println("Can't delete file of TraceDomain '" + this.name + "'");
        }
    }

    public synchronized void out(String trace_msg) {
        if (this.isActive) {
            String line = String.valueOf(new Date().toString()) + " [" + this.name + "] " + trace_msg;
            if (this.getOutput().equals("tty")) {
                System.out.println(line);
            } else {
                this.writeToFile(String.valueOf(line) + "\r\n");
            }
        }
    }

    public synchronized void out(String msg, Exception e) {
        if (this.isActive) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            String line = String.valueOf(new Date().toString()) + " [" + this.name + "] EXCEPTION: " + msg + " {\n" + buf.toString() + "\n}";
            if (this.getOutput().equals("tty")) {
                System.out.println(line);
                e.printStackTrace();
            } else {
                this.writeToFile(String.valueOf(line) + "\r\n");
            }
        }
    }

    protected void writeToFile(String line) {
        TraceDomain top_domain = this.getTopdomain();
        top_domain.writeLineToFile(line);
    }

    protected synchronized void writeLineToFile(String line) {
        try {
            RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
            file.seek(file.length());
            file.writeBytes(line);
            file.close();
        }
        catch (Exception exception) {
            System.out.println("TraceDomain( " + this.name + ") Unable to write to file: " + this.fileName);
        }
    }

    protected synchronized void addSubdomain(TraceDomain sub_domain) {
        this.subDomains.addElement(sub_domain);
    }

    protected TraceDomain getTopdomain() {
        return this.parent == null ? this : this.parent.getTopdomain();
    }
}

