/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import jms.graphics.Border;

public class RectBorderedPanel
extends Panel
implements Border {
    private boolean orientation = true;

    public RectBorderedPanel() {
        this.orientation = false;
    }

    public RectBorderedPanel(boolean orientation) {
        this.orientation = orientation;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        this.paintBorder(this, g, 0, 0, d.width - 1, d.height - 1);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Dimension d = c.getSize();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, d.width - 1, d.height - 1);
        g.draw3DRect(0, 0, d.width - 1, d.height - 1, this.orientation);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 2, 2);
    }

    public final Insets getInsets() {
        return this.getBorderInsets(this);
    }

    public Rectangle getBounds() {
        Insets insets = this.getBorderInsets(this);
        Rectangle r = new Rectangle(insets.left, insets.top, insets.right, insets.bottom);
        return r;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

