/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import jms.graphics.MessageBox;
import jms.graphics.ThumbnailListener;

public class GenericThumbnail
extends Canvas
implements MouseListener {
    public static final int SIZE = 80;
    public static int BORDER = 24;
    public static int ICON_SIZE = 32;
    public static String DELETE_STRING = "Delete";
    public static String PROPERTIES_STRING = "Properties";
    protected ThumbnailListener thumbnailListener;
    protected Image icon;
    protected Image image;
    protected String fileName;
    protected long fileSize;
    protected String path;
    protected Color colorRect;
    protected PopupMenu popupMenu;
    protected MenuItem deleteMenuItem;
    protected MenuItem propertiesMenuItem;
    protected PopupActionListener popupActionListener;
    protected long popupActionEventDate;
    private int iconWidth = -1;
    private int iconHeight = -1;
    protected int imageWidth = -1;
    protected int imageHeight = -1;
    private int x0;
    private int y0;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;
    private boolean isInitialized = false;

    public GenericThumbnail(ThumbnailListener tl, Image icon, String file_name, String path, long file_size) {
        this.thumbnailListener = tl;
        this.fileName = file_name;
        this.fileSize = file_size;
        this.icon = null;
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(icon, 0);
            tracker.waitForID(0);
            this.image = icon;
        }
        catch (InterruptedException interruptedException) {
            this.image = null;
        }
        this.path = path;
        this.addMouseListener(this);
        this.imageWidth = this.image.getWidth(this);
        this.imageHeight = this.image.getHeight(this);
        this.isInitialized = false;
    }

    public void clear() {
        if (this.icon != null) {
            this.icon.flush();
        }
        if (this.image != null) {
            this.image.flush();
        }
        Runtime rt = Runtime.getRuntime();
        rt.gc();
    }

    public int getBorder() {
        return BORDER;
    }

    public boolean drawLabel() {
        return true;
    }

    public boolean initIcon() {
        float coef;
        int w = this.image.getWidth(this);
        int h = this.image.getHeight(this);
        if (w == -1 || h == -1) {
            this.isInitialized = false;
            return false;
        }
        int border = this.getBorder();
        if (w == ICON_SIZE && h == ICON_SIZE) {
            this.iconWidth = ICON_SIZE;
            this.iconHeight = ICON_SIZE;
            this.x0 = border;
            this.y0 = 2 * border / 3;
            this.icon = this.image;
            this.image = null;
            this.isInitialized = true;
            return true;
        }
        if (w < ICON_SIZE && h < ICON_SIZE) {
            this.iconWidth = w;
            this.iconHeight = h;
            this.icon = this.image;
            this.image = null;
            this.x0 = (80 - this.iconWidth) / 2;
            this.y0 = (80 - this.iconHeight) / 2;
            this.isInitialized = true;
            return true;
        }
        if (w > h) {
            coef = (float)(80 - 2 * border) / (float)w;
            h = (int)((float)h * coef);
            this.x0 = border;
            this.y0 = (80 - h) / 2;
            w = 80 - 2 * border;
        } else {
            coef = (float)(80 - 2 * border) / (float)h;
            w = (int)((float)w * coef);
            this.x0 = (80 - w) / 2;
            this.y0 = border;
            h = 80 - 2 * border;
        }
        this.iconWidth = w;
        this.iconHeight = h;
        this.icon = this.image.getScaledInstance(w, h, 8);
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.icon, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            this.icon = null;
        }
        this.image.flush();
        this.image = null;
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.isInitialized = true;
        return true;
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        String fn = this.getFileName();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, d.width, d.height);
        if (this.colorRect != null) {
            g.setColor(this.colorRect);
            g.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
        }
        this.drawIcon(g);
        if (this.drawLabel()) {
            Font f = new Font("Arial", 1, 10);
            FontMetrics fm = this.getFontMetrics(f);
            if (fn.length() > 11) {
                fn = String.valueOf(fn.substring(0, 10)) + "...";
            }
            g.setFont(f);
            g.setColor(Color.black);
            g.drawString(fn, 40 - fm.stringWidth(fn) / 2, 80 - 2 * this.getBorder() / 3 + fm.getAscent() / 2);
        }
    }

    public void drawIcon(Graphics g) {
        if (!this.isInitialized) {
            this.isInitialized = this.initIcon();
            if (!this.isInitialized) {
                return;
            }
        }
        g.drawImage(this.icon, this.x0, this.y0, this);
    }

    public String getInfo() {
        String info = "File : " + this.getFileName();
        if (this.fileSize != 0L) {
            if (this.fileSize < 1024L) {
                info = String.valueOf(info) + "  (" + this.fileSize + "Bytes)";
            } else {
                long kb = this.fileSize / 1024L;
                info = String.valueOf(info) + "  (" + kb + "Kb)";
            }
        }
        return info;
    }

    public String getProperties() {
        long l = this.fileSize;
        String ko = "";
        if (l > 1024L) {
            ko = (l /= 1024L) + " Ko";
        }
        return new String("File : " + this.getFileName() + "|Path : " + this.path + "|Size : " + ko + " (" + this.fileSize + " bytes)");
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getFullFileName() {
        return String.valueOf(this.path) + this.fileName;
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1, 1);
    }

    public Dimension getMinimumSize() {
        return new Dimension(80, 80);
    }

    public Dimension getPreferredSize() {
        return new Dimension(80, 80);
    }

    public void mouseClicked(MouseEvent evt) {
        block3: {
            if ((evt.getModifiers() & 0x10) == 0 || System.currentTimeMillis() - this.popupActionEventDate <= 1000L) break block3;
            Runtime runtime = Runtime.getRuntime();
            String os = System.getProperty("os.name");
            os = os.toLowerCase();
            try {
                if (!(os == null || os.indexOf("windows") == -1 && os.indexOf("microsoft") == -1 || os.indexOf("95") == -1 && os.indexOf("98") == -1)) {
                    runtime.exec("start " + this.getFullFileName());
                    break block3;
                }
                runtime.exec(this.getFullFileName());
            }
            catch (IOException iOException) {
                System.out.println("Cannot execute command 'start " + this.getFullFileName() + "'");
                MessageBox mg = new MessageBox("Sorry, cannot launch the Application for : " + this.getFullFileName());
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        if ((evt.getModifiers() & 4) != 0 || (evt.getModifiers() & 8) != 0) {
            if (this.popupMenu == null) {
                try {
                    this.popupMenu = new PopupMenu("File actions");
                    this.popupActionListener = new PopupActionListener(this);
                    this.deleteMenuItem = new MenuItem(DELETE_STRING);
                    this.popupMenu.add(this.deleteMenuItem);
                    this.popupMenu.addSeparator();
                    this.propertiesMenuItem = new MenuItem(PROPERTIES_STRING);
                    this.popupMenu.add(this.propertiesMenuItem);
                    this.add(this.popupMenu);
                    this.deleteMenuItem.addActionListener(this.popupActionListener);
                    this.propertiesMenuItem.addActionListener(this.popupActionListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.popupMenu.show(this, evt.getX() + 1, evt.getY() + 1);
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        this.colorRect = Color.black;
        this.thumbnailListener.thumbnailEntered(new ActionEvent(this, 1001, "mouseEntered"));
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        this.colorRect = null;
        this.thumbnailListener.thumbnailExited(new ActionEvent(this, 1001, "mouseExited"));
        this.repaint();
    }

    class PopupActionListener
    implements ActionListener {
        private GenericThumbnail thumbnail;

        public PopupActionListener(GenericThumbnail gt) {
            GenericThumbnail.this = GenericThumbnail.this;
            this.thumbnail = gt;
        }

        public void actionPerformed(ActionEvent evt) {
            MenuItem mi = (MenuItem)evt.getSource();
            GenericThumbnail.this.popupActionEventDate = System.currentTimeMillis();
            if (mi.getLabel().equals(DELETE_STRING)) {
                GenericThumbnail.this.thumbnailListener.thumbnailDelete(new ActionEvent(this.thumbnail, 1001, "thumbnailDelete"));
            } else if (mi.getLabel().equals(PROPERTIES_STRING)) {
                GenericThumbnail.this.thumbnailListener.thumbnailProperties(new ActionEvent(this.thumbnail, 1001, "thumbnailProperties"));
            }
        }
    }
}

