/*
 * Decompiled with CFR 0.152.
 */
package hsplitter.model;

import hsplitter.model.Config;
import hsplitter.model.HTOC;
import hsplitter.model.JavaHelpMeta;
import hsplitter.tools.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class HtmlDoc {
    private static final boolean DEBUG = false;
    private static final boolean MONITOR = true;
    public static final int ERR_LEVEL_INFO = 0;
    public static final int ERR_LEVEL_WARN = -1;
    public static final int ERR_LEVEL_ERR = -2;
    public static final int ERR_LEVEL_FATAL = -3;
    private static final String NAMEVAR_DOC_PLACE = "@DOC@";
    private static final String NAMEVAR_PREV = "@PREV@";
    private static final String NAMEVAR_NEXT = "@NEXT@";
    private static final String NAMEVAR_HOME = "@HOME@";
    private static final String NAMEVAR_TOC = "@TOC@";
    private static final int START = 0;
    private static final int END = 1;
    private static final String[] tagsX1;
    private static final String NAMEVAR_FILE = "@FILEPATH@";
    private static final String NAMEVAR_TITLE = "@TITLE@";
    private static final String TEMPLATE_BODY_FILE = "BodyTemplate.htm";
    private static final String TEMPLATE_HEADER_FILE = "HeaderTemplate.txt";
    private static final String TEMPLATE_FOOTER_FILE = "FooterTemplate.txt";
    private static final String TEMPLATE_TOC_FILE = "TOCTemplate.htm";
    private static final String TEMPLATE_SUBTOC_FILE = "TransitionTemplate.txt";
    Config config = null;
    File htmlFile = null;
    Head head = null;
    ArrayList docSegments = null;
    ArrayList segmentNames = null;
    HashSet segmentNameSet = null;
    String reportMessage = "";
    int currentSegmentNdx = -1;
    String currentSubDir = "";
    String currentLineRead = "";
    Segment currentSegment = null;
    String templateBody = null;
    String templateBodyBefore = null;
    String templateBodyAfter = "</BODY></HTML>";
    String templateHeader = null;
    String templateFooter = null;
    String templateTOC = null;
    String templateTransition = null;
    String properExt = null;
    FileReader freader;
    BufferedReader breader;
    Logger logger = null;
    static Class class$hsplitter$model$HtmlDoc;

    public HtmlDoc(Config config, File htmlFile) {
        this.config = config;
        this.htmlFile = htmlFile;
    }

    public String getErrMessage() {
        return this.reportMessage;
    }

    /*
     * Loose catch block
     */
    private String readTemplate(String fileName, String adir) {
        String txt;
        block15: {
            String sep = System.getProperty("line.separator");
            File afile = null;
            afile = adir == null ? new File(fileName) : new File(adir, fileName);
            FileReader fr = null;
            BufferedReader br = null;
            txt = "";
            fr = new FileReader(afile);
            br = new BufferedReader(fr);
            while (br.ready()) {
                txt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(txt))).append(br.readLine()).append(sep)));
            }
            Object var10_8 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
                break block15;
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (IOException ex) {
                    System.out.println("ERR: Template File Read IO Error = ".concat(String.valueOf(String.valueOf(ex))));
                    this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   ERR: Template File ").append(fileName).append(" Read IO Error = ").append(ex)));
                    txt = null;
                    Object var10_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (fr != null) {
                            fr.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return txt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        String templateName;
        boolean success;
        block39: {
            this.logger = Logger.getLogger(null, false);
            this.logger.logInfo("Load source HTML document is =".concat(String.valueOf(String.valueOf(this.htmlFile.getName()))));
            this.logger.logInfo("Collecting heading information");
            int posExt = this.htmlFile.getName().lastIndexOf(46);
            this.properExt = this.config.pageExtension.length() > 2 && this.config.pageExtension.startsWith(".") ? this.config.pageExtension : ".htm";
            success = true;
            this.reportMessage = "";
            try {
                try {
                    this.freader = new FileReader(this.htmlFile);
                    this.breader = new BufferedReader(this.freader);
                    switch (this.config.splitLevel) {
                        case 1: {
                            this.head = new Head(this, "<H1>");
                            break;
                        }
                        case 2: {
                            this.head = new Head(this, "<H2>");
                            break;
                        }
                        case 3: {
                            this.head = new Head(this, "<H3>");
                            break;
                        }
                        default: {
                            this.head = new Head(this);
                        }
                    }
                    int sts = -1;
                    while (this.breader.ready()) {
                        this.currentLineRead = this.breader.readLine();
                        sts = this.head.fillHead(this.currentLineRead);
                        if (sts == -1) continue;
                    }
                    if (!this.breader.ready()) {
                        sts = -2;
                    }
                    int sts2 = 0;
                    if (sts != -2) {
                        while (this.breader.ready()) {
                            this.currentLineRead = this.breader.readLine();
                            sts2 = this.head.fillInterim(this.currentLineRead);
                            if (sts2 == -1) continue;
                        }
                        if (!this.breader.ready()) {
                            sts = -2;
                        } else {
                            this.currentLineRead = this.head.getFirstPartOfSegment();
                        }
                    }
                    if (sts == -2) {
                        this.reportMessage = "ERR: Error while reading the HEAD part";
                        return false;
                    }
                    this.reportMessage = "INFO: Opened = ".concat(String.valueOf(String.valueOf(this.htmlFile.getName())));
                    success = true;
                }
                catch (IOException ex) {
                    this.reportMessage = "ERR: File Read IO Error at <HEAD> part, Err = ".concat(String.valueOf(String.valueOf(ex)));
                    try {
                        if (this.breader != null) {
                            this.breader.close();
                        }
                        if (this.freader != null) {
                            this.freader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    success = false;
                    Object var7_10 = null;
                    break block39;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                throw throwable;
            }
            Object var7_9 = null;
        }
        if (success) {
            this.docSegments = new ArrayList();
        }
        String adir = this.htmlFile.getParent();
        this.templateBody = null;
        this.templateBodyBefore = null;
        this.templateBodyAfter = "</BODY></HTML>";
        this.templateHeader = null;
        this.templateFooter = null;
        this.templateTOC = null;
        if (this.config.useBodyTemplate) {
            if (this.config.bodyTemplateFileName.equals("")) {
                this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   Using default Body template: ").append(TEMPLATE_BODY_FILE)));
                this.templateBody = this.readTemplate(TEMPLATE_BODY_FILE, null);
                if (this.templateBody == null) {
                    templateName = (class$hsplitter$model$HtmlDoc == null ? (class$hsplitter$model$HtmlDoc = HtmlDoc.class$("hsplitter.model.HtmlDoc")) : class$hsplitter$model$HtmlDoc).getResource("/BodyTemplate.htm").getPath();
                    this.templateBody = this.readTemplate(templateName, null);
                }
            } else {
                this.templateBody = this.readTemplate(this.config.bodyTemplateFileName, adir);
            }
        }
        if (this.config.useHeaderTemplate) {
            if (this.config.headerTemplateFileName.equals("")) {
                this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   Using default Header template: ").append(TEMPLATE_HEADER_FILE)));
                this.templateHeader = this.readTemplate(TEMPLATE_HEADER_FILE, null);
                if (this.templateHeader == null) {
                    templateName = (class$hsplitter$model$HtmlDoc == null ? (class$hsplitter$model$HtmlDoc = HtmlDoc.class$("hsplitter.model.HtmlDoc")) : class$hsplitter$model$HtmlDoc).getResource("/HeaderTemplate.txt").getPath();
                    this.templateHeader = this.readTemplate(templateName, null);
                }
            } else {
                this.templateHeader = this.readTemplate(this.config.headerTemplateFileName, adir);
            }
        }
        if (this.config.useFooterTemplate) {
            if (this.config.footerTemplateFileName.equals("")) {
                this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   Using default Footer template: ").append(TEMPLATE_FOOTER_FILE)));
                this.templateFooter = this.readTemplate(TEMPLATE_FOOTER_FILE, null);
                if (this.templateFooter == null) {
                    templateName = (class$hsplitter$model$HtmlDoc == null ? (class$hsplitter$model$HtmlDoc = HtmlDoc.class$("hsplitter.model.HtmlDoc")) : class$hsplitter$model$HtmlDoc).getResource("/FooterTemplate.txt").getPath();
                    this.templateFooter = this.readTemplate(templateName, null);
                }
            } else {
                this.templateFooter = this.readTemplate(this.config.footerTemplateFileName, adir);
            }
        }
        if (this.config.doTOC) {
            if (this.config.tocTemplateFileName.equals("")) {
                this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   Using default TOC template: ").append(TEMPLATE_TOC_FILE)));
                this.templateTOC = this.readTemplate(TEMPLATE_TOC_FILE, null);
                if (this.templateTOC == null) {
                    templateName = (class$hsplitter$model$HtmlDoc == null ? (class$hsplitter$model$HtmlDoc = HtmlDoc.class$("hsplitter.model.HtmlDoc")) : class$hsplitter$model$HtmlDoc).getResource("/TOCTemplate.htm").getPath();
                    this.templateTOC = this.readTemplate(templateName, null);
                }
            } else {
                this.templateTOC = this.readTemplate(this.config.tocTemplateFileName, adir);
            }
        }
        if (!this.config.useTransitionTemplate) return success;
        if (!this.config.transitionTemplateFileName.equals("")) {
            this.templateTransition = this.readTemplate(this.config.transitionTemplateFileName, adir);
            return success;
        }
        this.reportMessage = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.reportMessage))).append("\n   Using default Transition template: ").append(TEMPLATE_SUBTOC_FILE)));
        this.templateTransition = this.readTemplate(TEMPLATE_SUBTOC_FILE, null);
        if (this.templateTransition != null) return success;
        templateName = (class$hsplitter$model$HtmlDoc == null ? (class$hsplitter$model$HtmlDoc = HtmlDoc.class$("hsplitter.model.HtmlDoc")) : class$hsplitter$model$HtmlDoc).getResource("/TransitionTemplate.txt").getPath();
        this.templateTransition = this.readTemplate(templateName, null);
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int segmentIt(int reportLevel) {
        int success = 0;
        this.reportMessage = "";
        this.logger.logInfo("Start segm= ".concat(String.valueOf(String.valueOf(this.currentLineRead))));
        try {
            try {
                this.currentSegment = new Segment(this, this.config.splitLevel);
                int sts = this.currentSegment.fillSegment(this.currentLineRead);
                while (this.breader.ready()) {
                    this.currentLineRead = this.breader.readLine();
                    sts = this.currentSegment.fillSegment(this.currentLineRead);
                    if (sts == -1) continue;
                }
                this.currentLineRead = this.currentSegment.getFirstPartOfNextSegment();
                switch (sts) {
                    case 1: {
                        try {
                            if (this.breader != null) {
                                this.breader.close();
                            }
                            if (this.freader != null) {
                                this.freader.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.reportMessage = "INFO: End";
                        success = 0;
                        break;
                    }
                    case -2: {
                        this.reportMessage = "ERR: Error while reading a segment (under a <Hx>) of html";
                        success = -2;
                        break;
                    }
                    case 0: {
                        success = 1;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                try {
                    if (this.breader != null) {
                        this.breader.close();
                    }
                    if (this.freader != null) {
                        this.freader.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                this.reportMessage = "ERR: File Read IO Error under a <Hx> part = ".concat(String.valueOf(String.valueOf(ex)));
                success = -2;
                Object var6_8 = null;
            }
            {
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            throw throwable;
        }
        if (success < 0) return success;
        this.docSegments.add(this.currentSegment);
        return success;
    }

    public int nameTheSegments() {
        this.reportMessage = "INFO: End";
        int qty = this.docSegments.size();
        if (qty <= 0) {
            this.reportMessage = "WARN: No segment";
            return -1;
        }
        this.segmentNameSet = new HashSet();
        this.segmentNames = new ArrayList();
        for (int ii = 0; ii < qty; ++ii) {
            Segment asegment = (Segment)this.docSegments.get(ii);
            String txt = asegment.getHeadingNoHTag();
            if (txt == null) {
                this.reportMessage = String.valueOf(String.valueOf(new StringBuffer("ERR:  Error in the source document, no heading in the segment no: ").append(ii).append(1)));
                return -2;
            }
            String bookmark = HtmlDoc.getAttribVal(txt, "NAME");
            String title = HtmlDoc.getHeadingTitle(txt);
            if (this.config.useLowerCaseOnly) {
                title = title.toLowerCase();
            }
            this.logger.logInfo(String.valueOf(String.valueOf(new StringBuffer("Title = ").append(title).append(" ,Bookmark = ").append(bookmark))));
            char[] titleChars = title.toCharArray();
            for (int jj = 0; jj < titleChars.length; ++jj) {
                if (Character.isLetterOrDigit(titleChars[jj])) continue;
                titleChars[jj] = 95;
            }
            title = new String(titleChars);
            boolean isUnique = false;
            int seqNb = 0;
            while (!isUnique) {
                isUnique = this.segmentNameSet.add(title);
                if (isUnique) continue;
                title = String.valueOf(String.valueOf(title)).concat(String.valueOf(String.valueOf(seqNb++)));
            }
            this.segmentNames.add(title);
        }
        this.currentSegmentNdx = 0;
        return qty;
    }

    public int relinkSegments() {
        String bkmrkErrs = "";
        String hyperlnkErrs = "";
        this.reportMessage = "INFO: End";
        HashMap<String, String> targets = new HashMap<String, String>();
        int qty = this.segmentNames.size();
        if (qty < 2) {
            return 0;
        }
        int nbErrs1 = 0;
        for (int ii = 0; ii < qty; ++ii) {
            String txt = ((Segment)this.docSegments.get(ii)).getSegmentText();
            String segName = (String)this.segmentNames.get(ii);
            int pos = txt.indexOf("<A");
            if (pos < 0) {
                pos = txt.indexOf("<a");
            }
            int pos2 = -1;
            if (pos > 0) {
                pos2 = txt.indexOf(62, pos);
            }
            while (pos >= 0 && pos2 >= 0 && pos2 < txt.length()) {
                String obj;
                String tagTxt = txt.substring(pos, pos2 + 1);
                String bookmrk = HtmlDoc.getAttribVal(tagTxt, "NAME");
                if (bookmrk != null && (obj = targets.put(bookmrk, segName)) != null) {
                    ++nbErrs1;
                    bkmrkErrs = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(bkmrkErrs))).append("   -Segment=").append(segName).append(", Bookmark=").append(bookmrk).append("\n")));
                }
                if ((pos = txt.indexOf("<A", pos2)) < 0) {
                    pos = txt.indexOf("<a", pos2);
                }
                if (pos <= 0) continue;
                pos2 = txt.indexOf(62, pos);
            }
        }
        int nbErrs2 = 0;
        for (int ii = 0; ii < qty; ++ii) {
            Segment seg = (Segment)this.docSegments.get(ii);
            String txt = seg.getSegmentText();
            String segName = (String)this.segmentNames.get(ii);
            int pos = txt.indexOf("<A");
            if (pos < 0) {
                pos = txt.indexOf("<a");
            }
            int pos2 = -1;
            if (pos > 0) {
                pos2 = txt.indexOf(62, pos);
            }
            String newTxt = "";
            int pos1 = 0;
            while (pos >= 0 && pos2 >= 0 && pos2 < txt.length()) {
                String tagTxt = txt.substring(pos, pos2 + 1);
                TagExpression tagEx = new TagExpression(tagTxt, "HREF");
                String hrefVal = tagEx.getAttributeValue();
                String bookmark = tagEx.getBookmark();
                if (bookmark != null && hrefVal.equals("")) {
                    String relSegName = (String)targets.get(bookmark);
                    if (relSegName != null) {
                        tagEx.setNewAttributeValue(String.valueOf(String.valueOf(relSegName)).concat(String.valueOf(String.valueOf(this.properExt))));
                        tagTxt = tagEx.getExpression();
                    } else {
                        ++nbErrs2;
                        hyperlnkErrs = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(hyperlnkErrs))).append("   -Segment=").append(segName).append(", Bookmark=").append(bookmark).append("\n")));
                    }
                }
                newTxt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newTxt))).append(txt.substring(pos1, pos)).append(tagTxt)));
                pos1 = pos2 + 1;
                pos = txt.indexOf("<A", pos2);
                if (pos < 0) {
                    pos = txt.indexOf("<a", pos2);
                }
                if (pos <= 0) continue;
                pos2 = txt.indexOf(62, pos);
            }
            seg.segmentTxt = newTxt = String.valueOf(String.valueOf(newTxt)).concat(String.valueOf(String.valueOf(txt.substring(pos1))));
            this.docSegments.set(ii, seg);
        }
        String bookMrkErrMsg = nbErrs1 > 0 ? String.valueOf(String.valueOf(new StringBuffer("Nb of Bookmark Errs = ").append(nbErrs1).append("\n").append(bkmrkErrs))) : "";
        String hyperlinksErrMsg = nbErrs2 > 0 ? String.valueOf(String.valueOf(new StringBuffer("Nb of Hyperlink Errs = ").append(nbErrs2).append("\n").append(hyperlnkErrs))) : "";
        this.reportMessage = nbErrs1 == 0 && nbErrs2 == 0 ? "INFO: End" : String.valueOf(String.valueOf(new StringBuffer("WARN: End with ").append(bookMrkErrMsg).append(", ").append(hyperlinksErrMsg)));
        return 0;
    }

    /*
     * Loose catch block
     */
    public int saveSegments(int reportLevel) {
        int success;
        block18: {
            this.reportMessage = "INFO: End";
            success = 1;
            String hdoc = null;
            if (this.currentSegmentNdx >= this.docSegments.size()) {
                return 0;
            }
            if (this.templateBody == null) {
                this.templateBodyBefore = String.valueOf(String.valueOf(this.head.getHeadText())).concat(String.valueOf(String.valueOf(this.head.getInterimText())));
            } else {
                int posmid = this.templateBody.indexOf(NAMEVAR_DOC_PLACE);
                if (posmid > 0) {
                    this.templateBodyBefore = this.templateBody.substring(0, posmid);
                    this.templateBodyAfter = this.templateBody.substring(posmid + NAMEVAR_DOC_PLACE.length());
                } else {
                    posmid = this.templateBody.indexOf("</BODY>");
                    if (posmid < 0) {
                        this.reportMessage = "ERR: Body template error";
                        return -2;
                    }
                    this.templateBodyBefore = this.templateBody.substring(0, posmid);
                    this.reportMessage = "WARN: Template has no document position marker @DOC@";
                }
            }
            String header = null;
            String footer = null;
            header = this.templateHeader == null ? "" : this.parseTemplate(this.templateHeader);
            footer = this.templateFooter == null ? "" : this.parseTemplate(this.templateFooter);
            String transitionTxt = null;
            transitionTxt = this.templateTransition == null ? "" : this.parseTransitionTemplate(this.templateTransition);
            hdoc = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.templateBodyBefore))).append(header).append(((Segment)this.docSegments.get(this.currentSegmentNdx)).getSegmentText()).append(transitionTxt).append(footer).append(this.templateBodyAfter)));
            String filnam = (String)this.segmentNames.get(this.currentSegmentNdx);
            File afil = new File(this.htmlFile.getParent(), String.valueOf(String.valueOf(filnam)).concat(String.valueOf(String.valueOf(this.properExt))));
            if (afil.equals(this.htmlFile)) {
                this.logger.logWarn("Heading name conflict with source = ".concat(String.valueOf(String.valueOf(filnam))));
                System.err.println("WARN: Heading name conflict with source = ".concat(String.valueOf(String.valueOf(filnam))));
                this.reportMessage = "WARN: Heading name conflict with source = ".concat(String.valueOf(String.valueOf(filnam)));
                this.htmlFile.renameTo(new File(this.htmlFile.getParent(), "0-".concat(String.valueOf(String.valueOf(this.htmlFile.getName())))));
                this.logger.logWarn("New source HTML file name = 0-".concat(String.valueOf(String.valueOf(this.htmlFile.getName()))));
                success = -1;
            }
            FileWriter fw = null;
            fw = new FileWriter(afil);
            fw.write(hdoc);
            Object var12_11 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                break block18;
            }
            catch (IOException iOException) {}
            break block18;
            {
                catch (IOException ee) {
                    this.reportMessage = String.valueOf(String.valueOf(new StringBuffer("ERR: Write Err for segment = ").append(filnam).append(", Err = ").append(ee)));
                    success = -2;
                    Object var12_12 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        ++this.currentSegmentNdx;
        return success;
    }

    private String parseTransitionTemplate(String template) {
        String tag = ((Segment)this.docSegments.get(this.currentSegmentNdx)).getSegmentText().substring(0, 4);
        if (tag.charAt(2) - 48 >= this.config.splitLevel) {
            return "";
        }
        int qty = this.docSegments.size();
        if (this.currentSegmentNdx < qty - 1) {
            String tagNext = ((Segment)this.docSegments.get(this.currentSegmentNdx + 1)).getSegmentText().substring(0, 4);
            if (tagNext.charAt(2) <= tag.charAt(2)) {
                return "";
            }
        } else {
            return "";
        }
        int pos1 = template.indexOf(tagsX1[0]);
        String txt = null;
        if (pos1 < 0) {
            return template;
        }
        txt = template.substring(0, pos1);
        int pos2 = template.indexOf(tagsX1[1], pos1 + 1);
        String itemTemplate = null;
        String tailTxt = "";
        if (pos2 > 0) {
            itemTemplate = template.substring(pos1 + tagsX1[0].length(), pos2);
            tailTxt = template.substring(pos2 + tagsX1[1].length());
        } else {
            itemTemplate = template.substring(pos1 + tagsX1[0].length());
        }
        int ii = this.currentSegmentNdx + 1;
        char levelChr = ((Segment)this.docSegments.get(ii)).getSegmentText().charAt(2);
        while (levelChr > tag.charAt(2)) {
            if (levelChr == tag.charAt(2) + '\u0001') {
                String itemTxt = "";
                int posprev = 0;
                int pos = itemTemplate.indexOf(64);
                while (pos >= 0) {
                    String varVal = null;
                    int len = 0;
                    if (itemTemplate.substring(pos).startsWith(NAMEVAR_FILE)) {
                        varVal = String.valueOf(String.valueOf(this.segmentNames.get(ii))).concat(String.valueOf(String.valueOf(this.properExt)));
                        len = NAMEVAR_FILE.length();
                    } else if (itemTemplate.substring(pos).startsWith(NAMEVAR_TITLE)) {
                        String atxt = ((Segment)this.docSegments.get(ii)).getHeadingNoHTag();
                        varVal = HtmlDoc.getHeadingTitle(atxt);
                        len = NAMEVAR_TITLE.length();
                    }
                    if (varVal == null) {
                        // empty if block
                    }
                    itemTxt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(itemTxt))).append(itemTemplate.substring(posprev, pos)).append(varVal)));
                    posprev = pos + len;
                    pos = itemTemplate.indexOf(64, posprev + 1);
                }
                itemTxt = String.valueOf(String.valueOf(itemTxt)).concat(String.valueOf(String.valueOf(itemTemplate.substring(posprev))));
                txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(itemTxt)));
            }
            if (++ii >= this.segmentNames.size()) break;
            levelChr = ((Segment)this.docSegments.get(ii)).getSegmentText().charAt(2);
        }
        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(tailTxt)));
        return txt;
    }

    private String parseTemplate(String template) {
        String filnam = String.valueOf(String.valueOf((String)this.segmentNames.get(this.currentSegmentNdx))).concat(String.valueOf(String.valueOf(this.properExt)));
        String txt = "";
        int posprev = 0;
        int pos = template.indexOf(64);
        while (pos >= 0) {
            String link = null;
            int len = 0;
            if (template.substring(pos).startsWith(NAMEVAR_NEXT)) {
                link = 1 + this.currentSegmentNdx < this.segmentNames.size() ? String.valueOf(String.valueOf(this.segmentNames.get(this.currentSegmentNdx + 1))).concat(String.valueOf(String.valueOf(this.properExt))) : String.valueOf(String.valueOf(this.segmentNames.get(this.currentSegmentNdx))).concat(String.valueOf(String.valueOf(this.properExt)));
                len = NAMEVAR_NEXT.length();
            } else if (template.substring(pos).startsWith(NAMEVAR_PREV)) {
                link = this.currentSegmentNdx > 0 ? String.valueOf(String.valueOf(this.segmentNames.get(this.currentSegmentNdx - 1))).concat(String.valueOf(String.valueOf(this.properExt))) : String.valueOf(String.valueOf(this.segmentNames.get(this.currentSegmentNdx))).concat(String.valueOf(String.valueOf(this.properExt)));
                len = NAMEVAR_PREV.length();
            } else if (template.substring(pos).startsWith(NAMEVAR_HOME)) {
                link = String.valueOf(String.valueOf(this.segmentNames.get(0))).concat(String.valueOf(String.valueOf(this.properExt)));
                len = NAMEVAR_HOME.length();
            } else if (template.substring(pos).startsWith(NAMEVAR_TOC)) {
                link = this.config.useLowerCaseOnly ? "toc".concat(String.valueOf(String.valueOf(this.properExt))) : "TOC".concat(String.valueOf(String.valueOf(this.properExt)));
                len = NAMEVAR_TOC.length();
            }
            if (link == null) {
                // empty if block
            }
            txt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(txt))).append(template.substring(posprev, pos)).append(link)));
            posprev = pos + len;
            pos = template.indexOf(64, posprev + 1);
        }
        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(template.substring(posprev))));
        return txt;
    }

    public int prepareTOC() {
        this.reportMessage = "INFO: End";
        int qty = this.docSegments.size();
        if (qty <= 0) {
            this.reportMessage = "WARN: No segment";
            return -1;
        }
        String[] titles = new String[qty];
        String[] filepaths = new String[qty];
        int[] levels = new int[qty];
        for (int ii = 0; ii < qty; ++ii) {
            String tag = ((Segment)this.docSegments.get(ii)).getSegmentText().substring(0, 4);
            switch (tag.charAt(2)) {
                case '1': {
                    levels[ii] = 0;
                    break;
                }
                case '2': {
                    levels[ii] = 1;
                    break;
                }
                case '3': {
                    levels[ii] = 2;
                    break;
                }
                default: {
                    levels[ii] = 2;
                }
            }
            String atxt = ((Segment)this.docSegments.get(ii)).getHeadingNoHTag();
            titles[ii] = HtmlDoc.getHeadingTitle(atxt);
            filepaths[ii] = (String)this.segmentNames.get(ii);
        }
        String mainName = this.htmlFile.getName();
        int ndx = mainName.lastIndexOf(46);
        if (ndx > 0) {
            mainName = mainName.substring(0, ndx);
        }
        HTOC mytoc = new HTOC(mainName, levels, titles, filepaths);
        int sts = 0;
        sts = mytoc.init(new File(this.htmlFile.getParent()), this.templateTOC, this.properExt);
        if (sts == -2) {
            this.reportMessage = "ERR: TOC init/open error";
            return -2;
        }
        sts = this.config.useLowerCaseOnly ? mytoc.doToc("toc") : mytoc.doToc("TOC");
        if (sts == -2) {
            this.reportMessage = "ERR: TOC generation error";
            return -2;
        }
        return 0;
    }

    public int prepareJavaHelp() {
        JavaHelpMeta jhm;
        int sts;
        this.reportMessage = "INFO: End";
        int qty = this.docSegments.size();
        if (qty <= 0) {
            this.reportMessage = "WARN: No segment";
            return -1;
        }
        String[] titles = new String[qty];
        String[] filepaths = new String[qty];
        int[] levels = new int[qty];
        for (int ii = 0; ii < qty; ++ii) {
            String tag = ((Segment)this.docSegments.get(ii)).getSegmentText().substring(0, 4);
            switch (tag.charAt(2)) {
                case '1': {
                    levels[ii] = 0;
                    break;
                }
                case '2': {
                    levels[ii] = 1;
                    break;
                }
                case '3': {
                    levels[ii] = 2;
                    break;
                }
                default: {
                    levels[ii] = 2;
                }
            }
            String atxt = ((Segment)this.docSegments.get(ii)).getHeadingNoHTag();
            titles[ii] = HtmlDoc.getHeadingTitle(atxt);
            filepaths[ii] = (String)this.segmentNames.get(ii);
        }
        String mainName = this.htmlFile.getName();
        int ndx = mainName.lastIndexOf(46);
        if (ndx > 0) {
            mainName = mainName.substring(0, ndx);
        }
        if ((sts = (jhm = new JavaHelpMeta(mainName, levels, titles, filepaths)).init(new File(this.htmlFile.getParent()), this.properExt)) != 0) {
            this.reportMessage = "WARN: JavaHelp Helpset file (xxx.hs) generation error";
            return -2;
        }
        sts = jhm.doMapFile();
        if (sts != 0) {
            this.reportMessage = "WARN: JavaHelp Map file (Map.jhm) generation error";
            return -2;
        }
        sts = jhm.doToc();
        if (sts != 0) {
            this.reportMessage = "WARN: JavaHelp TOC file (xxxTOC.xml) generation error";
            return -2;
        }
        return 0;
    }

    static String getHeadingTitle(String headingNoTag) {
        if (headingNoTag == null) {
            System.err.println("ERR: Null heading observed at getHeadingTitle(), an error in the source document");
            return null;
        }
        int ndx = 0;
        int ndx2 = -1;
        String txt = headingNoTag;
        while (ndx >= 0) {
            ndx = txt.indexOf(60);
            ndx2 = -1;
            if (ndx >= 0) {
                ndx2 = txt.indexOf(62, ndx + 1);
            }
            if (ndx < 0 && ndx2 < 0) {
                return txt;
            }
            if (ndx2 <= 0) {
                return null;
            }
            if (ndx2 == txt.length() - 1) {
                txt = txt.substring(0, ndx);
                continue;
            }
            if (ndx == 0) {
                txt = txt.substring(ndx2 + 1);
                continue;
            }
            txt = String.valueOf(String.valueOf(txt.substring(0, ndx))).concat(String.valueOf(String.valueOf(txt.substring(ndx2 + 1))));
        }
        return txt;
    }

    static String getAttribVal(String headingNoTag, String attrib) {
        int jj;
        if (headingNoTag == null) {
            System.err.println("ERR: Null heading observed at getAttribVal(), an error in the source document");
            return null;
        }
        String attribLC = attrib.toLowerCase();
        int ndx = headingNoTag.indexOf("<A");
        if (ndx < 0) {
            ndx = headingNoTag.indexOf("<a");
        }
        if (ndx < 0) {
            return null;
        }
        int ndx2 = headingNoTag.indexOf(attrib, ndx + 3);
        if (ndx2 < 0) {
            ndx2 = headingNoTag.indexOf(attribLC, ndx + 3);
        }
        if (ndx2 < 0) {
            return null;
        }
        int ndx3 = headingNoTag.indexOf(61, ndx2 + 4);
        int ndx4 = headingNoTag.indexOf(62, ndx + 3);
        if (ndx3 < 0 || ndx4 < 0) {
            return null;
        }
        if (ndx3 > ndx4) {
            return null;
        }
        String str = headingNoTag.substring(ndx3 + 1, ndx4);
        ndx2 = -1;
        for (jj = 0; jj < str.length() - 2; ++jj) {
            if (str.charAt(jj) == '\"') {
                ndx2 = str.indexOf(34, jj + 1);
                ++jj;
                break;
            }
            if (str.charAt(jj) == '\'') {
                ndx2 = str.indexOf(39, jj + 1);
                ++jj;
                break;
            }
            if (!Character.isLetter(str.charAt(jj))) continue;
            ndx2 = HtmlDoc.indexOfWhitespace(str, jj + 1);
            break;
        }
        if (ndx2 < 0) {
            return str.trim();
        }
        if (ndx2 > jj) {
            return str.substring(jj, ndx2);
        }
        return null;
    }

    private static int indexOfWhitespace(String str, int startChrNdx) {
        int[] ndxs = new int[]{str.indexOf(32, startChrNdx), str.indexOf(9, startChrNdx), str.indexOf(13, startChrNdx), str.indexOf(10, startChrNdx), str.indexOf(12, startChrNdx)};
        Arrays.sort(ndxs);
        for (int ii = 0; ii < ndxs.length; ++ii) {
            if (ndxs[ii] < startChrNdx) continue;
            return ndxs[ii];
        }
        return -1;
    }

    public static void main(String[] args) {
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        DEBUG = false;
        MONITOR = true;
        ERR_LEVEL_INFO = 0;
        ERR_LEVEL_WARN = -1;
        ERR_LEVEL_ERR = -2;
        ERR_LEVEL_FATAL = -3;
        NAMEVAR_DOC_PLACE = NAMEVAR_DOC_PLACE;
        NAMEVAR_PREV = NAMEVAR_PREV;
        NAMEVAR_NEXT = NAMEVAR_NEXT;
        NAMEVAR_HOME = NAMEVAR_HOME;
        NAMEVAR_TOC = NAMEVAR_TOC;
        START = 0;
        END = 1;
        tagsX1 = new String[]{"<X1>", "</X1>"};
        NAMEVAR_FILE = NAMEVAR_FILE;
        NAMEVAR_TITLE = NAMEVAR_TITLE;
        TEMPLATE_BODY_FILE = TEMPLATE_BODY_FILE;
        TEMPLATE_HEADER_FILE = TEMPLATE_HEADER_FILE;
        TEMPLATE_FOOTER_FILE = TEMPLATE_FOOTER_FILE;
        TEMPLATE_TOC_FILE = TEMPLATE_TOC_FILE;
        TEMPLATE_SUBTOC_FILE = TEMPLATE_SUBTOC_FILE;
    }

    static class TagExpression {
        String expression = null;
        String attributeVal = null;
        String attribute = null;
        String bookmark = null;
        String tagType = null;
        int attributeStartNdx = -1;

        public TagExpression(String expression, String attribute) {
            int jj;
            this.expression = expression;
            this.attribute = attribute;
            int ndx = TagExpression.indexOfWhitespace(expression, 0);
            this.tagType = expression.substring(1, ndx).toUpperCase();
            ndx = expression.toUpperCase().indexOf(" ".concat(String.valueOf(String.valueOf(attribute.toUpperCase()))), ndx);
            if (ndx < 0) {
                this.attributeVal = "";
            }
            this.attributeStartNdx = 0;
            ndx = expression.indexOf(61, ndx);
            String str = expression.substring(ndx + 1);
            int ndx2 = -1;
            for (jj = 0; jj < str.length() - 2; ++jj) {
                if (str.charAt(jj) == '\"') {
                    ndx2 = str.indexOf(34, jj + 1);
                    ++jj;
                    break;
                }
                if (str.charAt(jj) == '\'') {
                    ndx2 = str.indexOf(39, jj + 1);
                    ++jj;
                    break;
                }
                if (Character.isLetter(str.charAt(jj))) {
                    ndx2 = TagExpression.indexOfWhitespace(str, jj + 1);
                    break;
                }
                if (str.charAt(jj) == '.') {
                    ndx2 = TagExpression.indexOfWhitespace(str, jj + 1);
                    break;
                }
                if (str.charAt(jj) != '/') continue;
                ndx2 = TagExpression.indexOfWhitespace(str, jj + 1);
                break;
            }
            if (ndx2 > jj) {
                this.attributeVal = str.substring(jj, ndx2);
                int ndxpang = this.attributeVal.indexOf(35);
                if (ndxpang >= 0 && ndxpang < this.attributeVal.length()) {
                    String fullAttrb = this.attributeVal;
                    this.attributeVal = this.attributeVal.substring(0, ndxpang);
                    this.bookmark = fullAttrb.substring(ndxpang + 1);
                }
                this.attributeStartNdx = ndx + 1 + jj;
            } else {
                System.err.println("ERR: TagExpression creation Err of ".concat(String.valueOf(String.valueOf(str))));
            }
        }

        private static int indexOfWhitespace(String str, int startChrNdx) {
            int[] ndxs = new int[]{str.indexOf(32, startChrNdx), str.indexOf(9, startChrNdx), str.indexOf(13, startChrNdx), str.indexOf(10, startChrNdx), str.indexOf(12, startChrNdx)};
            Arrays.sort(ndxs);
            for (int ii = 0; ii < ndxs.length; ++ii) {
                if (ndxs[ii] < startChrNdx) continue;
                return ndxs[ii];
            }
            return -1;
        }

        public String getAttributeValue() {
            return this.attributeVal;
        }

        public int getAttributeStartIndex() {
            return this.attributeStartNdx;
        }

        public String getBookmark() {
            return this.bookmark;
        }

        public String getTagType() {
            return this.tagType;
        }

        public void setNewAttributeValue(String val) {
            String[] expr = new String[3];
            expr[0] = this.expression.substring(0, this.attributeStartNdx);
            expr[2] = this.expression.substring(this.attributeStartNdx + this.attributeVal.length(), this.expression.length());
            expr[1] = val;
            this.attributeVal = val;
            this.expression = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(expr[0]))).append(expr[1]).append(expr[2])));
        }

        public void setAsComment() {
            this.expression = String.valueOf(String.valueOf(new StringBuffer("<!-- ").append(this.expression).append(" -->")));
        }

        public void setEmpty() {
            this.tagType = "";
            this.expression = "";
            this.attributeVal = "";
            this.attribute = "";
            this.attributeStartNdx = -1;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    class Head {
        static final int STS_OK = 0;
        static final int STS_MORE = -1;
        static final int STS_ERR = -2;
        StringBuffer sbuffer = new StringBuffer(1000);
        boolean startHeadTagFound = false;
        String remainTxt = null;
        String sep = null;
        StringBuffer interimBuffer = new StringBuffer();
        String firstHxTxt = null;
        String firstTagUc = "<H1";
        String firstTagLc = "<h1";

        Head(HtmlDoc this$0) {
            this.sep = System.getProperty("line.separator");
        }

        Head(HtmlDoc this$0, String firstTagUc) {
            this(this$0);
            firstTagUc = firstTagUc.toUpperCase();
            this.firstTagLc = this.firstTagLc.toLowerCase();
        }

        int fillHead(String txt) {
            int ndx2 = -1;
            if (this.startHeadTagFound) {
                ndx2 = txt.indexOf(">");
                if (ndx2 > 0) {
                    this.sbuffer.append(String.valueOf(String.valueOf(txt.substring(0, ndx2 + 1))).concat(String.valueOf(String.valueOf(this.sep))));
                    if (ndx2 < txt.length()) {
                        this.remainTxt = String.valueOf(String.valueOf(txt.substring(ndx2 + 1))).concat(String.valueOf(String.valueOf(this.sep)));
                    }
                    return 0;
                }
                this.sbuffer.append(String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.sep))));
                return -1;
            }
            int ndx = txt.indexOf("<BODY");
            if (ndx < 0) {
                ndx = txt.indexOf("<body");
            }
            if (ndx < 0) {
                this.sbuffer.append(String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.sep))));
                return -1;
            }
            this.startHeadTagFound = true;
            ndx2 = txt.indexOf(">", 5);
            if (ndx2 > 0) {
                this.sbuffer.append(String.valueOf(String.valueOf(txt.substring(0, ndx2 + 1))).concat(String.valueOf(String.valueOf(this.sep))));
                if (ndx2 < txt.length()) {
                    this.remainTxt = String.valueOf(String.valueOf(txt.substring(ndx2 + 1))).concat(String.valueOf(String.valueOf(this.sep)));
                }
                return 0;
            }
            this.sbuffer.append(String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.sep))));
            return -1;
        }

        int fillInterim(String txt) {
            int ndx = txt.indexOf(this.firstTagUc);
            if (ndx < 0) {
                ndx = txt.indexOf(this.firstTagLc);
            }
            if (ndx < 0) {
                this.interimBuffer.append(String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.sep))));
                return -1;
            }
            if (ndx == 0) {
                this.firstHxTxt = txt;
                return 0;
            }
            this.interimBuffer.append(String.valueOf(String.valueOf(txt.substring(0, ndx))).concat(String.valueOf(String.valueOf(this.sep))));
            this.firstHxTxt = txt.substring(ndx);
            return 0;
        }

        String getFirstPartOfSegment() {
            return this.firstHxTxt;
        }

        String getRemainOfLine() {
            return this.remainTxt;
        }

        String getHeadText() {
            return this.sbuffer.toString();
        }

        String getInterimText() {
            return this.interimBuffer.toString();
        }

        static {
            STS_OK = 0;
            STS_MORE = -1;
            STS_ERR = -2;
        }
    }

    class Segment {
        static final int STS_OK = 0;
        static final int STS_MORE = -1;
        static final int STS_ERR = -2;
        static final int STS_END = 1;
        StringBuffer sbuffer = null;
        String segmentTxt = null;
        String firstHxTxt = "";
        int levelMax;
        String sep = null;

        Segment(HtmlDoc this$0, int levelMax) {
            this.levelMax = levelMax;
            this.sep = System.getProperty("line.separator");
        }

        int fillSegment(String txt) {
            int success;
            int ndx = -1;
            int ndx2 = -1;
            if (this.sbuffer == null) {
                this.sbuffer = new StringBuffer(1000);
                this.sbuffer.append(txt.substring(0, 4));
                if (txt.length() > 4) {
                    txt = txt.substring(4);
                } else {
                    return -1;
                }
            }
            if ((ndx = this.indexOfHeading(txt, false)) < 0) {
                ndx = txt.indexOf("</BODY>");
                if (ndx < 0) {
                    ndx = txt.indexOf("</body>");
                }
                if (ndx < 0) {
                    this.sbuffer.append(String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.sep))));
                    return -1;
                }
                if (ndx == 0) {
                    this.firstHxTxt = txt;
                    success = 1;
                } else {
                    this.sbuffer.append(String.valueOf(String.valueOf(txt.substring(0, ndx))).concat(String.valueOf(String.valueOf(this.sep))));
                    this.firstHxTxt = txt.substring(ndx);
                    success = 1;
                }
            } else if (ndx == 0) {
                this.firstHxTxt = txt;
                success = 0;
            } else {
                this.sbuffer.append(String.valueOf(String.valueOf(txt.substring(0, ndx))).concat(String.valueOf(String.valueOf(this.sep))));
                if (ndx < txt.length()) {
                    this.firstHxTxt = txt.substring(ndx);
                }
                success = 0;
            }
            this.segmentTxt = this.sbuffer.toString();
            this.sbuffer = null;
            return success;
        }

        String getSegmentText() {
            return this.segmentTxt;
        }

        String getHeadingNoHTag() {
            int ndx = this.segmentTxt.indexOf("</H");
            if (ndx < 0) {
                ndx = this.segmentTxt.indexOf("</h");
            }
            if (ndx < 0) {
                return null;
            }
            if (this.segmentTxt.charAt(2) != this.segmentTxt.charAt(ndx + 3)) {
                return null;
            }
            return this.segmentTxt.substring(4, ndx);
        }

        String getFirstPartOfNextSegment() {
            return this.firstHxTxt;
        }

        private int indexOfHeading(String inputTxt, boolean endTag) {
            int foundLevel = 6;
            int ndx = 0;
            while (ndx >= 0 && foundLevel > this.levelMax) {
                int ndx2 = ndx;
                if (endTag) {
                    ndx = inputTxt.indexOf("</H", ndx2);
                    if (ndx < 0) {
                        ndx = inputTxt.indexOf("</h", ndx2);
                    }
                    if (ndx < 0) {
                        return -1;
                    }
                    if (inputTxt.charAt(ndx + 4) != '>') {
                        return -1;
                    }
                    foundLevel = inputTxt.charAt(3) - 48;
                    if (foundLevel >= this.levelMax) continue;
                    ndx += 4;
                    continue;
                }
                ndx = inputTxt.indexOf("<H", ndx2);
                if (ndx < 0) {
                    ndx = inputTxt.indexOf("<h", ndx2);
                }
                if (ndx < 0) {
                    return -1;
                }
                foundLevel = inputTxt.charAt(2) - 48;
                if (foundLevel <= this.levelMax) continue;
                ndx += 3;
            }
            return ndx;
        }

        static {
            STS_OK = 0;
            STS_MORE = -1;
            STS_ERR = -2;
            STS_END = 1;
        }
    }
}

