/*
 * Decompiled with CFR 0.152.
 */
package hsplitter.model;

import hsplitter.tools.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class HTOC {
    private static final boolean DEBUG = false;
    public static final int STS_OK = 0;
    public static final int STS_ERR = -2;
    public static final int STS_WARN = -1;
    private static final String NAMEVAR_NAME = "@NAME@";
    private static final String NAMEVAR_FILE = "@FILEPATH@";
    private static final String NAMEVAR_TITLE = "@TITLE@";
    private static final int START = 0;
    private static final int END = 1;
    private static final String[] tagsX1;
    private static final String[] tagsX2;
    private static final String[] tagsX3;
    private static final String[] tagsX12;
    private static final String[] tagsX23;
    private static final String[] tagsX32;
    private static final String[] tagsX21;
    private static final int NDX_X1a = 0;
    private static final int NDX_X12 = 1;
    private static final int NDX_X2 = 2;
    private static final int NDX_X23 = 3;
    private static final int NDX_X3 = 4;
    private static final int NDX_X32 = 5;
    private static final int NDX_X21 = 6;
    private static final int NDX_X1b = 7;
    String[][] tagsX = new String[][]{tagsX1, tagsX12, tagsX2, tagsX23, tagsX3, tagsX32, tagsX21};
    private String[] subTemplates = new String[]{"", "", "", "", "", "", "", ""};
    private String templateHead = null;
    private String templateFoot = null;
    private String[] titles = null;
    private String[] filepaths = null;
    private int[] levels = null;
    private String mainName = null;
    private String[] targets = null;
    private String[] indents = new String[]{"", "   ", "      "};
    private String basepath = "";
    private File adir = null;
    private int qty = 0;
    private String properExt = null;
    private Logger logger = null;

    public HTOC(String mainName, int[] levels, String[] titles, String[] filepaths) {
        this.mainName = mainName;
        this.levels = levels;
        this.titles = titles;
        this.filepaths = filepaths;
        this.qty = levels.length;
        this.targets = new String[this.qty];
        for (int ii = 0; ii < this.subTemplates.length; ++ii) {
            this.subTemplates[ii] = null;
        }
        this.logger = Logger.getLogger(null, false);
    }

    public int init(File adir, String template, String properExt) {
        int ii;
        if (template == null) {
            this.logger.logErr("Empty, malformed or not found TOC template");
            return -2;
        }
        this.logger.logASpaceLine();
        this.logger.logInfo("Review TOC Template X Tags ---------------------------------");
        this.adir = adir;
        this.properExt = properExt;
        if (this.qty <= 0) {
            return -2;
        }
        int posprev = 0;
        int pos = template.indexOf(tagsX1[0]);
        if (pos < 0) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERR: No ").append(tagsX1[0]).append(" tag"))));
            this.logger.logErr(String.valueOf(String.valueOf(new StringBuffer("No ").append(tagsX1[0]).append(" tag"))));
            return -2;
        }
        this.templateHead = template.substring(posprev, pos);
        int pos2 = -1;
        for (ii = 0; ii < this.tagsX.length; ++ii) {
            pos = template.indexOf(this.tagsX[ii][0]);
            pos2 = template.indexOf(this.tagsX[ii][1]);
            if (pos > 0 && pos2 > 0) {
                this.subTemplates[ii] = template.substring(pos + this.tagsX[ii][0].length(), pos2);
                continue;
            }
            if (pos < 0) {
                this.logger.logWarn(String.valueOf(String.valueOf(new StringBuffer("No ").append(this.tagsX[ii][0]).append(" tag"))));
                this.subTemplates[ii] = "";
                continue;
            }
            if (pos2 >= 0) continue;
            this.logger.logWarn(String.valueOf(String.valueOf(new StringBuffer("No ").append(this.tagsX[ii][1]).append(" tag"))));
            this.subTemplates[ii] = "";
        }
        pos = template.indexOf(this.tagsX[0][1]) + this.tagsX[0][1].length();
        pos = template.indexOf(this.tagsX[0][0], pos + 1);
        pos2 = template.indexOf(this.tagsX[0][1], pos + 1);
        if (pos > 0 && pos2 > 0) {
            this.subTemplates[7] = template.substring(pos + this.tagsX[0][0].length(), pos2);
        } else if (pos < 0) {
            this.logger.logWarn(String.valueOf(String.valueOf(new StringBuffer("No second ").append(this.tagsX[0][0]).append(" tag"))));
        } else if (pos2 < 0) {
            this.logger.logWarn(String.valueOf(String.valueOf(new StringBuffer("No second ").append(this.tagsX[0][1]).append(" tag"))));
        }
        for (ii = 0; ii < this.tagsX.length; ++ii) {
            this.logger.logInfo(String.valueOf(String.valueOf(new StringBuffer("Template: ").append(this.tagsX[ii][0]).append(", Content= ").append(this.subTemplates[ii]))));
        }
        this.logger.logInfo(String.valueOf(String.valueOf(new StringBuffer("Template: ").append(this.tagsX[0][0]).append(", Content= ").append(this.subTemplates[7]))));
        pos2 = template.lastIndexOf("</X");
        pos = pos2 < 0 ? template.lastIndexOf("</BODY>") : template.indexOf(62, pos2) + 1;
        if (pos < 0) {
            this.logger.logErr("No proper Foot definition");
            return -2;
        }
        this.templateFoot = template.substring(pos);
        return 0;
    }

    public int doToc(String tocfilename) {
        int sts = 0;
        sts = this.writeFromTemplate(String.valueOf(String.valueOf(tocfilename)).concat(String.valueOf(String.valueOf(this.properExt))));
        return sts;
    }

    private String parseSubTemplate(String atemplate, int itemNdx) {
        if (atemplate == null || atemplate.equals("")) {
            return "";
        }
        String filnam = String.valueOf(String.valueOf(this.filepaths[itemNdx])).concat(String.valueOf(String.valueOf(this.properExt)));
        String txt = "";
        int posprev = 0;
        int pos = atemplate.indexOf(64);
        while (pos >= 0) {
            String varval = null;
            int len = 0;
            if (atemplate.substring(pos).startsWith(NAMEVAR_TITLE)) {
                varval = this.titles[itemNdx];
                len = NAMEVAR_TITLE.length();
            } else if (atemplate.substring(pos).startsWith(NAMEVAR_FILE)) {
                varval = String.valueOf(String.valueOf(this.filepaths[itemNdx])).concat(String.valueOf(String.valueOf(this.properExt)));
                len = NAMEVAR_FILE.length();
            } else if (atemplate.substring(pos).startsWith(NAMEVAR_NAME)) {
                varval = this.mainName;
                len = NAMEVAR_NAME.length();
            }
            if (varval == null) {
                // empty if block
            }
            txt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(txt))).append(atemplate.substring(posprev, pos)).append(varval)));
            posprev = pos + len;
            pos = atemplate.indexOf(64, posprev + 1);
        }
        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(atemplate.substring(posprev))));
        return txt;
    }

    /*
     * Loose catch block
     */
    private int writeFromTemplate(String targetFileName) {
        int success;
        block28: {
            success = 0;
            String sep = System.getProperty("line.separator");
            OutputStreamWriter fw = null;
            String txt = "";
            String head = "";
            String foot = "";
            String part = "";
            head = this.parseSubTemplate(this.templateHead, 0);
            txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(head)));
            for (int ii = 0; ii < this.qty; ++ii) {
                switch (this.levels[ii]) {
                    case 0: {
                        part = this.parseSubTemplate(this.subTemplates[0], ii);
                        break;
                    }
                    case 1: {
                        part = this.parseSubTemplate(this.subTemplates[2], ii);
                        break;
                    }
                    case 2: {
                        part = this.parseSubTemplate(this.subTemplates[4], ii);
                    }
                }
                if (ii < this.qty - 1 && ii > 0 && this.levels[ii + 1] > this.levels[ii] && this.levels[ii - 1] > this.levels[ii]) {
                    if (this.levels[ii] == 1) {
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[5])));
                    } else {
                        if (this.levels[ii - 1] == 2) {
                            txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[5])));
                        }
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[6])));
                    }
                    txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(part)));
                    if (this.levels[ii] == 1) {
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[3])));
                        continue;
                    }
                    txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[1])));
                    continue;
                }
                if (ii < this.qty - 1 && this.levels[ii + 1] > this.levels[ii]) {
                    txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(part)));
                    if (this.levels[ii] == 1) {
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[3])));
                        continue;
                    }
                    txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[1])));
                    continue;
                }
                if (ii > 0 && this.levels[ii - 1] > this.levels[ii]) {
                    if (this.levels[ii] == 1) {
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[5])));
                    } else {
                        if (this.levels[ii - 1] == 2) {
                            txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[5])));
                        }
                        txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(this.subTemplates[6])));
                    }
                    txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(part)));
                    continue;
                }
                txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(part)));
            }
            foot = this.parseSubTemplate(this.templateFoot, 0);
            txt = String.valueOf(String.valueOf(txt)).concat(String.valueOf(String.valueOf(foot)));
            File targetFile = new File(this.adir, targetFileName);
            targetFile.createNewFile();
            fw = new FileWriter(targetFile);
            fw.write(txt);
            Object var11_12 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                break block28;
            }
            catch (IOException iOException) {}
            break block28;
            {
                catch (Exception ee) {
                    success = -2;
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERR: Err with ").append(targetFileName).append(", Err= ").append(ee))));
                    this.logger.logErr(String.valueOf(String.valueOf(new StringBuffer("Err with ").append(targetFileName).append(", Err= ").append(ee))));
                    Object var11_13 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block28;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return success;
    }

    public static void main(String[] args) {
    }

    static {
        DEBUG = false;
        STS_OK = 0;
        STS_ERR = -2;
        STS_WARN = -1;
        NAMEVAR_NAME = NAMEVAR_NAME;
        NAMEVAR_FILE = NAMEVAR_FILE;
        NAMEVAR_TITLE = NAMEVAR_TITLE;
        START = 0;
        END = 1;
        tagsX1 = new String[]{"<X1>", "</X1>"};
        tagsX2 = new String[]{"<X2>", "</X2>"};
        tagsX3 = new String[]{"<X3>", "</X3>"};
        tagsX12 = new String[]{"<X12>", "</X12>"};
        tagsX23 = new String[]{"<X23>", "</X23>"};
        tagsX32 = new String[]{"<X32>", "</X32>"};
        tagsX21 = new String[]{"<X21>", "</X21>"};
        NDX_X1a = 0;
        NDX_X12 = 1;
        NDX_X2 = 2;
        NDX_X23 = 3;
        NDX_X3 = 4;
        NDX_X32 = 5;
        NDX_X21 = 6;
        NDX_X1b = 7;
    }
}

