/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MetalTreeUI
extends BasicTreeUI {
    private static Color lineColor;
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private PropertyChangeListener lineStyleListener = new LineListener();

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTreeUI();
    }

    protected void decodeLineStyle(Object object) {
        if (object == null || object.equals(NO_STYLE_STRING)) {
            this.lineStyle = 0;
        } else if (object.equals(LEG_LINE_STYLE_STRING)) {
            this.lineStyle = 2;
        } else if (object.equals(HORIZ_STYLE_STRING)) {
            this.lineStyle = 1;
        }
    }

    protected int getHorizontalLegBuffer() {
        return 4;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        lineColor = UIManager.getColor("Tree.line");
        Object object = jComponent.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(object);
        jComponent.addPropertyChangeListener(this.lineStyleListener);
    }

    protected boolean isLocationInExpandControl(int n, int n2, int n3, int n4) {
        if (this.tree != null && !this.isLeaf(n)) {
            int n5 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() + 6 : 8;
            Insets insets = this.tree.getInsets();
            int n6 = insets != null ? insets.left : 0;
            int n7 = (n6 += (n2 + this.depthOffset - 1) * this.totalChildIndent + this.getLeftChildIndent() - n5 / 2) + n5;
            return n3 >= n6 && n3 <= n7;
        }
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(lineColor);
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n <= -1 || n2 <= -1) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            Rectangle rectangle2;
            TreePath treePath = this.getPathForRow(this.tree, n3);
            if (treePath != null && treePath.getPathCount() == 2 && (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n3))) != null) {
                graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
            }
            ++n3;
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(jComponent);
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(MetalTreeUI.LINE_STYLE)) {
                MetalTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            }
        }
    }
}

