/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

class KeyboardManager {
    static KeyboardManager currentManager = new KeyboardManager();
    Hashtable containerMap = new Hashtable();
    Hashtable componentKeyStrokeMap = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JMenuBar;

    KeyboardManager() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void fireBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent) {
        ActionListener actionListener;
        JComponent.KeyboardBinding keyboardBinding = jComponent.bindingForKeyStroke(keyStroke, 2);
        if (keyboardBinding != null && (actionListener = keyboardBinding.getAction()) != null) {
            if (actionListener instanceof Action && !((Action)actionListener).isEnabled()) {
                return;
            }
            actionListener.actionPerformed(new ActionEvent(jComponent, 1001, keyboardBinding.getCommand()));
            keyEvent.consume();
        }
    }

    public boolean fireKeyboardAction(KeyEvent keyEvent, boolean bl, Container container) {
        Object object;
        Object object2;
        Object object3;
        if (keyEvent.isConsumed()) {
            System.out.println("Aquired pre-used event!");
            Thread.dumpStack();
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), bl ^ true);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable != null && (object3 = hashtable.get(keyStroke)) != null) {
            if (object3 instanceof JComponent) {
                object2 = (JComponent)object3;
                if (((Component)object2).isShowing() && ((Component)object2).isEnabled()) {
                    this.fireBinding((JComponent)object2, keyStroke, keyEvent);
                }
            } else if (object3 instanceof Vector) {
                object2 = (Vector)object3;
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    JComponent jComponent = (JComponent)object.nextElement();
                    if (!jComponent.isShowing() || !jComponent.isEnabled()) continue;
                    this.fireBinding(jComponent, keyStroke, keyEvent);
                    if (!keyEvent.isConsumed()) continue;
                    return true;
                }
            } else {
                System.out.println("Unexpected condition in fireKeyboardAction " + object3);
                Thread.dumpStack();
            }
        }
        if (keyEvent.isConsumed()) {
            return true;
        }
        if (hashtable != null && (object3 = (Vector)hashtable.get(class$javax$swing$JMenuBar != null ? class$javax$swing$JMenuBar : (class$javax$swing$JMenuBar = KeyboardManager.class$("javax.swing.JMenuBar")))) != null) {
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (JMenuBar)object2.nextElement();
                if (!((Component)object).isShowing() || !((Component)object).isEnabled()) continue;
                this.fireBinding((JComponent)object, keyStroke, keyEvent);
                if (!keyEvent.isConsumed()) continue;
                return true;
            }
        }
        if (container instanceof JInternalFrame) {
            object3 = KeyboardManager.getTopAncestor((JInternalFrame)container);
            if (object3 == null) {
                return false;
            }
            this.fireKeyboardAction(keyEvent, bl, (Container)object3);
        }
        return keyEvent.isConsumed();
    }

    public static KeyboardManager getCurrentManager() {
        return currentManager;
    }

    private static Container getTopAncestor(JComponent jComponent) {
        Container container = jComponent.getParent();
        while (container != null) {
            if (container instanceof Window || container instanceof Applet || container instanceof JInternalFrame) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void registerKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        Object v;
        Container container = KeyboardManager.getTopAncestor(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((v = hashtable.get(keyStroke)) == null) {
            hashtable.put(keyStroke, jComponent);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            if (!vector.contains(jComponent)) {
                vector.addElement(jComponent);
            }
        } else if (v instanceof JComponent) {
            if (v != jComponent) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(jComponent);
                hashtable.put(keyStroke, vector);
            }
        } else {
            System.out.println("Unexpected condition in registerKeyStroke");
            Thread.dumpStack();
        }
        this.componentKeyStrokeMap.put(new ComponentKeyStrokePair(jComponent, keyStroke), container);
    }

    public void registerMenuBar(JMenuBar jMenuBar) {
        Vector<JMenuBar> vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((vector = (Vector<JMenuBar>)hashtable.get(class$javax$swing$JMenuBar != null ? class$javax$swing$JMenuBar : (class$javax$swing$JMenuBar = KeyboardManager.class$("javax.swing.JMenuBar")))) == null) {
            vector = new Vector<JMenuBar>();
            hashtable.put(class$javax$swing$JMenuBar != null ? class$javax$swing$JMenuBar : (class$javax$swing$JMenuBar = KeyboardManager.class$("javax.swing.JMenuBar")), vector);
        }
        if (!vector.contains(jMenuBar)) {
            vector.addElement(jMenuBar);
        }
    }

    protected Hashtable registerNewTopContainer(Container container) {
        Hashtable hashtable = new Hashtable();
        this.containerMap.put(container, hashtable);
        return hashtable;
    }

    public static void setCurrentManager(KeyboardManager keyboardManager) {
        currentManager = keyboardManager;
    }

    public void unregisterKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        ComponentKeyStrokePair componentKeyStrokePair = new ComponentKeyStrokePair(jComponent, keyStroke);
        Object v = this.componentKeyStrokeMap.get(componentKeyStrokePair);
        if (v == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.containerMap.get(v);
        if (hashtable == null) {
            Thread.dumpStack();
            return;
        }
        Object v2 = hashtable.get(keyStroke);
        if (v2 == null) {
            Thread.dumpStack();
            return;
        }
        if (v2 instanceof JComponent && v2 == jComponent) {
            hashtable.remove(keyStroke);
        } else if (v2 instanceof Vector) {
            Vector vector = (Vector)v2;
            vector.removeElement(jComponent);
            if (vector.isEmpty()) {
                hashtable.remove(keyStroke);
            }
        }
        if (hashtable.isEmpty()) {
            this.containerMap.remove(v);
        }
        this.componentKeyStrokeMap.remove(componentKeyStrokePair);
    }

    public void unregisterMenuBar(JMenuBar jMenuBar) {
        Vector vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable != null && (vector = (Vector)hashtable.get(class$javax$swing$JMenuBar != null ? class$javax$swing$JMenuBar : (class$javax$swing$JMenuBar = KeyboardManager.class$("javax.swing.JMenuBar")))) != null) {
            vector.removeElement(jMenuBar);
            if (vector.isEmpty()) {
                hashtable.remove(class$javax$swing$JMenuBar != null ? class$javax$swing$JMenuBar : (class$javax$swing$JMenuBar = KeyboardManager.class$("javax.swing.JMenuBar")));
                if (hashtable.isEmpty()) {
                    this.containerMap.remove(container);
                }
            }
        }
    }

    class ComponentKeyStrokePair {
        Object component;
        Object keyStroke;

        public ComponentKeyStrokePair(Object object, Object object2) {
            this.component = object;
            this.keyStroke = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentKeyStrokePair)) {
                return false;
            }
            ComponentKeyStrokePair componentKeyStrokePair = (ComponentKeyStrokePair)object;
            return this.component.equals(componentKeyStrokePair.component) && this.keyStroke.equals(componentKeyStrokePair.keyStroke);
        }

        public int hashCode() {
            return this.component.hashCode() * this.keyStroke.hashCode();
        }
    }
}

