/*
 * Decompiled with CFR 0.152.
 */
package com.ImajeJen;

import com.ImajeJen.DCT;
import com.ImajeJen.Huffman;
import com.ImajeJen.JpegInfo;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends Frame {
    private BufferedOutputStream _$10319;
    private Image _$906;
    private JpegInfo _$10328;
    private Huffman _$10335;
    private DCT _$10338;
    private int _$8698;
    private int _$8688;
    private int _$10341;
    private int _$10348;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder(Image image, int quality, OutputStream out) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._$10341 = quality;
        this._$10328 = new JpegInfo(image);
        this._$8698 = this._$10328.imageHeight;
        this._$8688 = this._$10328.imageWidth;
        this._$10319 = new BufferedOutputStream(out);
        this._$10338 = new DCT(this._$10341);
        this._$10335 = new Huffman(this._$8688, this._$8698);
    }

    public void setQuality(int quality) {
        this._$10338 = new DCT(quality);
    }

    public int getQuality() {
        return this._$10341;
    }

    public void Compress() {
        this.WriteHeaders(this._$10319);
        this.WriteCompressedData(this._$10319);
        this.WriteEOI(this._$10319);
        try {
            this._$10319.flush();
        }
        catch (IOException e) {
            System.out.println(String.valueOf("IO Error: ").concat(String.valueOf(e.getMessage())));
        }
    }

    public void WriteCompressedData(BufferedOutputStream outStream) {
        int comp;
        boolean temp = false;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[this._$10328.NumberOfComponents];
        int[] zeroArray = new int[64];
        int Width = 0;
        int Height = 0;
        boolean nothing = false;
        int MinBlockWidth = this._$8688 % 8 != 0 ? (int)(Math.floor((double)this._$8688 / 8.0) + 1.0) * 8 : this._$8688;
        int MinBlockHeight = this._$8698 % 8 != 0 ? (int)(Math.floor((double)this._$8698 / 8.0) + 1.0) * 8 : this._$8698;
        for (comp = 0; comp < this._$10328.NumberOfComponents; ++comp) {
            MinBlockWidth = Math.min(MinBlockWidth, this._$10328.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, this._$10328.BlockHeight[comp]);
        }
        int xpos = 0;
        for (int r = 0; r < MinBlockHeight; ++r) {
            for (int c = 0; c < MinBlockWidth; ++c) {
                xpos = c * 8;
                int ypos = r * 8;
                for (comp = 0; comp < this._$10328.NumberOfComponents; ++comp) {
                    Width = this._$10328.BlockWidth[comp];
                    Height = this._$10328.BlockHeight[comp];
                    float[][] inputArray = (float[][])this._$10328.Components[comp];
                    for (int i = 0; i < this._$10328.VsampFactor[comp]; ++i) {
                        for (int j = 0; j < this._$10328.HsampFactor[comp]; ++j) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            for (int a = 0; a < 8; ++a) {
                                for (int b = 0; b < 8; ++b) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                }
                            }
                            dctArray2 = this._$10338.forwardDCT(dctArray1);
                            dctArray3 = this._$10338.quantizeBlock(dctArray2, this._$10328.QtableNumber[comp]);
                            this._$10335.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], this._$10328.DCtableNumber[comp], this._$10328.ACtableNumber[comp]);
                            lastDCvalue[comp] = dctArray3[0];
                        }
                    }
                }
            }
        }
        this._$10335.flushBuffer(outStream);
    }

    public void WriteEOI(BufferedOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        this.WriteMarker(EOI, out);
    }

    public void WriteHeaders(BufferedOutputStream out) {
        int j;
        int i;
        byte[] SOI = new byte[]{-1, -40};
        this.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(JFIF, out);
        String comment = new String();
        comment = this._$10328.getComment();
        int length = comment.length();
        byte[] COM = new byte[length + 4];
        COM[0] = -1;
        COM[1] = -2;
        COM[2] = (byte)(length >> 8 & 0xFF);
        COM[3] = (byte)(length & 0xFF);
        System.arraycopy(this._$10328.Comment.getBytes(), 0, COM, 4, this._$10328.Comment.length());
        this.WriteArray(COM, out);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        for (i = 0; i < 2; ++i) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = (int[])this._$10338.quantum[i];
            for (j = 0; j < 64; ++j) {
                DQT[offset++] = (byte)tempArray[jpegNaturalOrder[j]];
            }
        }
        this.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)this._$10328.Precision;
        SOF[5] = (byte)(this._$10328.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(this._$10328.imageHeight & 0xFF);
        SOF[7] = (byte)(this._$10328.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(this._$10328.imageWidth & 0xFF);
        SOF[9] = (byte)this._$10328.NumberOfComponents;
        int index = 10;
        for (i = 0; i < SOF[9]; ++i) {
            SOF[index++] = (byte)this._$10328.CompID[i];
            SOF[index++] = (byte)((this._$10328.HsampFactor[i] << 4) + this._$10328.VsampFactor[i]);
            SOF[index++] = (byte)this._$10328.QtableNumber[i];
        }
        this.WriteArray(SOF, out);
        length = 2;
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        for (i = 0; i < 4; ++i) {
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)((int[])this._$10335.bits.elementAt(i))[0];
            for (j = 1; j < 17; ++j) {
                int temp = ((int[])this._$10335.bits.elementAt(i))[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            for (j = 0; j < bytes; ++j) {
                DHT2[index++ - intermediateindex] = (byte)((int[])this._$10335.val.elementAt(i))[j];
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        this.WriteArray(DHT4, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)this._$10328.NumberOfComponents;
        index = 5;
        for (i = 0; i < SOS[4]; ++i) {
            SOS[index++] = (byte)this._$10328.CompID[i];
            SOS[index++] = (byte)((this._$10328.DCtableNumber[i] << 4) + this._$10328.ACtableNumber[i]);
        }
        SOS[index++] = (byte)this._$10328.Ss;
        SOS[index++] = (byte)this._$10328.Se;
        SOS[index++] = (byte)((this._$10328.Ah << 4) + this._$10328.Al);
        this.WriteArray(SOS, out);
    }

    void WriteMarker(byte[] data, BufferedOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            System.out.println(String.valueOf("IO Error: ").concat(String.valueOf(e.getMessage())));
        }
    }

    void WriteArray(byte[] data, BufferedOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            System.out.println(String.valueOf("IO Error: ").concat(String.valueOf(e.getMessage())));
        }
    }
}

