package com.gotdns.jimula.EatHealthy;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;

/**
 * <em>ServingPanel</em> is a module that can calculate food serving.
 * It has a method {@link #addPanel() addPanel()}which return this panel to MainFrame.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 * @see com.gotdns.jimula.EatHealthy.MainFrame
 */
public class ServingPanel {

  JPanel panel_allocate = new JPanel();
  JPanel panel_table = new JPanel();
  JLabel lbl_food_type = new JLabel();
  JLabel lbl_serving = new JLabel();
  JLabel lbl_protein = new JLabel();
  JLabel lbl_fat = new JLabel();
  JLabel lbl_carb = new JLabel();
  JLabel lbl_calories=new JLabel();
  FlowLayout flowLayout1 = new FlowLayout();
  JPanel panel_milk = new JPanel();
  JLabel lbl_milk = new JLabel();
  JComboBox cb_milk = new JComboBox(milk_list_init());
  JComboBox cb_milk_serving = new JComboBox(milk_serving_list_init());
  JLabel lbl_milk_protein = new JLabel();
  JLabel lbl_milk_fat = new JLabel();
  JLabel lbl_milk_carb = new JLabel();
  JLabel lbl_milk_calories = new JLabel();
  JLabel lbl_vegetable = new JLabel();
  JComboBox cb_vegetable_serving = new JComboBox(vegetable_serving_list_init());
  JLabel lbl_vegetable_protein = new JLabel();
  JLabel lbl_vegetable_fat = new JLabel();
  JLabel lbl_vegetable_carb = new JLabel();
  JLabel lbl_vegetable_calories = new JLabel();
  JLabel lbl_fruit = new JLabel();
  JComboBox cb_fruit_serving = new JComboBox(fruit_serving_list_init());
  JLabel lbl_fruit_protein = new JLabel();
  JLabel lbl_fruit_fat = new JLabel();
  JLabel lbl_fruit_carb = new JLabel();
  JLabel lbl_fruit_calories = new JLabel();
  JLabel lbl_starches = new JLabel();
  JLabel lbl_starches_serving = new JLabel();
  JLabel lbl_starches_protein = new JLabel();
  JLabel lbl_starches_fat = new JLabel();
  JLabel lbl_starches_carb = new JLabel();
  JLabel lbl_starches_calories = new JLabel();
  JPanel panel_meat = new JPanel();
  JLabel lbl_meat = new JLabel();
  JComboBox cb_meat = new JComboBox(meat_list_init());
  JLabel lbl_meat_serving = new JLabel();
  JLabel lbl_meat_protein = new JLabel();
  JLabel lbl_meat_fat = new JLabel();
  JLabel lbl_meat_carb = new JLabel();
  JLabel lbl_meat_calories = new JLabel();
  JLabel lbl_oil = new JLabel();
  JLabel lbl_oil_serving = new JLabel();
  JLabel lbl_oil_protein = new JLabel();
  JLabel lbl_oil_fat = new JLabel();
  JLabel lbl_oil_carb = new JLabel();
  JLabel lbl_oil_calories = new JLabel();
  JLabel lbl_total = new JLabel();
  JLabel lbl_total_protein = new JLabel();
  JLabel lbl_total_fat = new JLabel();
  JLabel lbl_total_carb = new JLabel();
  JLabel lbl_total_calories = new JLabel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  FlowLayout flowLayout2 = new FlowLayout();

  private String milk_fat;
  private String meat_fat;
  private int milk_serving;
  private int vegetable_serving;
  private int fruit_serving;
  private int starches_serving;
  private int meat_serving;
  private int oil_serving;

  private int milk_protein;
  private int int_milk_fat;
  private int milk_carb;
  private int vegetable_protein;
  private int vegetable_fat;
  private int vegetable_carb;
  private int fruit_carb;

  private int starches_protein;
  private int starches_carb;
  private int meat_protein;
  private int oil_fat;
  private int int_meat_fat;

  private int milk_calories;
  private int vegetable_calories;
  private int fruit_calories;
  private int starches_calories;
  private int meat_calories;
  private int oil_calories;

  private int total_protein;
  private int total_fat;
  private int total_carb;
  private int total_calories;

  /**
   * Protein contents of actual serving
   */
  public float actual_protein;

  /**
   *  Fat contents of actual serving
   */
  public float actual_fat;

  /**
   *  Carbohydrate contents of actual serving
   */
  public float actual_carb;

  /**
   * Calories contents of actual serving
   */
  public float actual_calories;

  JLabel lbl_blank = new JLabel();
  JLabel lbl_actual = new JLabel();
  JLabel lbl_actual_protein = new JLabel();
  JLabel lbl_actual_fat = new JLabel();
  JLabel lbl_actual_carb = new JLabel();
  JLabel lbl_actual_calories = new JLabel();
  JButton butt_start_over = new JButton();
  JTextArea txtArea_warm = new JTextArea();
  MainFrame frame;
  JLabel jLabel1 = new JLabel();
  Component component1;

  /**
   * Construsts a new ServingPanel instance.
   * This construstor is evoked by food serving button of tools bar.
   * User can directly input personal nutrient to calculate food serving.
   * @param frame parent frame(MainFrame)
   * @see com.gotdns.jimula.EatHealthy.MainFrame
   */
  public ServingPanel(MainFrame frame){
   this.frame=frame;
   addNutrientPane();
  try {
    jbInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }

 }

 /**
    * Construsts a new ServingPanel instance.
    * This construstor is evoked by NutrientPanel.
    * @param frame parent frame(MainFrame)
    * @param protein personal nutrient need of protein contents
    * @param fat personal nutrient need of fat contents
    * @param carb personal nutrient need of carbohydrate contents
    * @param calories personal nutrient need of calories contents
    * @see com.gotdns.jimula.EatHealthy.MainFrame
    * @see com.gotdns.jimula.EatHealthy.NutrientPanel
    */
  public ServingPanel(MainFrame frame, float protein,float fat,float carb,float calories){
    this.frame=frame;
    this.actual_protein=protein;
    this.actual_fat=fat;
    this.actual_carb=carb;
    this.actual_calories=calories;
  try {
    jbInit();
  }
  catch(Exception e) {
    e.printStackTrace();
  }
}

//Component initialization
private void jbInit() throws Exception  {
    component1 = Box.createHorizontalStrut(8);
    lbl_food_type.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_food_type.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_food_type.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_food_type.setText("Food Type");
    panel_allocate.setLayout(null);
    panel_table.setBorder(BorderFactory.createEtchedBorder());
    panel_table.setBounds(new Rectangle(1, 30, 503, 213));
    panel_table.setLayout(gridBagLayout1);
    lbl_serving.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_serving.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_serving.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_serving.setText("serving");
    lbl_protein.setBackground(Color.pink);
    lbl_protein.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_protein.setRequestFocusEnabled(true);
    lbl_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_protein.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_protein.setText("Protein (g)");
    lbl_fat.setBackground(Color.white);
    lbl_fat.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fat.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_fat.setText("Fat (g)");
    lbl_carb.setBackground(Color.lightGray);
    lbl_carb.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_carb.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_carb.setText("Carbohydrate (g)");
    lbl_calories.setFont(new java.awt.Font("Dialog", 1, 12));
    lbl_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_calories.setText("Calories (Kcal)");
    panel_milk.setBorder(BorderFactory.createLineBorder(Color.black));
    panel_milk.setDebugGraphicsOptions(0);
    panel_milk.setPreferredSize(new Dimension(68, 10));
    panel_milk.setLayout(flowLayout1);
    lbl_milk.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_milk.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_milk.setText("MILK");
    lbl_milk_protein.setBackground(Color.white);
    lbl_milk_protein.setForeground(new Color(255, 0, 171));
    lbl_milk_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_milk_protein.setPreferredSize(new Dimension(68, 10));
    lbl_milk_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_milk_protein.setText("");
    lbl_milk_fat.setBackground(Color.white);
    lbl_milk_fat.setForeground(new Color(203, 158, 131));
    lbl_milk_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_milk_fat.setPreferredSize(new Dimension(68, 10));
    lbl_milk_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_milk_carb.setBackground(Color.white);
    lbl_milk_carb.setForeground(new Color(0, 151, 0));
    lbl_milk_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_milk_carb.setPreferredSize(new Dimension(68, 10));
    lbl_milk_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_milk_calories.setForeground(new Color(210, 138, 0));
    lbl_milk_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_milk_calories.setPreferredSize(new Dimension(68, 10));
    lbl_milk_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_vegetable.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_vegetable.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_vegetable.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_vegetable.setText("vegetables");
    lbl_vegetable_protein.setBackground(Color.white);
    lbl_vegetable_protein.setForeground(new Color(255, 0, 171));
    lbl_vegetable_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_vegetable_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_vegetable_protein.setText("");
    lbl_vegetable_fat.setBackground(Color.white);
    lbl_vegetable_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_vegetable_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_vegetable_fat.setText("-");
    lbl_vegetable_carb.setBackground(Color.white);
    lbl_vegetable_carb.setForeground(new Color(0, 151, 0));
    lbl_vegetable_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_vegetable_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_vegetable_calories.setForeground(new Color(210, 138, 0));
    lbl_vegetable_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_vegetable_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fruit.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_fruit.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fruit.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fruit.setText("Fruits");
    lbl_fruit_protein.setBackground(Color.pink);
    lbl_fruit_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fruit_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fruit_protein.setText("-");
    lbl_fruit_fat.setBackground(Color.white);
    lbl_fruit_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fruit_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fruit_fat.setText("-");
    lbl_fruit_carb.setBackground(Color.white);
    lbl_fruit_carb.setForeground(new Color(0, 151, 0));
    lbl_fruit_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fruit_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fruit_calories.setForeground(new Color(210, 138, 0));
    lbl_fruit_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_fruit_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_starches.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches.setText("Starches");
    lbl_starches_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_starches_serving.setForeground(Color.blue);
    lbl_starches_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches_serving.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches_protein.setBackground(Color.white);
    lbl_starches_protein.setForeground(new Color(255, 0, 171));
    lbl_starches_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches_protein.setText("");
    lbl_starches_fat.setBackground(Color.white);
    lbl_starches_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches_fat.setText("-");
    lbl_starches_carb.setBackground(Color.white);
    lbl_starches_carb.setForeground(new Color(0, 151, 0));
    lbl_starches_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_starches_carb.setText("");
    lbl_starches_calories.setForeground(new Color(210, 138, 0));
    lbl_starches_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_starches_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_meat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat.setText("Protein");
    lbl_meat_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_meat_serving.setForeground(Color.blue);
    lbl_meat_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_meat_serving.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat_protein.setBackground(Color.white);
    lbl_meat_protein.setForeground(new Color(255, 0, 171));
    lbl_meat_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_meat_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat_protein.setText("");
    lbl_meat_fat.setBackground(Color.white);
    lbl_meat_fat.setForeground(new Color(203, 158, 131));
    lbl_meat_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_meat_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat_carb.setBackground(Color.white);
    lbl_meat_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_meat_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_meat_carb.setText("-");
    lbl_meat_calories.setForeground(new Color(210, 138, 0));
    lbl_meat_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_meat_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_oil.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil.setText("Fats");
    lbl_oil_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_oil_serving.setForeground(Color.blue);
    lbl_oil_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil_serving.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil_protein.setBackground(Color.pink);
    lbl_oil_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil_protein.setText("-");
    lbl_oil_fat.setBackground(Color.white);
    lbl_oil_fat.setForeground(new Color(203, 158, 131));
    lbl_oil_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil_fat.setText("");
    lbl_oil_carb.setBackground(Color.white);
    lbl_oil_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_oil_carb.setText("-");
    lbl_oil_calories.setForeground(new Color(210, 138, 0));
    lbl_oil_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_oil_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_total.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_total.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_total.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_total.setText("Total");
    lbl_total_protein.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_total_protein.setForeground(Color.BLUE);
    lbl_total_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_total_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_total_protein.setText("");
    lbl_total_fat.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_total_fat.setForeground(Color.BLUE);
    lbl_total_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_total_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_total_carb.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_total_carb.setForeground(Color.BLUE);
    lbl_total_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_total_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_total_calories.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_total_calories.setForeground(Color.BLUE);
    lbl_total_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_total_calories.setHorizontalAlignment(SwingConstants.CENTER);
    cb_vegetable_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    cb_vegetable_serving.setForeground(Color.blue);
    cb_vegetable_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    cb_vegetable_serving.setActionCommand("comboBoxChanged");
    cb_vegetable_serving.addActionListener(new ServingPanel_cb_vegetable_serving_actionAdapter(this));
    vegetable_serving=Integer.parseInt(String.valueOf(cb_vegetable_serving.getSelectedItem()));
    cb_fruit_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    cb_fruit_serving.setForeground(Color.blue);
    cb_fruit_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    cb_fruit_serving.addActionListener(new ServingPanel_cb_fruit_serving_actionAdapter(this));
    fruit_serving=Integer.parseInt(String.valueOf(cb_fruit_serving.getSelectedItem()));
    panel_meat.setBorder(BorderFactory.createLineBorder(Color.black));
    panel_meat.setPreferredSize(new Dimension(0, 0));
    panel_meat.setLayout(flowLayout2);
    this.meat_fat=String.valueOf(cb_meat.getSelectedItem());
    cb_milk_serving.setFont(new java.awt.Font("Dialog", 1, 11));
    cb_milk_serving.setForeground(Color.blue);
    cb_milk_serving.setBorder(BorderFactory.createLineBorder(Color.black));
    cb_milk_serving.setPreferredSize(new Dimension(68, 10));
    cb_milk_serving.addActionListener(new ServingPanel_cb_milk_serving_actionAdapter(this));
    this.milk_serving =Integer.parseInt(String.valueOf(cb_milk_serving.getSelectedItem()));
    this.milk_fat=String.valueOf(cb_milk.getSelectedItem());
    cb_meat.setPreferredSize(new Dimension(70, 18));
    cb_meat.setMaximumRowCount(8);
    cb_meat.addActionListener(new ServingPanel_cb_meat_actionAdapter(this));
    cb_milk.setPreferredSize(new Dimension(70, 18));
    cb_milk.addActionListener(new ServingPanel_cb_milk_actionAdapter(this));
    flowLayout1.setAlignment(FlowLayout.CENTER);
    lbl_actual.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_actual.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_actual.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_actual.setText("Nutrient Need");
    lbl_actual_protein.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_actual_protein.setForeground(Color.black);
    lbl_actual_protein.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_actual_protein.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_actual_protein.setText("");
    lbl_actual_fat.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_actual_fat.setForeground(Color.black);
    lbl_actual_fat.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_actual_fat.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_actual_fat.setText("");
    lbl_actual_carb.setBackground(Color.white);
    lbl_actual_carb.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_actual_carb.setForeground(Color.black);
    lbl_actual_carb.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_actual_carb.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_actual_carb.setText("");
    lbl_actual_calories.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_actual_calories.setForeground(Color.black);
    lbl_actual_calories.setBorder(BorderFactory.createLineBorder(Color.black));
    lbl_actual_calories.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_actual_calories.setText("");
    lbl_blank.setText("");
    show_serving();

    butt_start_over.setBounds(new Rectangle(20, 265, 164, 30));
    butt_start_over.setText("Calculate Nutrient Need");
    butt_start_over.addActionListener(new ServingPanel_butt_start_over_actionAdapter(this));
    txtArea_warm.setBounds(new Rectangle(186, 254, 488, 170));
    txtArea_warm.setText("Your calories are too heigh,try to adjust your serving, or milk and protein fat quantity.\n"+
                         "\n"+
                         "If you add more serving of milk, fruit, or vegetable, calories may get lower because\n"+
                         "the serving of starches, protein, and fat are depend on serving of others.\n"+
                         "\n"+
                         "Example, you add more milk then the serving of protein may get less.");

    jLabel1.setFont(new java.awt.Font("Dialog", 1, 11));
    jLabel1.setText("You can click the button in the tool bar to show Food Exchange List.");
    jLabel1.setBounds(new Rectangle(5, 4, 400, 22));

    //Set GridBagConstraints
    component1.setBounds(new Rectangle(328, 296, 8, 0));
    panel_table.add(lbl_food_type,                               new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 80, 0));
    panel_table.add(lbl_serving,                     new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 20, 0));
    panel_table.add(lbl_protein,         new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 5, 0));
    panel_table.add(lbl_fat,         new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 5, 0));
    panel_table.add(lbl_carb,        new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 5, 0));
    panel_table.add(lbl_calories,      new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 5, 0));
    panel_table.add(panel_milk,           new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 20, 18));
    panel_milk.add(lbl_milk, null);
    panel_milk.add(cb_milk, null);
    panel_table.add(lbl_milk_protein,      new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 10, 10));
    panel_table.add(lbl_milk_fat,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 10, 10));
    panel_table.add(lbl_milk_carb,     new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 10, 10));
    panel_table.add(lbl_milk_calories,     new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 10, 10));
    panel_table.add(lbl_vegetable,      new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(cb_vegetable_serving,       new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_vegetable_protein,       new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_vegetable_fat,     new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_vegetable_carb,     new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_vegetable_calories,     new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_fruit,        new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(cb_fruit_serving,       new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_fruit_protein,      new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_fruit_fat,     new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_fruit_carb,     new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_fruit_calories,     new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches,       new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches_serving,        new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches_protein,      new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches_fat,     new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches_carb,     new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_starches_calories,     new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(panel_meat,       new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 18));
    panel_meat.add(lbl_meat, null);
    panel_meat.add(cb_meat, null);
    panel_table.add(lbl_meat_serving,       new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_meat_protein,      new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_meat_fat,     new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_meat_carb,     new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_meat_calories,     new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil,        new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil_serving,       new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil_protein,      new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil_fat,     new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil_carb,     new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_oil_calories,     new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_total,                   new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 10));
    panel_table.add(lbl_total_protein,      new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_total_fat,     new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_total_carb,     new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_total_calories,     new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(cb_milk_serving,         new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_blank,     new GridBagConstraints(6, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_actual,     new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 10));
    panel_table.add(lbl_actual_protein,    new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_actual_fat,    new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_actual_carb,    new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_table.add(lbl_actual_calories,    new GridBagConstraints(5, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    panel_allocate.add(component1, null);
    panel_allocate.add(butt_start_over, null);
    panel_allocate.add(jLabel1, null);
    panel_allocate.add(txtArea_warm, null);
    panel_allocate.add(panel_table, null);
  }

//Add nutrient Panel
private void addNutrientPane(){
   InputNutrient in=new InputNutrient(this);
   JPanel nutrientPane=in.getPanel();
   nutrientPane.setBounds(new Rectangle(516, 33, 180, 158));
   panel_allocate.add(nutrientPane, null);

  }

//JComboBox(cb_milk_serving) initialization
private String[] milk_serving_list_init(){

   String list[]=new String[]{"1","2","3"};
   return list;

  }

//JComboBox(cb_milk) initialization
  private String[] milk_list_init(){

      String list[]=new String[]{"non-fat","low-fat","whole"};
     return list;

    }

//JComboBox(cb_meat) initialization
  private String[] meat_list_init(){
        String list[]=new String[]{"lean","medium","high-fat"};
        return list;
  }

 //JComboBox(cb_vegetable_serving) initialization
  private String[] vegetable_serving_list_init(){

   String list[]=new String[]{"2","3","4"};
   return list;

  }

  //JComboBox(cb_fruit_serving) initialization
  private String[] fruit_serving_list_init(){

  String list[]=new String[]{"2","3","4"};
  return list;

 }

 /**
  *Calculate and show food serving depend on personal nutrient need.
  * @see com.gotdns.jimula.EatHealthy.CalculateServing
  */
public void show_serving(){


   lbl_actual_protein.setText(String.valueOf(actual_protein));
   lbl_actual_fat.setText(String.valueOf(actual_fat));
   lbl_actual_carb.setText(String.valueOf(actual_carb));
   lbl_actual_calories.setText(String.valueOf(actual_calories));

   CalculateServing cs=new CalculateServing(milk_serving,milk_fat,vegetable_serving,
                                              fruit_serving,meat_fat,
                                              actual_protein,actual_fat,actual_carb);

   this.starches_serving=cs.getStarchesServing();
   this.meat_serving=cs.getMeatServing();
   this.oil_serving=cs.getOilServing();
   lbl_starches_serving.setText(String.valueOf(this.starches_serving));
   lbl_meat_serving.setText(String.valueOf(this.meat_serving));
   lbl_oil_serving.setText(String.valueOf(this.oil_serving));

   this.milk_protein=cs.getMilkProtein();
   this.int_milk_fat=cs.getMilkFat();
   this.milk_carb=cs.getMilkCarb();
   lbl_milk_protein.setText(String.valueOf(this.milk_protein));
   lbl_milk_fat.setText(String.valueOf(this.int_milk_fat));
   lbl_milk_carb.setText(String.valueOf(this.milk_carb));

   this.vegetable_protein=cs.getVegetableProtein();
   this.vegetable_carb=cs.getVegetableCarb();
   lbl_vegetable_protein.setText(String.valueOf(this.vegetable_protein));
   lbl_vegetable_carb.setText(String.valueOf(this.vegetable_carb));

   this.fruit_carb=cs.getFruitCarb();
   lbl_fruit_carb.setText(String.valueOf(this.fruit_carb));

   Starches star=new Starches();
   this.starches_protein=star.PROTEIN*this.starches_serving;
   this.starches_carb=star.CARB*this.starches_serving;
   this.starches_calories=star.CALORIES*this.starches_serving;
   lbl_starches_protein.setText(String.valueOf(this.starches_protein));
   lbl_starches_carb.setText(String.valueOf(this.starches_carb));
   lbl_starches_calories.setText(String.valueOf(this.starches_calories));

   Meat m=new Meat(this.meat_fat);
   this.meat_protein=m.PROTEIN*this.meat_serving;
   this.int_meat_fat=m.fat*this.meat_serving;
   this.meat_calories=m.calories*meat_serving;
   lbl_meat_protein.setText(String.valueOf(this.meat_protein));
   lbl_meat_fat.setText(String.valueOf(this.int_meat_fat));
   lbl_meat_calories.setText(String.valueOf(this.meat_calories));

   Oil o=new Oil();
   this.oil_fat=o.FAT*this.oil_serving;
   this.oil_calories=o.CALORIES*oil_serving;
   lbl_oil_fat.setText(String.valueOf(this.oil_fat));
   lbl_oil_calories.setText(String.valueOf(this.oil_calories));

   Milk mik=new Milk(this.milk_fat);
   this.milk_calories=mik.calories*milk_serving;
   lbl_milk_calories.setText(String.valueOf(this.milk_calories));

   Vegetable vege=new Vegetable();
   this.vegetable_calories=vege.calories*vegetable_serving;
   lbl_vegetable_calories.setText(String.valueOf(this.vegetable_calories));

   Fruit frt=new Fruit();
   this.fruit_calories=frt.CALORIES*fruit_serving;
   lbl_fruit_calories.setText(String.valueOf(this.fruit_calories));

   show_total();
   set_lbl_color();

 }//end show_serving()

//set lbl_total_calories color.
//If the calories is too heigh, then it will set red color.
//If the calories is too low, then it will set green color.
private void set_lbl_color(){

   float range=0;
   if(total_calories>actual_calories){
     range=total_calories-actual_calories;
     if(range>50){
       lbl_total_calories.setForeground(Color.RED);
       txtArea_warm.setVisible(true);
       txtArea_warm.setForeground(Color.RED);
     }else if(range<50){
       lbl_total_calories.setForeground(Color.BLUE);
       txtArea_warm.setVisible(false);
     }
   }else if(total_calories<actual_calories){
     range=actual_calories-total_calories;
     if(range>50){
       lbl_total_calories.setForeground(Color.GREEN);
     }else if(range<50){
       lbl_total_calories.setForeground(Color.BLUE);
       txtArea_warm.setVisible(false);
     }
   }
 }//end set_lbl_color

//show total nutrient contents and food serving
private void show_total(){
   this.total_protein=milk_protein+vegetable_protein+meat_protein+starches_protein;
   lbl_total_protein.setText(String.valueOf(this.total_protein));

   this.total_fat=int_milk_fat+int_meat_fat+oil_fat;
   lbl_total_fat.setText(String.valueOf(this.total_fat));

   this.total_carb=milk_carb+starches_carb+vegetable_carb+fruit_carb;
   lbl_total_carb.setText(String.valueOf(this.total_carb));

   this.total_calories=milk_calories+vegetable_calories+fruit_calories+
                  starches_calories+meat_calories+oil_calories;
   lbl_total_calories.setText(String.valueOf(this.total_calories));
 }//end show_total()


 /**
  * Which is evoked by MainFrame
  * @return panel_allocate a JPanel with panel_allocate
  */
public JPanel addPanel(){
    return panel_allocate;
  }

  void cb_milk_actionPerformed(ActionEvent e) {
    this.milk_fat=String.valueOf(cb_milk.getSelectedItem());
    show_serving();
  }

  void cb_meat_actionPerformed(ActionEvent e) {
    this.meat_fat=String.valueOf(cb_meat.getSelectedItem());
    show_serving();
  }

  void cb_milk_serving_actionPerformed(ActionEvent e) {
    this.milk_serving=Integer.parseInt(String.valueOf(cb_milk_serving.getSelectedItem()));
    show_serving();
  }

  void cb_vegetable_serving_actionPerformed(ActionEvent e) {
    this.vegetable_serving=Integer.parseInt(
        String.valueOf(cb_vegetable_serving.getSelectedItem()));
    show_serving();
  }

  void cb_fruit_serving_actionPerformed(ActionEvent e) {
    this.fruit_serving=Integer.parseInt(
        String.valueOf(cb_fruit_serving.getSelectedItem()));
    show_serving();
  }

  void butt_start_over_actionPerformed(ActionEvent e) {
    this.frame.calculate_nutrient_need();

  }




}

class ServingPanel_cb_milk_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_cb_milk_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_milk_actionPerformed(e);
  }
}

class ServingPanel_cb_meat_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_cb_meat_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_meat_actionPerformed(e);
  }
}

class ServingPanel_cb_milk_serving_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_cb_milk_serving_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_milk_serving_actionPerformed(e);
  }
}

class ServingPanel_cb_vegetable_serving_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_cb_vegetable_serving_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_vegetable_serving_actionPerformed(e);
  }
}

class ServingPanel_cb_fruit_serving_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_cb_fruit_serving_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_fruit_serving_actionPerformed(e);
  }
}

class ServingPanel_butt_start_over_actionAdapter implements java.awt.event.ActionListener {
  ServingPanel adaptee;

  ServingPanel_butt_start_over_actionAdapter(ServingPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_start_over_actionPerformed(e);
  }
}
