/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.contrib.nanoxml.XMLElement;
import com.l2fprod.gui.border.LineBorder;
import com.l2fprod.gui.plaf.skin.CompoundSkin;
import com.l2fprod.gui.plaf.skin.IncorrectVersionException;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinCheckBoxIcon;
import com.l2fprod.gui.plaf.skin.SkinTreeUI;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSkin;
import com.l2fprod.gui.plaf.skin.impl.kde.KdeSkin;
import com.l2fprod.util.StringUtils;
import com.l2fprod.util.ZipResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.JTextComponent;

public class SkinLookAndFeel
extends BasicLookAndFeel {
    public static final String VERSION = "1.2.3";
    static final String SKIN_KEY = new String("SkinLookAndFeel.Skin");
    static final String SKIN_LOADER_KEY = new String("SkinLookAndFeel.SkinLoader");
    private static /* synthetic */ Class array$Ljava$lang$Object;
    private static /* synthetic */ Class class$Lcom$l2fprod$gui$plaf$skin$SkinLookAndFeel;

    public String getName() {
        return "SkinLF";
    }

    public String getDescription() {
        return "Skin Look and Feel";
    }

    public String getID() {
        return "SkinLF";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String skinPackageName = "com.l2fprod.gui.plaf.skin.";
        Vector<Object> list = new Vector<Object>();
        if (SkinLookAndFeel.getSkin().getProgress() != null && SkinLookAndFeel.getSkin().getProgress().status()) {
            list.addElement("ProgressBarUI");
            list.addElement(skinPackageName + "SkinProgressBarUI");
        }
        if (SkinLookAndFeel.getSkin().getTab() != null && SkinLookAndFeel.getSkin().getTab().status()) {
            list.addElement("TabbedPaneUI");
            list.addElement(skinPackageName + "SkinTabbedPaneUI");
        }
        if (SkinLookAndFeel.getSkin().getFrame() != null && SkinLookAndFeel.getSkin().getFrame().status()) {
            list.addElement("InternalFrameUI");
            list.addElement(skinPackageName + "SkinInternalFrameUI");
            list.addElement("WindowButtonUI");
            list.addElement(skinPackageName + "SkinWindowButtonUI");
        }
        if (SkinLookAndFeel.getSkin().getSlider() != null && SkinLookAndFeel.getSkin().getSlider().status()) {
            list.addElement("SliderUI");
            list.addElement(skinPackageName + "SkinSliderUI");
        }
        if (SkinLookAndFeel.getSkin().getScrollbar() != null && SkinLookAndFeel.getSkin().getScrollbar().status()) {
            list.addElement("ScrollBarUI");
            list.addElement(skinPackageName + "SkinScrollBarUI");
        }
        if (SkinLookAndFeel.getSkin().getButton() != null && SkinLookAndFeel.getSkin().getButton().status()) {
            list.addElement("ButtonUI");
            list.addElement(skinPackageName + "SkinButtonUI");
            list.addElement("ToggleButtonUI");
            list.addElement(skinPackageName + "SkinToggleButtonUI");
        }
        if (SkinLookAndFeel.getSkin().getSeparator() != null && SkinLookAndFeel.getSkin().getSeparator().status()) {
            list.addElement("SeparatorUI");
            list.addElement(skinPackageName + "SkinSeparatorUI");
        }
        Object[] uiDefaults = new Object[]{"CheckBoxUI", skinPackageName + "SkinCheckBoxUI", "ComboBoxUI", skinPackageName + "SkinComboBoxUI", "CheckBoxMenuItemUI", skinPackageName + "SkinCheckBoxMenuItemUI", "MenuItemUI", skinPackageName + "SkinMenuItemUI", "MenuUI", skinPackageName + "SkinMenuUI", "MenuBarUI", skinPackageName + "SkinMenuBarUI", "ToolBarUI", skinPackageName + "SkinToolBarUI", "PopupMenuUI", skinPackageName + "SkinPopupMenuUI", "RadioButtonUI", skinPackageName + "SkinRadioButtonUI", "RadioButtonMenuItemUI", skinPackageName + "SkinRadioButtonMenuItemUI", "PanelUI", skinPackageName + "SkinPanelUI", "DesktopPaneUI", skinPackageName + "SkinDesktopPaneUI", "DesktopIconUI", skinPackageName + "SkinDesktopIconUI", "TableHeaderUI", skinPackageName + "SkinTableHeaderUI", "FileChooserUI", skinPackageName + "SkinFileChooserUI", "TextFieldUI", "javax.swing.plaf.metal.MetalTextFieldUI", "SplitPaneUI", Boolean.TRUE.equals(UIManager.get("JSplitPane.alternateUI")) ? skinPackageName + "SkinSplitPaneUI" : "javax.swing.plaf.basic.BasicSplitPaneUI", "TreeUI", skinPackageName + "SkinTreeUI"};
        int i = 0;
        while (i < uiDefaults.length) {
            list.addElement(uiDefaults[i]);
            ++i;
        }
        int i2 = 0;
        int c = list.size();
        while (i2 < c) {
            try {
                String current = (String)list.elementAt(i2);
                if (current.startsWith(skinPackageName)) {
                    Class.forName(current);
                    list.addElement(current);
                    list.addElement(Class.forName(current));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i2;
        }
        Object current = null;
        Object[] results = new Object[list.size()];
        list.copyInto(results);
        table.putDefaults(results);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        String[] skinColors = SkinLookAndFeel.getSkin().getColors();
        if (skinColors != null) {
            this.loadSystemColors(table, skinColors, this.isNativeLookAndFeel());
        } else {
            this.loadSystemColors(table, new String[0], this.isNativeLookAndFeel());
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        this.loadResourceBundle(table);
        Icon treeExpandedIcon = SkinTreeUI.ExpandedIcon.createExpandedIcon();
        Icon treeCollapsedIcon = SkinTreeUI.CollapsedIcon.createCollapsedIcon();
        SkinCheckBoxIcon checkIcon = new SkinCheckBoxIcon();
        Object[] defaults = new Object[]{"Button.dashedRectGapX", new Integer(5), "Button.dashedRectGapY", new Integer(4), "Button.dashedRectGapWidth", new Integer(10), "Button.dashedRectGapHeight", new Integer(8), "Button.textShiftOffset", new Integer(1), "Desktop.background", table.get("desktop"), "ToggleButton.textShiftOffset", new Integer(1), "CheckBoxMenuItem.checkIcon", checkIcon, "RadioButtonMenuItem.checkIcon", checkIcon, "SplitPane.dividerSize", new Integer(4), "SplitPane.background", table.get("control"), "ProgressBar.cellLength", new Integer(7), "ProgressBar.cellSpacing", new Integer(2), "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.line", Color.black, "Tree.hash", Color.black, "Tree.rowHeight", new Integer(0), "Tree.textForeground", table.get("textText"), "Tree.textBackground", table.get("window"), "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "InternalFrame.minimizeIconBackground", table.get("control"), "InternalFrame.resizeIconHighlight", table.get("controlHighlight"), "InternalFrame.resizeIconShadow", table.get("controlShadow")};
        table.putDefaults(defaults);
        try {
            Class.forName("javax.swing.InputMap");
            Class<?> uidefaults = Class.forName("javax.swing.UIDefaults");
            Class<?>[] innerClasses = uidefaults.getClasses();
            Constructor<?> c = null;
            int i = 0;
            while (i < innerClasses.length) {
                if (innerClasses[i].getName().endsWith("LazyInputMap")) {
                    c = innerClasses[i].getConstructor(array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = SkinLookAndFeel.class$("[Ljava.lang.Object;")));
                    break;
                }
                ++i;
            }
            Object[] fieldInputMap = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"};
            Object[] multilineInputMap = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"};
            table.put("TextField.focusInputMap", c.newInstance(new Object[]{fieldInputMap}));
            table.put("PasswordField.focusInputMap", c.newInstance(new Object[]{fieldInputMap}));
            table.put("TextArea.focusInputMap", c.newInstance(new Object[]{multilineInputMap}));
            table.put("TextPane.focusInputMap", c.newInstance(new Object[]{multilineInputMap}));
            table.put("EditorPane.focusInputMap", c.newInstance(new Object[]{multilineInputMap}));
        }
        catch (Throwable e) {
            JTextComponent.KeyBinding[] fieldBindings = LookAndFeel.makeKeyBindings(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
            JTextComponent.KeyBinding[] multilineBindings = LookAndFeel.makeKeyBindings(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "control shift PAGE_UP", "selection-page-left", "control shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
            table.put("TextField.keyBindings", fieldBindings);
            table.put("PasswordField.keyBindings", fieldBindings);
            table.put("TextArea.keyBindings", multilineBindings);
            table.put("TextPane.keyBindings", multilineBindings);
            table.put("EditorPane.keyBindings", multilineBindings);
        }
    }

    private final void loadResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.l2fprod.gui.plaf.skin.resources.skin");
        Enumeration<String> iter = bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    public static void setSkin(Skin skin) {
        UIManager.put(SKIN_KEY, skin);
    }

    public static Skin getSkin() {
        Skin s = (Skin)UIManager.get(SKIN_KEY);
        if (s == null) {
            try {
                String themepack = System.getProperty("skinlf.themepack");
                s = themepack != null ? SkinLookAndFeel.loadThemePack(themepack) : SkinLookAndFeel.loadThemePack(System.getProperty("user.home") + File.separator + ".skinlf" + File.separator + "themepack.zip");
                SkinLookAndFeel.setSkin(s);
            }
            catch (Throwable th) {
                throw new Error("Skin was null and an error occurs while trying to load the user theme pack <user.home>/.skinlf/themepack.zip. Source exception message is " + th.getMessage());
            }
        }
        return s;
    }

    public static void enable() throws UnsupportedLookAndFeelException {
        SkinLookAndFeel lnf = new SkinLookAndFeel();
        UIManager.setLookAndFeel(lnf);
        UIManager.getLookAndFeelDefaults().put("ClassLoader", lnf.getClass().getClassLoader());
    }

    public static Skin loadSkin(String filename) throws Exception {
        return SkinLookAndFeel.loadSkin(SkinUtils.toURL(new File(filename)));
    }

    public static Skin loadSkin(URL url) throws Exception {
        String filename = url.getFile();
        if (filename.endsWith("gtkrc")) {
            return new GtkSkin(url, SkinLookAndFeel.getInputStream(url));
        }
        if (filename.endsWith(".themerc")) {
            return new KdeSkin(url, SkinLookAndFeel.getInputStream(url));
        }
        throw new Exception("Unable to load this skin " + url + " (by using filename matching), " + " try an explicit constructor");
    }

    public static Skin loadDefaultThemePack() throws Exception {
        return SkinLookAndFeel.loadThemePackDefinition((class$Lcom$l2fprod$gui$plaf$skin$SkinLookAndFeel != null ? class$Lcom$l2fprod$gui$plaf$skin$SkinLookAndFeel : (class$Lcom$l2fprod$gui$plaf$skin$SkinLookAndFeel = SkinLookAndFeel.class$("com.l2fprod.gui.plaf.skin.SkinLookAndFeel"))).getResource("/skinlf-themepack.xml"));
    }

    public static Skin loadThemePack(String filename) throws Exception {
        if (filename.startsWith("http://") || filename.startsWith("ftp://") || filename.startsWith("file:/") || filename.startsWith("jar:/")) {
            return SkinLookAndFeel.loadThemePack(new URL(filename));
        }
        return SkinLookAndFeel.loadThemePack(SkinUtils.toURL(new File(filename)));
    }

    public static Skin loadThemePack(URL url) throws Exception {
        ZipResourceLoader loader = new ZipResourceLoader(url);
        UIManager.put(SKIN_LOADER_KEY, loader);
        Skin skin = SkinLookAndFeel.loadThemePackDefinition(new URL("http://dummyhostforziploader/skinlf-themepack.xml"));
        UIManager.put(SKIN_LOADER_KEY, null);
        return skin;
    }

    public static Skin loadThemePackDefinition(URL url) throws Exception {
        Skin skin = null;
        XMLElement element = new XMLElement();
        element.parseFromReader(new InputStreamReader(SkinLookAndFeel.getInputStream(url)));
        SkinLookAndFeel.checkRequiredVersion(element.getProperty("REQUIRE"));
        UIManager.put("JDesktopPane.backgroundEnabled", Boolean.FALSE);
        UIManager.put("PopupMenu.animation", Boolean.FALSE);
        UIManager.put("ScrollBar.alternateLayout", Boolean.FALSE);
        UIManager.put("JSplitPane.alternateUI", Boolean.FALSE);
        Enumeration enumeration = element.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            element = (XMLElement)enumeration.nextElement();
            String tagName = element.getTagName().toLowerCase();
            if ("skin".equals(tagName)) {
                skin = SkinLookAndFeel.buildSkin(url, element);
                continue;
            }
            if ("property".equals(tagName)) {
                String type = element.getProperty("TYPE");
                if (type == null || "".equals(type) || "boolean".equalsIgnoreCase(type) || "java.lang.Boolean".equalsIgnoreCase(type)) {
                    UIManager.put(element.getProperty("NAME"), Boolean.valueOf(element.getProperty("VALUE")));
                    continue;
                }
                if ("int".equalsIgnoreCase(type) || "java.lang.Integer".equalsIgnoreCase(type)) {
                    UIManager.put(element.getProperty("NAME"), Integer.valueOf(element.getProperty("VALUE")));
                    continue;
                }
                if ("String".equalsIgnoreCase(type) || "java.lang.String".equalsIgnoreCase(type)) {
                    UIManager.put(element.getProperty("NAME"), element.getProperty("VALUE"));
                    continue;
                }
                if ("Color".equalsIgnoreCase(type) || "java.awt.Color".equalsIgnoreCase(type)) {
                    Color color = Color.decode(element.getProperty("VALUE"));
                    UIManager.put(element.getProperty("NAME"), color);
                    continue;
                }
                if ("Insets".equalsIgnoreCase(type) || "java.awt.Insets".equalsIgnoreCase(type)) {
                    Insets insets = SkinLookAndFeel.parseInsets(element.getProperty("VALUE"));
                    UIManager.put(element.getProperty("NAME"), insets);
                    continue;
                }
                if ("Dimension".equalsIgnoreCase(type) || "java.awt.Dimension".equalsIgnoreCase(type)) {
                    Dimension dim = SkinLookAndFeel.parseDimension(element.getProperty("VALUE"));
                    UIManager.put(element.getProperty("NAME"), dim);
                    continue;
                }
                if ("LineBorder".equalsIgnoreCase(type) || "javax.swing.border.LineBorder".equalsIgnoreCase(type)) {
                    boolean rounded = false;
                    Color color = Color.black;
                    int thickness = 1;
                    String temp = element.getProperty("ROUNDED");
                    if (temp != null) {
                        rounded = Boolean.getBoolean(temp);
                    }
                    if ((temp = element.getProperty("THICKNESS")) != null) {
                        thickness = Integer.parseInt(temp);
                    }
                    if ((temp = element.getProperty("COLOR")) != null) {
                        color = Color.decode(temp);
                    }
                    LineBorder border = new LineBorder(color, thickness, rounded);
                    UIManager.put(element.getProperty("NAME"), border);
                    continue;
                }
                if (!"EmptyBorder".equalsIgnoreCase(type) && !"javax.swing.border.EmptyBorder".equalsIgnoreCase(type)) continue;
                Insets insets = SkinLookAndFeel.parseInsets(element.getProperty("VALUE"));
                EmptyBorder border = new EmptyBorder(insets);
                UIManager.put(element.getProperty("NAME"), border);
                continue;
            }
            if ("font".equalsIgnoreCase(tagName)) {
                String[] fontStyle = StringUtils.splitString(element.getProperty("VALUE"), ",");
                Font f = SkinUtils.getFont(fontStyle[0], Integer.parseInt(fontStyle[1]), Integer.parseInt(fontStyle[2]));
                if (f == null) continue;
                if ("Global".equalsIgnoreCase(element.getProperty("NAME"))) {
                    SkinUtils.setFont(new FontUIResource(f));
                    continue;
                }
                UIManager.put(element.getProperty("NAME"), new FontUIResource(f));
                continue;
            }
            if (!"icon".equalsIgnoreCase(tagName)) continue;
            URL iconURL = new URL(url, element.getProperty("VALUE"));
            ImageIcon icon = new ImageIcon(SkinUtils.loadImage(iconURL));
            UIManager.put(element.getProperty("NAME"), new IconUIResource(icon));
            if (!"InternalFrame.icon".equals(element.getProperty("NAME"))) continue;
            JOptionPane.getRootFrame().setIconImage(icon.getImage());
        }
        return skin;
    }

    public static void checkRequiredVersion(String required) throws Exception {
        if (required == null || "".equals(required)) {
            return;
        }
        SkinLookAndFeel.checkRequiredVersion(VERSION, required);
    }

    static InputStream getInputStream(URL url) throws Exception {
        ZipResourceLoader loader = (ZipResourceLoader)UIManager.get(SKIN_LOADER_KEY);
        if (loader != null) {
            return loader.getZipResource(url).getInputStream();
        }
        return url.openStream();
    }

    /*
     * WARNING - void declaration
     */
    static byte[] getURLContent(URL url) throws Exception {
        ZipResourceLoader loader = (ZipResourceLoader)UIManager.get(SKIN_LOADER_KEY);
        if (loader == null) {
            int read;
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((read = input.read()) != -1) {
                void var4_4;
                output.write((int)var4_4);
            }
            return output.toByteArray();
        }
        return loader.getZipResource(url).getURLContent();
    }

    private static final Dimension parseDimension(String str) {
        int[] dim = new int[2];
        Arrays.fill(dim, 0);
        String[] dimStrings = StringUtils.splitString(str, "{,}");
        int i = 0;
        while (i < 4) {
            dim[i] = Integer.parseInt(dimStrings[i]);
            ++i;
        }
        return new Dimension(dim[0], dim[1]);
    }

    private static final Insets parseInsets(String str) {
        int[] insets = new int[4];
        Arrays.fill(insets, 0);
        String[] insetsString = StringUtils.splitString(str, "{,}");
        int i = 0;
        while (i < 4) {
            insets[i] = Integer.parseInt(insetsString[i]);
            ++i;
        }
        return new Insets(insets[0], insets[1], insets[2], insets[3]);
    }

    private static final void checkRequiredVersion(String current, String required) throws Exception {
        StringTokenizer currentToken = new StringTokenizer(current, ".");
        StringTokenizer requiredToken = new StringTokenizer(required, ".");
        int currentCount = currentToken.countTokens();
        int requiredCount = requiredToken.countTokens();
        int min = Math.min(currentCount, requiredCount);
        int i = 0;
        while (i < min) {
            String rTok;
            String cTok = currentToken.nextToken();
            if (cTok.compareTo(rTok = requiredToken.nextToken()) > 0) break;
            if (cTok.compareTo(rTok) < 0) {
                throw new IncorrectVersionException(required, current);
            }
            if (i == min - 1 && currentCount < requiredCount) {
                throw new IncorrectVersionException(required, current);
            }
            ++i;
        }
    }

    private static final Skin buildSkin(URL context, XMLElement element) throws Exception {
        Skin result = null;
        if (element.countChildren() == 0) {
            result = SkinLookAndFeel.loadSkin(new URL(context, element.getProperty("URL")));
        } else if (element.countChildren() == 2) {
            result = new CompoundSkin(SkinLookAndFeel.buildSkin(context, (XMLElement)element.getChildren().elementAt(0)), SkinLookAndFeel.buildSkin(context, (XMLElement)element.getChildren().elementAt(1)));
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

