/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class SkinBorder
implements Border {
    final ImageIcon top;
    final ImageIcon bottom;
    final ImageIcon left;
    final ImageIcon right;
    final ImageIcon topleft;
    final ImageIcon topright;
    final ImageIcon bottomleft;
    final ImageIcon bottomright;
    final Insets insets;

    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.topleft.paintIcon(c, g, x, y);
        this.topright.paintIcon(c, g, x + width - this.topright.getIconWidth(), y);
        this.bottomleft.paintIcon(c, g, x, y + height - this.bottomleft.getIconHeight());
        this.bottomright.paintIcon(c, g, x + width - this.bottomright.getIconWidth(), y + height - this.bottomright.getIconWidth());
        ImageUtils.paint(c, g, this.left.getImage(), x, y + this.topleft.getIconHeight(), this.left.getIconWidth(), height - this.topleft.getIconHeight() - this.bottomleft.getIconHeight(), false, 2);
        ImageUtils.paint(c, g, this.right.getImage(), x + width - this.right.getIconWidth(), y + this.topleft.getIconHeight(), this.right.getIconWidth(), height - this.topright.getIconHeight() - this.bottomright.getIconHeight(), false, 2);
        ImageUtils.paint(c, g, this.top.getImage(), x + this.topleft.getIconWidth(), y, width - this.topleft.getIconWidth() - this.topright.getIconWidth(), this.top.getIconHeight(), false, 2);
        ImageUtils.paint(c, g, this.bottom.getImage(), x + this.bottomleft.getIconWidth(), y + height - this.bottom.getIconHeight(), width - this.bottomleft.getIconWidth() - this.bottomright.getIconWidth(), this.bottom.getIconHeight(), false, 2);
    }

    public static ImageIcon getIcon(URL skinURL, String path) throws Exception {
        if (path != null && path.length() > 0) {
            return new ImageIcon(SkinUtils.loadImage(new URL(skinURL, path)));
        }
        return new ImageIcon(){

            public final int getIconHeight() {
                return 0;
            }

            public final int getIconWidth() {
                return 0;
            }

            public final void paintIcon(Component c, Graphics g, int x, int y) {
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public SkinBorder(ImageIcon top, ImageIcon bottom, ImageIcon left, ImageIcon right, ImageIcon topleft, ImageIcon topright, ImageIcon bottomleft, ImageIcon bottomright) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.topleft = topleft;
        this.topright = topright;
        this.bottomleft = bottomleft;
        this.bottomright = bottomright;
        this.insets = new Insets(top.getIconHeight(), right.getIconWidth(), bottom.getIconHeight(), left.getIconWidth());
    }
}

