/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.FastMenu;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.ThumbnailsOptionsTab;
import rogatkin.BaseController;
import rogatkin.Serializer;

public class ThumbnailsPanel
extends JPanel {
    public static final int THUMB_SIZE_X = 162;
    public static final int THUMB_SIZE_Y = 142;
    static final int THUMBS_IN_ROW = 5;
    private int labelTextHeight = 16;
    Dimension preferredsize = new Dimension(0, 160);
    Controller controller;
    private Thumbnail current_thumb;
    protected PhotoCollectionPanel collectionpanel;
    protected AlbumPane albumpanel;
    protected PhotoImagePanel imagepanel;
    private int v;
    private int h;
    private int sx;
    private int sy;
    private Border reg_border;
    private Border selected_border;

    public ThumbnailsPanel(Controller controller) {
        this.controller = controller;
        this.collectionpanel = (PhotoCollectionPanel)controller.component(Controller.COMP_COLLECTION);
        this.albumpanel = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
        this.setImageView();
        this.imagepanel.setThumbnailsPanel(this);
    }

    void setImageView() {
        this.imagepanel = (PhotoImagePanel)this.controller.component(Controller.COMP_IMAGEPANEL);
    }

    void calculateLayout() {
        Serializer serializer = this.controller.getSerializer();
        this.reg_border = ThumbnailsOptionsTab.createBorder((String)serializer.getProperty("ThumbnailsOptions", "Border"));
        this.selected_border = ThumbnailsOptionsTab.createBorder((String)serializer.getProperty("ThumbnailsOptions", "SelectedBorder"));
        Integer n = (Integer)serializer.getProperty("ThumbnailsOptions", "Vertical");
        this.v = 5;
        this.h = 0;
        if (n != null && n == 0) {
            n = (Integer)serializer.getProperty("ThumbnailsOptions", "FixedNumber");
            if (n != null) {
                this.v = 0;
                this.h = n;
            }
        } else {
            n = (Integer)serializer.getProperty("ThumbnailsOptions", "FixedNumber");
            if (n != null) {
                this.h = 0;
                this.v = n;
            }
        }
        this.sx = 162;
        this.sy = 142;
        n = (Integer)serializer.getProperty("ThumbnailsOptions", "CellWidth");
        if (n != null) {
            this.sx = n;
        } else {
            serializer.setProperty("ThumbnailsOptions", "CellWidth", new Integer(this.sx));
        }
        n = (Integer)serializer.getProperty("ThumbnailsOptions", "CellHeight");
        if (n != null) {
            this.sy = n;
        } else {
            serializer.setProperty("ThumbnailsOptions", "CellHeight", new Integer(this.sy));
        }
        this.setLayout(new GridLayout(this.h, this.v));
    }

    public Component createThumbnail(BasicJpeg basicJpeg) {
        return new ThumbnailComponent(basicJpeg);
    }

    public Dimension getPreferredSize() {
        return this.preferredsize;
    }

    public void updateImages(File file) {
        this.updateImages(new File[]{file});
    }

    public boolean updateImages(File[] fileArray) {
        this.removeAll();
        this.calculateLayout();
        boolean bl = false;
        int n = 0;
        while (n < fileArray.length) {
            BasicJpeg basicJpeg;
            if (BaseController.isLowMemory()) {
                JOptionPane.showMessageDialog(this, "The system runs on very low free memory, the current operation will be terminated.", "Error", 0);
                break;
            }
            if (fileArray[n].isFile()) {
                basicJpeg = new BasicJpeg(fileArray[n]);
                if (basicJpeg.isValid()) {
                    this.add(this.createThumbnail(basicJpeg));
                    bl = true;
                }
            } else if (fileArray[n].isDirectory()) {
                String[] stringArray = fileArray[n].list();
                String string = fileArray[n].getPath();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (BaseController.isLowMemory()) {
                        JOptionPane.showMessageDialog(this, "The system runs on very low free memory, the current operation will be terminated.", "Error", 0);
                        break;
                    }
                    basicJpeg = new BasicJpeg(new File(string, stringArray[n2]));
                    if (basicJpeg.isValid()) {
                        this.add(this.createThumbnail(basicJpeg));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.adjustDimension();
        return bl;
    }

    public void addImage(File file) {
        this.calculateLayout();
        BasicJpeg basicJpeg = new BasicJpeg(file);
        if (basicJpeg.isValid()) {
            this.add(this.createThumbnail(basicJpeg));
        }
        this.adjustDimension();
    }

    void adjustDimension() {
        this.preferredsize = this.v != 0 ? new Dimension(this.v * this.sx, (this.getComponentCount() / this.v + 1) * this.sy) : new Dimension((this.getComponentCount() / this.h + 1) * this.sx, this.h * this.sy);
        this.setSize(this.preferredsize);
        this.revalidate();
        this.repaint();
    }

    JPopupMenu getRightButtonMenu(ActionListener actionListener, boolean bl) {
        return new FastMenu(actionListener, this.controller);
    }

    void doSpecificAction(BasicJpeg basicJpeg, ActionEvent actionEvent, Thumbnail thumbnail) {
        String string = actionEvent.getActionCommand();
        if (string.equals("To selection")) {
            this.collectionpanel.add(new File(basicJpeg.getLocationName()));
        } else if (string.equals("To album")) {
            AlbumSelectionDialog albumSelectionDialog = this.albumpanel.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + basicJpeg);
            ((Component)albumSelectionDialog).setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                this.albumpanel.addToAlbum(new BasicJpeg[]{basicJpeg}, treePathArray);
                Serializer serializer = this.controller.getSerializer();
                if (Serializer.getInt(serializer.getProperty("AlbumOptions", "MoveToAlbum"), 0) == 1 && Serializer.getInt(serializer.getProperty("AlbumOptions", "AlbumFolders"), 0) == 1) {
                    // empty if block
                }
            }
        } else if (string.equals("Show")) {
            this.showFullImage(basicJpeg, thumbnail);
        } else if (string.equals("Rename")) {
            Serializer serializer = this.controller.getSerializer();
            boolean bl = false;
            if (basicJpeg.isValid() && Serializer.getInt(serializer.getProperty("RenameOptions", "AskEdit"), 0) == 0) {
                bl = basicJpeg.renameTo(new File(basicJpeg.getParentPath(), FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(basicJpeg, this.controller))));
            } else {
                String string2 = basicJpeg.isValid() ? basicJpeg.getParentPath() + File.separatorChar + FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(basicJpeg, this.controller)) : basicJpeg.getLocationName();
                if ((string2 = (String)JOptionPane.showInputDialog(this, "New name", "Rename", 3, null, null, string2)) != null) {
                    bl = basicJpeg.renameTo(new File(string2.toString()));
                }
            }
            if (bl) {
                thumbnail.update();
            }
        } else if (string.equals("Delete")) {
            Serializer serializer = this.controller.getSerializer();
            if (Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "ShowWarnDlg"), 0) == 1 && JOptionPane.showConfirmDialog(this, "Confirm deleting " + basicJpeg.getLocationName(), "Confirmation...", 2) != 0) {
                return;
            }
            File file = new File(basicJpeg.getLocationName());
            if (file.delete()) {
                this.remove((Component)((Object)thumbnail));
                this.adjustDimension();
            }
        } else if (string.equals("Print")) {
            this.controller.print(new File[]{new File(basicJpeg.getLocationName())});
        }
    }

    public String getImageTitle(BasicJpeg basicJpeg, boolean bl) {
        boolean bl2;
        String string = null;
        boolean bl3 = bl2 = Serializer.getInt(this.controller.getSerializer().getProperty("ThumbnailsOptions", "ShowComment"), 0) == 1;
        if (bl2) {
            string = basicJpeg.getComment();
        }
        if (string == null || string.length() == 0) {
            string = (String)this.controller.getSerializer().getProperty("ThumbnailsOptions", "LabelMask");
        }
        AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
        if (bl) {
            if (string != null) {
                return new FileNameFormat(string).format(basicJpeg);
            }
            if (abstractImageInfo != null) {
                return "" + abstractImageInfo.getDateTimeOriginal();
            }
        } else if (abstractImageInfo != null) {
            return "No thumbnail for " + basicJpeg.getImageInfo().getMake();
        }
        return "No thumbnail for " + basicJpeg.getLocationName();
    }

    void showFullImage(BasicJpeg basicJpeg, Thumbnail thumbnail) {
        this.imagepanel.updateView(basicJpeg);
        this.controller.updateCaption(basicJpeg.getLocationName());
        this.setCurrent(thumbnail);
    }

    public void setCurrent(Thumbnail thumbnail) {
        this.current_thumb = thumbnail;
    }

    public void showNext() {
        int n = 0;
        while (n < this.getComponentCount() - 1) {
            if (this.current_thumb == this.getComponent(n)) {
                Thumbnail thumbnail = (Thumbnail)((Object)this.getComponent(n + 1));
                this.doSpecificAction(thumbnail.getImageInfo(), new ActionEvent(thumbnail, 0, "Show"), thumbnail);
                break;
            }
            ++n;
        }
    }

    public void showPrev() {
        int n = this.getComponentCount() - 1;
        while (n > 0) {
            if (this.current_thumb == this.getComponent(n)) {
                Thumbnail thumbnail = (Thumbnail)((Object)this.getComponent(n - 1));
                this.doSpecificAction(thumbnail.getImageInfo(), new ActionEvent(thumbnail, 0, "Show"), thumbnail);
                break;
            }
            --n;
        }
    }

    class ThumbnailComponent
    extends JLabel
    implements ActionListener,
    Thumbnail {
        Dimension preferredsize;
        Dimension thumbnailSize;
        private BasicJpeg format;

        public ThumbnailComponent() {
            super(new ImageIcon());
            this.preferredsize = new Dimension(ThumbnailsPanel.this.sx, ThumbnailsPanel.this.sy);
            this.thumbnailSize = new Dimension(this.preferredsize.width - 4, this.preferredsize.height - 4 - ThumbnailsPanel.this.labelTextHeight);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ ThumbnailComponent this$1;
                {
                    this.this$1 = thumbnailComponent;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if (mouseEvent.getClickCount() == 2 && (n & 0x10) > 0) {
                        ThumbnailComponent.access$400(this.this$1).doSpecificAction(ThumbnailComponent.access$300(this.this$1), new ActionEvent(this.this$1, 0, "Show"), this.this$1);
                    } else if ((n & 4) > 0) {
                        ThumbnailComponent.access$400(this.this$1).getRightButtonMenu(this.this$1, mouseEvent.isControlDown()).show(this.this$1, mouseEvent.getX(), ThumbnailComponent.access$400((ThumbnailComponent)this.this$1).controller.adjustMenuY(this.this$1.getLocationOnScreen().y + mouseEvent.getY(), 200) - this.this$1.getLocationOnScreen().y);
                    }
                }
            });
            this.setBorder(ThumbnailsPanel.this.reg_border);
        }

        public Dimension getPreferredSize() {
            return this.preferredsize;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Properties...")) {
                PropertiesPanel.showProperties(this.format, ThumbnailsPanel.this.controller);
            } else {
                ThumbnailsPanel.this.doSpecificAction(this.format, actionEvent, this);
            }
        }

        public ThumbnailComponent(BasicJpeg basicJpeg) {
            this();
            this.updateImage(basicJpeg);
        }

        void updateImage(BasicJpeg basicJpeg) {
            this.format = basicJpeg;
            String string = Serializer.arrayToString(ThumbnailsPanel.this.controller.getSerializer().getProperty("ThumbnailsOptions", "ToolTipMask"));
            Icon icon = null;
            if (basicJpeg.getImageInfo() != null) {
                icon = basicJpeg.getImageInfo().getThumbnailIcon(basicJpeg, this.thumbnailSize);
            }
            if (string != null) {
                this.setToolTipText(new FileNameFormat(string).format(basicJpeg));
            } else {
                this.setToolTipText(basicJpeg.getImageInfo().getReport());
            }
            if (icon != null) {
                this.setIcon(icon);
                this.setText(ThumbnailsPanel.this.getImageTitle(basicJpeg, true));
            } else {
                this.setText(ThumbnailsPanel.this.getImageTitle(basicJpeg, false));
            }
        }

        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public BasicJpeg getImageInfo() {
            return this.format;
        }

        public void select(boolean bl) {
            this.setBorder(bl ? ThumbnailsPanel.this.selected_border : ThumbnailsPanel.this.reg_border);
        }

        public void update() {
            this.updateImage(this.format);
        }

        public String toString() {
            return new File(this.format.getLocationName()).getName();
        }

        static /* synthetic */ BasicJpeg access$300(ThumbnailComponent thumbnailComponent) {
            return thumbnailComponent.format;
        }

        static /* synthetic */ ThumbnailsPanel access$400(ThumbnailComponent thumbnailComponent) {
            return thumbnailComponent.ThumbnailsPanel.this;
        }
    }
}

