/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.jai;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;
import photoorganizer.formats.AdvancedImage;
import photoorganizer.jai.IconJAI;

public class AdvancedImageImpl
implements AdvancedImage {
    public AdvancedImageImpl() {
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0L);
    }

    public PlanarImage getImage(String string) {
        if (System.getProperty("JAI_IMAGE_READER_USE_CODECS") == null) {
            try {
                return JAI.create((String)"fileload", (Object)string);
            }
            catch (Exception exception) {
                this.reportError(exception, "getImage");
            }
        } else {
            try {
                FileSeekableStream fileSeekableStream = new FileSeekableStream(string);
                String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)fileSeekableStream);
                ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)stringArray[0], (SeekableStream)fileSeekableStream, null);
                RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage();
                fileSeekableStream.close();
                return PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
            }
            catch (Exception exception) {
                this.reportError(exception, "getImage");
            }
        }
        return null;
    }

    public boolean isValid(String string) {
        try {
            FileSeekableStream fileSeekableStream = new FileSeekableStream(string);
            String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)fileSeekableStream);
            fileSeekableStream.close();
            return stringArray != null && stringArray.length > 0;
        }
        catch (Throwable throwable) {
            this.reportError(throwable, "isValid");
            return false;
        }
    }

    protected void reportError(Throwable throwable, String string) {
        System.err.println("JAI extension(" + string + "): " + throwable);
    }

    public Icon createIcon(String string) {
        return new IconJAI((RenderedImage)this.getImage(string));
    }

    public Icon createThumbnailIcon(String string, Dimension dimension) {
        return new IconJAI(IconJAI.createThumbnailImage((RenderedImage)this.getImage(string), dimension));
    }

    public void saveThumbnailImage(String string, OutputStream outputStream, Dimension dimension) throws IOException {
        if (outputStream != null) {
            PlanarImage planarImage = (PlanarImage)IconJAI.createThumbnailImage((RenderedImage)this.getImage(string), dimension);
            JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
            jPEGEncodeParam.setQuality(0.75f);
            jPEGEncodeParam.setWriteJFIFHeader(false);
            try {
                ImageCodec.createImageEncoder((String)"JPEG", (OutputStream)outputStream, (ImageEncodeParam)jPEGEncodeParam).encode((RenderedImage)planarImage);
            }
            catch (Exception exception) {
                this.reportError(exception, "saveThumbnailImage");
            }
            outputStream.close();
        }
    }
}

