/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import photoorganizer.ftp.ConnectThread;
import photoorganizer.ftp.FtpCommandReply;
import photoorganizer.ftp.FtpConnectionInfo;

public class Ftp {
    public static final int DATA_PORT = 20;
    public static final int CONTROL_PORT = 21;
    public static final int BLOCK_SIZE = 8192;
    public static final int POSITIVE_PRELIMINARY_REPLY = 1;
    public static final int POSITIVE_COMPLETION_REPLY = 2;
    public static final int POSITIVE_INTERMEDIATE_REPLY = 3;
    public static final int TRANSIENT_NEGATIVE_REPLY = 4;
    public static final int PERMANENT_NEGATIVE_REPLY = 5;
    static final int NOOP_INTERVAL = 300000;
    public static final int CODE_SCALE = 100;
    String wd;
    private Socket ftpSocket;
    private Socket dataSocket;
    private PrintStream ftp_os;
    private BufferedReader ftp_is;
    private boolean usePasv;
    private boolean useProxy;
    private InetAddress pasvAddress;
    private int pasvPort = 0;
    public boolean isConnected;
    public boolean keep_connection;
    KeepAliveThread kat;
    FtpConnectionInfo ftpconnectioninfo;

    public Ftp(FtpConnectionInfo ftpConnectionInfo) {
        this(ftpConnectionInfo, true);
    }

    public Ftp(FtpConnectionInfo ftpConnectionInfo, boolean bl) {
        this.ftpconnectioninfo = ftpConnectionInfo;
        this.keep_connection = bl;
        this.openControlConnection();
    }

    public void setPassiveMode(boolean bl) {
        this.usePasv = bl;
    }

    public boolean isPassiveMode() {
        return this.usePasv;
    }

    public String getHomeDirectory() {
        return this.ftpconnectioninfo.startDirectory;
    }

    public void login() throws IOException {
        FtpCommandReply ftpCommandReply = this.user();
        if (ftpCommandReply.replyCode / 100 >= 4) {
            throw new IOException(ftpCommandReply.replyMessage != null && ftpCommandReply.replyMessage.size() > 0 ? (String)ftpCommandReply.replyMessage.elementAt(0) : "Command user failed");
        }
        ftpCommandReply = this.pass();
        if (ftpCommandReply.replyCode / 100 >= 4) {
            throw new IOException(ftpCommandReply.replyMessage != null && ftpCommandReply.replyMessage.size() > 0 ? (String)ftpCommandReply.replyMessage.elementAt(0) : "Command pass failed");
        }
        if (this.ftpconnectioninfo.startDirectory == null || this.ftpconnectioninfo.startDirectory.length() == 0) {
            StringTokenizer stringTokenizer;
            ftpCommandReply = this.pwd();
            if (ftpCommandReply.replyMessage.size() > 0 && ftpCommandReply.replyCode / 100 == 2 && (stringTokenizer = new StringTokenizer((String)ftpCommandReply.replyMessage.elementAt(0), " ")).hasMoreTokens()) {
                stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    this.ftpconnectioninfo.startDirectory = stringTokenizer.nextToken();
                    if (this.ftpconnectioninfo.startDirectory.charAt(0) == '\"') {
                        this.ftpconnectioninfo.startDirectory = this.ftpconnectioninfo.startDirectory.substring(1, this.ftpconnectioninfo.startDirectory.length() - 1);
                    }
                } else {
                    this.ftpconnectioninfo.startDirectory = "";
                }
            }
        }
    }

    public synchronized FtpCommandReply abor() {
        byte[] byArray = new byte[]{-1, -12, -1, -14};
        this.ftp_os.write(byArray, 0, 4);
        String string = "ABOR";
        this.ftp_os.println(string);
        FtpCommandReply ftpCommandReply = this.getReply(string);
        if (ftpCommandReply == null) {
            this.openControlConnection();
            return ftpCommandReply;
        }
        if (ftpCommandReply.replyCode / 100 == 2) {
            return ftpCommandReply;
        }
        return this.getReply(null);
    }

    public synchronized FtpCommandReply acct(String string) {
        String string2 = "ACCT " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply allo(String string) {
        String string2 = "ALLO " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply allo(String string, String string2) {
        String string3 = "ALLO " + string + " R " + string2;
        this.ftp_os.println(string3);
        return this.getReply(string3);
    }

    public synchronized FtpCommandReply appe(String string) {
        String string2 = "APPE " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply cdup() {
        String string = "CDUP";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply cwd() {
        return this.cwd(this.ftpconnectioninfo.startDirectory);
    }

    public synchronized FtpCommandReply cwd(String string) {
        String string2 = "CWD " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply dele(String string) {
        String string2 = "DELE " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply help() {
        String string = "HELP";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply help(String string) {
        String string2 = "HELP " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply list() {
        return this.list(null);
    }

    public synchronized FtpCommandReply list(String string) {
        Socket socket = null;
        ServerSocket serverSocket = null;
        FtpCommandReply ftpCommandReply = null;
        if (this.usePasv) {
            ftpCommandReply = this.pasv();
            if (ftpCommandReply.replyCode / 100 >= 4) {
                return ftpCommandReply;
            }
            socket = this.getPasvSocket();
        } else {
            serverSocket = this.getServerSocket();
            this.port(serverSocket);
        }
        String string2 = "LIST";
        if (string != null) {
            string2 = string2 + " " + string;
        }
        this.ftp_os.println(string2);
        ftpCommandReply = this.getReply(string2);
        if (ftpCommandReply.replyCode / 100 == 1) {
            ftpCommandReply = this.usePasv ? this.getScreenData(socket) : this.getScreenData(serverSocket);
        }
        try {
            if (this.usePasv) {
                socket.close();
            } else {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply mkd(String string) {
        String string2 = "MKD " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply mode(String string) {
        String string2 = "MODE " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public FtpCommandReply nlst() {
        return this.nlst(null);
    }

    public synchronized FtpCommandReply nlst(String string) {
        Socket socket = null;
        ServerSocket serverSocket = null;
        FtpCommandReply ftpCommandReply = null;
        if (this.usePasv) {
            ftpCommandReply = this.pasv();
            if (ftpCommandReply.replyCode / 100 >= 4) {
                return ftpCommandReply;
            }
            socket = this.getPasvSocket();
        } else {
            serverSocket = this.getServerSocket();
            this.port(serverSocket);
        }
        String string2 = "NLST";
        if (string != null && string.length() > 0) {
            string2 = string2 + " " + string;
        }
        this.ftp_os.println(string2);
        ftpCommandReply = this.getReply(string2);
        if (ftpCommandReply.replyCode / 100 == 1) {
            ftpCommandReply = this.usePasv ? this.getScreenData(socket) : this.getScreenData(serverSocket);
        }
        try {
            if (this.usePasv) {
                socket.close();
            } else {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply noop() {
        String string = "NOOP";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply pass(String string) {
        this.ftpconnectioninfo.setPassword(string);
        return this.pass();
    }

    public synchronized FtpCommandReply pass() {
        String string = "PASS " + this.ftpconnectioninfo.getPassword();
        this.ftp_os.println(string);
        return this.getReply("PASS <hidden>");
    }

    public synchronized FtpCommandReply pasv() {
        String string = "PASV";
        this.ftp_os.println(string);
        FtpCommandReply ftpCommandReply = this.getReply(string);
        String string2 = (String)ftpCommandReply.replyMessage.elementAt(0);
        int n = string2.indexOf(40);
        int n2 = string2.indexOf(41);
        if (ftpCommandReply.replyCode / 100 >= 4) {
            return ftpCommandReply;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1, n2), ",");
        try {
            this.pasvAddress = InetAddress.getByName(stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.pasvPort = Integer.parseInt(stringTokenizer.nextToken()) << 8;
        this.pasvPort += Integer.parseInt(stringTokenizer.nextToken());
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply port(ServerSocket serverSocket) {
        byte[] byArray = null;
        try {
            serverSocket.getInetAddress();
            byArray = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        short[] sArray = new short[4];
        int n = 0;
        while (n <= 3) {
            sArray[n] = byArray[n];
            if (sArray[n] < 0) {
                int n2 = n;
                sArray[n2] = (short)(sArray[n2] + 256);
            }
            ++n;
        }
        int n3 = serverSocket.getLocalPort();
        String string = "PORT " + sArray[0] + "," + sArray[1] + "," + sArray[2] + "," + sArray[3] + "," + ((n3 & 0xFF00) >> 8) + "," + (n3 & 0xFF);
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply pwd() {
        String string = "PWD";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply quit() {
        if (!this.isConnected) {
            return null;
        }
        FtpCommandReply ftpCommandReply = null;
        try {
            String string = "QUIT";
            this.ftp_os.println(string);
            try {
                ftpCommandReply = this.getReply(string);
            }
            catch (NullPointerException nullPointerException) {
                Ftp.debugMsg("Exception on Quit", nullPointerException);
            }
            this.ftp_os.close();
            this.ftp_os = null;
            this.ftp_is.close();
            this.ftp_is = null;
            this.ftpSocket.close();
            this.ftpSocket = null;
            if (this.keep_connection && this.kat != null) {
                this.keep_connection = false;
                this.kat.interrupt();
                this.kat = null;
            }
            this.isConnected = false;
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply rein() {
        String string = "REIN";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply rest(String string) {
        String string2 = "REST " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply retr(String string, File file, int n) {
        ServerSocket serverSocket = null;
        Socket socket = null;
        if (this.usePasv) {
            socket = this.getPasvSocket();
        } else {
            serverSocket = this.getServerSocket();
        }
        String string2 = "RETR " + string;
        this.ftp_os.println(string2);
        FtpCommandReply ftpCommandReply = this.getReply(string2);
        if (ftpCommandReply.replyCode / 100 == 1) {
            ftpCommandReply = this.usePasv ? this.getFileData(file, socket, n) : this.getFileData(file, serverSocket, n);
        }
        try {
            if (this.usePasv) {
                socket.close();
            } else {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply rmd(String string) {
        String string2 = "RMD " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply rnfr(String string) {
        String string2 = "RNFR " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply rnto(String string) {
        String string2 = "RNTO " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply site(String string) {
        String string2 = "SITE " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply smnt(String string) {
        String string2 = "SMNT " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply stat() {
        String string = "STAT";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply stat(String string) {
        String string2 = "STAT " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply stor(String string) throws IOException {
        FtpCommandReply ftpCommandReply;
        ServerSocket serverSocket = null;
        Socket socket = null;
        if (this.usePasv) {
            ftpCommandReply = this.pasv();
            if (ftpCommandReply.replyCode / 100 >= 4) {
                throw new IOException((String)ftpCommandReply.replyMessage.elementAt(0));
            }
            socket = this.getPasvSocket();
        } else {
            serverSocket = this.getServerSocket();
            this.port(serverSocket);
        }
        String string2 = "STOR " + string;
        this.ftp_os.println(string2);
        ftpCommandReply = this.getReply(string2);
        if (ftpCommandReply.replyCode / 100 == 1) {
            if (this.usePasv) {
                ftpCommandReply.socket = socket;
            } else {
                ftpCommandReply.serverSocket = serverSocket;
            }
        } else {
            throw new IOException((String)ftpCommandReply.replyMessage.elementAt(0));
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply stor(String string, int n) {
        FtpCommandReply ftpCommandReply;
        ServerSocket serverSocket = null;
        Socket socket = null;
        if (this.usePasv) {
            ftpCommandReply = this.pasv();
            if (ftpCommandReply.replyCode / 100 >= 4) {
                return ftpCommandReply;
            }
            socket = this.getPasvSocket();
        } else {
            serverSocket = this.getServerSocket();
            this.port(serverSocket);
        }
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 == -1) {
            n2 = 0;
        }
        String string2 = "STOR " + string.substring(n2 + 1, string.length());
        this.ftp_os.println(string2);
        ftpCommandReply = this.getReply(string2);
        if (ftpCommandReply.replyCode / 100 == 1) {
            ftpCommandReply = this.usePasv ? this.putFileData(string, socket, n) : this.putFileData(string, serverSocket, n);
        }
        try {
            if (this.usePasv) {
                socket.close();
            } else {
                serverSocket.close();
            }
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    public synchronized FtpCommandReply stou() {
        String string = "STOU";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply stru(String string) {
        String string2 = "STRU " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply syst() {
        String string = "SYST";
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply type(String string) {
        String string2 = "TYPE " + string;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply type(String string, String string2) {
        String string3 = "TYPE " + string + " " + string2;
        this.ftp_os.println(string3);
        return this.getReply(string3);
    }

    public synchronized FtpCommandReply type(String string, Integer n) {
        String string2 = "TYPE " + string + " " + n;
        this.ftp_os.println(string2);
        return this.getReply(string2);
    }

    public synchronized FtpCommandReply user() {
        String string = "USER " + this.ftpconnectioninfo.user + (this.ftpconnectioninfo.useProxy ? "@" + this.ftpconnectioninfo.host : "");
        this.ftp_os.println(string);
        return this.getReply(string);
    }

    public synchronized FtpCommandReply user(String string) {
        this.ftpconnectioninfo.user = string;
        return this.user();
    }

    private Vector addVector(Vector vector, Vector vector2) {
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(vector2.elementAt(n2));
            ++n2;
        }
        return vector;
    }

    private Socket getClientSocket(ServerSocket serverSocket) {
        Socket socket = null;
        try {
            socket = serverSocket.accept();
        }
        catch (InterruptedIOException interruptedIOException) {
            Ftp.debug(interruptedIOException);
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return socket;
    }

    private FtpCommandReply getFileData(File file, ServerSocket serverSocket, int n) {
        Socket socket = this.getClientSocket(serverSocket);
        if (socket == null) {
            return new FtpCommandReply(null, 0, null, null);
        }
        FtpCommandReply ftpCommandReply = this.getFileData1(file, socket, n);
        try {
            socket.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    private FtpCommandReply getFileData(File file, Socket socket, int n) {
        return this.getFileData1(file, socket, n);
    }

    private FtpCommandReply getFileData1(File file, Socket socket, int n) {
        try {
            int n2;
            InputStream inputStream = socket.getInputStream();
            byte[] byArray = new byte[8192];
            int n3 = 0;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            while ((n2 = inputStream.read(byArray)) != -1) {
                if ((n3 += n2) <= n) {
                    // empty if block
                }
                randomAccessFile.write(byArray, 0, n2);
            }
            randomAccessFile.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return this.getReply(null);
    }

    private Socket getPasvSocket() {
        Socket socket = null;
        try {
            socket = new Socket(this.pasvAddress, this.pasvPort);
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return socket;
    }

    public synchronized FtpCommandReply getReply(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n = 0;
        try {
            string2 = this.ftp_is.readLine();
            vector.addElement(string2);
            n = Integer.parseInt(string2.substring(0, 3));
            if (string2.length() > 3 && string2.charAt(3) == '-') {
                do {
                    string2 = this.ftp_is.readLine();
                    vector.addElement(string2);
                } while (string2.length() <= 3 || !Character.isDigit(string2.charAt(0)) || !Character.isDigit(string2.charAt(1)) || !Character.isDigit(string2.charAt(2)) || string2.charAt(3) != ' ' || n != Integer.parseInt(string2.substring(0, 3)));
            }
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        catch (NullPointerException nullPointerException) {
            Ftp.debugMsg("FTP server returned null response for " + string, nullPointerException);
        }
        return new FtpCommandReply(string, n, vector, null);
    }

    private FtpCommandReply getScreenData(ServerSocket serverSocket) {
        Socket socket = this.getClientSocket(serverSocket);
        if (socket == null) {
            return new FtpCommandReply(null, 0, null, null);
        }
        FtpCommandReply ftpCommandReply = this.getScreenData1(socket);
        try {
            socket.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    private FtpCommandReply getScreenData(Socket socket) {
        return this.getScreenData1(socket);
    }

    private FtpCommandReply getScreenData1(Socket socket) {
        Object object;
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            object = socket.getInputStream();
            byte[] byArray = new byte[8192];
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                String string = null;
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    if ((char)byArray[n2] == '\n') {
                        String string2 = new String(byArray, n2 - n3, n3).trim();
                        if (string != null) {
                            vector.addElement(string + string2);
                            string = null;
                        } else {
                            vector.addElement(string2);
                        }
                        n3 = 0;
                    }
                    ++n2;
                    ++n3;
                }
                if (n3 <= 0) continue;
                string = new String(byArray, n2 - n3, n3);
            }
            ((InputStream)object).close();
            socket.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        object = this.getReply(null);
        return new FtpCommandReply(null, ((FtpCommandReply)object).replyCode, ((FtpCommandReply)object).replyMessage, vector);
    }

    private ServerSocket getServerSocket() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return serverSocket;
    }

    private void openControlConnection() {
        ConnectThread connectThread = new ConnectThread(this.ftpconnectioninfo);
        this.setPassiveMode(!this.ftpconnectioninfo.active);
        connectThread.start();
        try {
            connectThread.join(this.ftpconnectioninfo.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ftpSocket = connectThread.result();
        if (this.ftpSocket != null) {
            this.isConnected = true;
            try {
                this.ftp_os = new PrintStream(this.ftpSocket.getOutputStream());
                this.ftp_is = new BufferedReader(new InputStreamReader(this.ftpSocket.getInputStream()));
                System.err.println(this.getReply(null).toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this.keep_connection) {
                this.kat = new KeepAliveThread();
                this.kat.start();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.isConnected) {
            this.quit();
        }
        super.finalize();
    }

    private FtpCommandReply putFileData(String string, ServerSocket serverSocket, int n) {
        Socket socket = this.getClientSocket(serverSocket);
        if (socket == null) {
            return new FtpCommandReply(null, 0, null, null);
        }
        FtpCommandReply ftpCommandReply = this.putFileData1(string, socket, n);
        try {
            socket.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return ftpCommandReply;
    }

    private FtpCommandReply putFileData(String string, Socket socket, int n) {
        return this.putFileData1(string, socket, n);
    }

    private FtpCommandReply putFileData1(String string, Socket socket, int n) {
        try {
            int n2;
            OutputStream outputStream = socket.getOutputStream();
            byte[] byArray = new byte[8192];
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            int n3 = 0;
            while ((n2 = randomAccessFile.read(byArray)) != 0) {
                n3 += n2;
                outputStream.write(byArray, 0, n2);
            }
            randomAccessFile.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            Ftp.debug(iOException);
        }
        return this.getReply(null);
    }

    static void debug(Throwable throwable) {
        throwable.printStackTrace();
    }

    static void debugMsg(String string, Throwable throwable) {
        System.err.println(string + "(" + throwable + ')');
        throwable.printStackTrace();
    }

    class KeepAliveThread
    extends Thread {
        KeepAliveThread() {
        }

        public void run() {
            while (Ftp.this.keep_connection) {
                try {
                    Thread.sleep(300000L);
                    Ftp.this.noop();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

