/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.Entry;
import photoorganizer.formats.Exif;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;

public class TiffExif
extends Exif {
    static final int FAKE_JPEG_OFFSET = 7;

    public TiffExif(InputStream inputStream, byte[] byArray, int n, String string, boolean bl) throws FileFormatException {
        this.intel = bl;
        this.motorola = !bl;
        this.is = inputStream;
        this.data = byArray;
        this.offset = n;
        this.name = string;
        this.readInfo();
    }

    public void readInfo() {
        Entry entry;
        this.imagedescr = new Hashtable[]{new Hashtable(), new Hashtable()};
        this.processAllIFDs();
        if (this.imagedescr[1].get(new Integer(514)) == null && (entry = this.getTagValue(273, true)) != null) {
            this.imagedescr[1].put(new Integer(514), new Entry(4, new Object[]{new Integer((Integer)entry.getValue(0) - this.getThumbnailOffset() + 12)}));
        }
        if (this.imagedescr[1].get(new Integer(513)) == null) {
            this.imagedescr[1].put(new Integer(513), new Entry(4, new Object[]{new Integer(this.offset - 6)}));
        }
        this.offset = 0;
    }

    int firstIFD() {
        return this.s2n(2, 4) - this.offset + 7;
    }

    int nextIFD(int n) {
        return this.s2n(this.data.length - 4, 4) - this.offset + 7;
    }

    void storeIFD(int n) {
        int n2 = 0;
        try {
            BasicIo.skip(this.is, n - 7);
            this.offset += n - 7;
            this.data = new byte[2];
            this.offset += this.is.read(this.data);
            n2 = this.s2n(0, 2);
            byte[] byArray = new byte[12 * n2 + 4];
            BasicIo.read(this.is, byArray);
            this.offset += byArray.length;
            this.data = byArray;
            byte[] byArray2 = new byte[this.getExifSize(0, n2) - this.offset];
            BasicIo.read(this.is, byArray2);
            this.offset += byArray2.length;
            this.data = byArray;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 12 * n3;
                int n5 = this.s2n(n4, 2);
                int n6 = this.s2n(n4 + 2, 2);
                if (n6 >= 1 && n6 <= 10) {
                    int n7 = Exif.TYPELENGTH[n6 - 1];
                    int n8 = this.s2n(n4 + 4, 4);
                    int n9 = n4 + 8;
                    if (n8 * n7 > 4) {
                        n9 = this.s2n(n9, 4) - (this.offset - byArray2.length);
                        this.data = byArray2;
                    }
                    if (n6 == 2) {
                        try {
                            this.imagedescr[this.currentimage].put(new Integer(n5), new Entry(n6, new String(this.data, n9, n8 - 1, "Default")));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    } else {
                        Object[] objectArray = new Object[n8];
                        boolean bl = true;
                        int n10 = 0;
                        while (n10 < n8) {
                            objectArray[n10] = n6 % 5 != 0 ? new Integer(this.s2n(n9, n7, bl)) : new Rational(this.s2n(n9, 4, bl), this.s2n(n9 + 4, 4, bl));
                            n9 += n7;
                            this.imagedescr[this.currentimage].put(new Integer(n5), new Entry(n6, objectArray));
                            if (n5 == 34665 && n10 == 0 && (Integer)objectArray[0] > 0) {
                                this.storeIFD((Integer)objectArray[0] - this.offset + 7);
                            }
                            ++n10;
                        }
                    }
                    this.data = byArray;
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int getExifSize(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 12 * n5 + n;
            if (Exif.TYPELENGTH[this.s2n(n6 + 2, 2) - 1] * this.s2n(n6 + 4, 4) > 4 && n3 < this.s2n(n6 + 8, 4)) {
                n3 = this.s2n(n6 + 8, 4);
                n4 = Exif.TYPELENGTH[this.s2n(n6 + 2, 2) - 1] * this.s2n(n6 + 4, 4);
            }
            ++n5;
        }
        return n3 + n4;
    }
}

