/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.album;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import rogatkin.Serializer;

public class Access {
    static final String PICTURES_DATABASE = "Pictures";
    static final String[][] PICTURES_DATABASE_STRUCTURE = new String[][]{{"PicId", " INTEGER NOT NULL,"}, {"Name", " CHAR(255) NOT NULL,"}, {"LocId", " INTEGER,"}, {"ChkSum", " FLOAT,"}, {"Size", "   INTEGER,"}, {"Created", " TIMESTAMP,"}, {"Shutter", " FLOAT,"}, {"Aperture", " FLOAT,"}, {"Flash", " CHAR,"}, {"Zoom", " FLOAT,"}, {"Quality", " CHAR(10),"}, {"Make", " CHAR(30),"}, {"Model", " CHAR(30),"}, {"Resolution", " CHAR(10),"}, {"Commentary", " CHAR(255)"}};
    static final int PICTURES_PICID = 0;
    static final int PICTURES_NAME = 1;
    static final int PICTURES_LOCID = 2;
    static final int PICTURES_CHKSUM = 3;
    static final int PICTURES_SIZE = 4;
    static final int PICTURES_CREATED = 5;
    static final int PICTURES_SHUTTER = 6;
    static final int PICTURES_APERTURE = 7;
    static final int PICTURES_FLASH = 8;
    static final int PICTURES_ZOOM = 9;
    static final int PICTURES_QUALITY = 10;
    static final int PICTURES_MAKE = 11;
    static final int PICTURES_MODEL = 12;
    static final int PICTURES_RESOLUTION = 13;
    static final int PICTURES_COMMENTARY = 14;
    static final String CONNECTION_DATABASE = "Connection";
    static final String[][] CONNECTION_DATABASE_STRUCTURE = new String[][]{{"PicId", " INTEGER NOT NULL,"}, {"AlbumId", " INTEGER"}};
    static final int CONNECTION_PICID = 0;
    static final int CONNECTION_ALBUMID = 1;
    static final String ALBUM_DATABASE = "Album";
    static final String[][] ALBUM_DATABASE_STRUCTURE = new String[][]{{"AlbumId", " INTEGER NOT NULL,"}, {"Name", "    CHAR(255)"}};
    static final int ALBUM_ALBUMID = 0;
    static final int ALBUM_NAME = 1;
    static final String GROUPS_DATABASE = "Groups";
    static final String[][] GROUPS_DATABASE_STRUCTURE = new String[][]{{"GroupId", " INTEGER NOT NULL,"}, {"AlbumId", " INTEGER NOT NULL"}};
    static final int GROUPS_GROUPID = 0;
    static final int GROUPS_ALBUMID = 1;
    static final String LOCATIONS_DATABASE = "Locations";
    static final String[][] LOCATIONS_DATABASE_STRUCTURE = new String[][]{{"LocId", " INTEGER NOT NULL,"}, {"Disk", " CHAR(255)"}};
    static final int LOCATIONS_LOCID = 0;
    static final int LOCATIONS_DISK = 1;
    static final String[] TABLES = new String[]{"Pictures", "Connection", "Album", "Groups", "Locations"};
    static final String[][][] DESCRIPTIONS = new String[][][]{PICTURES_DATABASE_STRUCTURE, CONNECTION_DATABASE_STRUCTURE, ALBUM_DATABASE_STRUCTURE, GROUPS_DATABASE_STRUCTURE, LOCATIONS_DATABASE_STRUCTURE};
    public static final String SQL_INSERT = "INSERT INTO ";
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_WHERE = " WHERE ";
    public static final String SQL_DELETE = "DELETE ";
    public static final String SQL_UPDATE = "UPDATE ";
    public static final String SQL_SET = " SET ";
    static DecimalFormat APERTURE_FMT = new DecimalFormat("#0.#");
    static DecimalFormat SHUTTER_FMT = new DecimalFormat("#0.####");
    static DecimalFormat FOCAL_FMT = new DecimalFormat("##0.#");
    boolean[] table_present;
    private Controller controller;
    private Driver jdbc_driver;
    private Connection connection;

    public Access(Controller controller) {
        this.controller = controller;
        this.table_present = new boolean[TABLES.length];
        this.init();
    }

    public void init() {
        Object object;
        this.forgetTables();
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty("AlbumOptions", "DatabaseURL");
        Driver driver = null;
        String string2 = "";
        try {
            driver = DriverManager.getDriver(string);
        }
        catch (SQLException sQLException) {
            string2 = sQLException.toString();
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (driver == null) {
            try {
                object = (String)serializer.getProperty("AlbumOptions", "JDBCDriver");
                driver = (Driver)Class.forName((String)object).newInstance();
            }
            catch (Exception exception) {
                string2 = exception.toString();
            }
        }
        if (driver == null) {
            if (Serializer.getInt(this.controller.getSerializer().getProperty("AlbumOptions", "IgnoreDatabaseErrors"), 0) == 0) {
                JOptionPane.showMessageDialog(this.controller.getMainFrame(), "JDBC driver can't be instantiated, 'cause\n" + string2, "Error", 0);
            }
            return;
        }
        this.closeAllConnections();
        try {
            this.connection = DriverManager.getConnection(string, (String)serializer.getProperty("AlbumOptions", "User"), (String)serializer.getProperty("AlbumOptions", "Password"));
            Access.checkForWarning(this.connection.getWarnings());
            object = this.connection.getMetaData();
            System.err.println("Connected to " + object.getURL());
            System.err.println("Driver       " + object.getDriverName());
            System.err.println("Version      " + object.getDriverVersion());
            System.err.println("===DRIVER CAPABILITIES===");
            System.err.println("-" + (object.supportsPositionedUpdate() ? " " : " doesn't ") + "support positioned update");
            System.err.println("-" + (object.supportsPositionedDelete() ? " " : " doesn't ") + "support positioned delete");
            System.err.println("-" + (object.supportsANSI92EntryLevelSQL() ? " " : " doesn't ") + "support ANSI92 entry level");
            System.err.println("-" + (object.supportsANSI92FullSQL() ? " " : " doesn't ") + "support full ANSI92");
        }
        catch (SQLException sQLException) {
            if (Serializer.getInt(this.controller.getSerializer().getProperty("AlbumOptions", "IgnoreDatabaseErrors"), 0) == 0) {
                JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Couldn't establish database connection, check URL\n" + sQLException, "Error", 0);
            }
            Access.printChainedSqlException(sQLException);
            return;
        }
        this.getMetaInfo();
        this.createTables();
    }

    public void forgetTables() {
        int n = 0;
        while (n < this.table_present.length) {
            this.table_present[n] = false;
            ++n;
        }
    }

    void getMetaInfo() {
        try {
            DatabaseMetaData databaseMetaData = this.getAvailableConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
            while (resultSet.next()) {
                String string = resultSet.getString(3);
                int n = 0;
                while (n < TABLES.length) {
                    if (TABLES[n].equals(string)) {
                        this.table_present[n] = true;
                    }
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    public void createTables() {
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            int n = 0;
            while (n < TABLES.length) {
                if (!this.table_present[n]) {
                    StringBuffer stringBuffer = null;
                    System.err.println("Creation of " + TABLES[n]);
                    try {
                        try {
                            statement.executeUpdate("DROP TABLE " + TABLES[n]);
                        }
                        catch (Exception exception) {
                            System.err.println("DROP Sql: DROP TABLE " + TABLES[n] + ";" + exception);
                        }
                        stringBuffer = new StringBuffer("CREATE TABLE ");
                        stringBuffer.append(TABLES[n]);
                        stringBuffer.append(" (");
                        int n2 = 0;
                        while (n2 < DESCRIPTIONS[n].length) {
                            stringBuffer.append(DESCRIPTIONS[n][n2][0]);
                            stringBuffer.append(DESCRIPTIONS[n][n2][1]);
                            ++n2;
                        }
                        stringBuffer.append(")");
                        statement.executeUpdate(stringBuffer.toString());
                    }
                    catch (SQLException sQLException) {
                        Access.printChainedSqlException(sQLException);
                        System.err.println("Sql: " + stringBuffer.toString());
                    }
                }
                ++n;
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    int generateUniqueId(String string, String string2) {
        int n = 1;
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            statement.setMaxRows(1);
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT " + string2 + SQL_FROM + string + SQL_WHERE + string2 + " < 2147483647 ORDER BY 1 DESC");
            if (resultSet.next()) {
                n = resultSet.getInt(string2) + 1;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return n;
    }

    public synchronized int createAlbum(String string) {
        int n;
        String string2 = "INSERT INTO Album (" + ALBUM_DATABASE_STRUCTURE[0][0] + "," + ALBUM_DATABASE_STRUCTURE[1][0] + ") VALUES (?,?)";
        try {
            n = this.generateUniqueId(ALBUM_DATABASE, ALBUM_DATABASE_STRUCTURE[0][0]);
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            n = -1;
        }
        return n;
    }

    public int getAlbumId(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n = this.findAlbumIn(n, string2);
        }
        return n;
    }

    public int getAlbumId(TreePath treePath) {
        if (treePath == null || treePath.getPathCount() == 0) {
            return -1;
        }
        int n = 0;
        Object[] objectArray = treePath.getPath();
        int n2 = 1;
        while (n2 < objectArray.length) {
            n = this.findAlbumIn(n, objectArray[n2].toString());
            ++n2;
        }
        return n;
    }

    public int findAlbumIn(int n, String string) {
        String string2 = "SELECT Album." + ALBUM_DATABASE_STRUCTURE[0][0] + SQL_FROM + ALBUM_DATABASE + ',' + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE + '.' + GROUPS_DATABASE_STRUCTURE[1][0] + '=' + ALBUM_DATABASE + '.' + ALBUM_DATABASE_STRUCTURE[0][0] + " AND " + GROUPS_DATABASE + '.' + GROUPS_DATABASE_STRUCTURE[0][0] + "=? AND " + ALBUM_DATABASE + '.' + ALBUM_DATABASE_STRUCTURE[1][0] + "=?";
        int n2 = -1;
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            n2 = -1;
        }
        return n2;
    }

    boolean isInheritedFrom(int n, int[] nArray) {
        int[] nArray2 = this.getAlbumsId(n);
        if (nArray2.length == 0) {
            return false;
        }
        if (this.createIntersection(nArray2, nArray).length > 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (this.isInheritedFrom(nArray2[n2], nArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int[] createIntersection(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{};
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray2.length) {
                if (nArray[n] == nArray2[n2]) {
                    int[] nArray4 = new int[nArray3.length + 1];
                    System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
                    nArray4[nArray3.length] = nArray[n];
                    nArray3 = nArray4;
                }
                ++n2;
            }
            ++n;
        }
        return nArray3;
    }

    public synchronized int insertAlbumToAlbum(int[] nArray, int n) {
        int n2;
        Statement statement;
        String string = SQL_SELECT + ALBUM_DATABASE_STRUCTURE[0][0] + SQL_FROM + ALBUM_DATABASE + SQL_WHERE + ALBUM_DATABASE_STRUCTURE[0][0] + '=';
        String string2 = "INSERT INTO Groups (" + GROUPS_DATABASE_STRUCTURE[0][0] + ',' + GROUPS_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        if (this.isInheritedFrom(n, nArray)) {
            return -1;
        }
        try {
            statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            n2 = resultSet.next();
            resultSet.close();
            statement.close();
            if (n2 == 0) {
                return -1;
            }
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return -1;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            try {
                statement = this.getAvailableConnection().createStatement();
                statement.executeUpdate(string2 + String.valueOf(nArray[n2]) + "," + String.valueOf(n) + ')');
                statement.close();
            }
            catch (SQLException sQLException) {
                Access.printChainedSqlException(sQLException);
            }
            ++n2;
        }
        return n;
    }

    public boolean belongsToAlbum(BasicJpeg basicJpeg) {
        String string = SQL_SELECT + PICTURES_DATABASE_STRUCTURE[1][0] + SQL_FROM + PICTURES_DATABASE + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[1][0] + '=';
        if (basicJpeg == null) {
            return false;
        }
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + Access.SQLQuote(basicJpeg.getLocationName()));
            boolean bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return false;
        }
    }

    public synchronized void insertPicturesToAlbum(int n, BasicJpeg[] basicJpegArray) {
        Statement statement;
        PreparedStatement preparedStatement;
        String string = "INSERT INTO Locations (" + LOCATIONS_DATABASE_STRUCTURE[0][0] + ',' + LOCATIONS_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        String string2 = "INSERT INTO Connection (" + CONNECTION_DATABASE_STRUCTURE[0][0] + ',' + CONNECTION_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        StringBuffer stringBuffer = new StringBuffer(PICTURES_DATABASE_STRUCTURE[0][0]);
        StringBuffer stringBuffer2 = new StringBuffer(" VALUES (?");
        int n2 = 1;
        while (n2 < PICTURES_DATABASE_STRUCTURE.length) {
            stringBuffer.append(',').append(PICTURES_DATABASE_STRUCTURE[n2][0]);
            stringBuffer2.append(",?");
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer2.append(')');
        try {
            preparedStatement = this.getAvailableConnection().prepareStatement("INSERT INTO Pictures (" + stringBuffer.toString() + stringBuffer2.toString());
            statement = this.getAvailableConnection().createStatement();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return;
        }
        int n3 = 0;
        while (n3 < basicJpegArray.length) {
            try {
                AbstractImageInfo abstractImageInfo;
                int n4 = this.generateUniqueId(PICTURES_DATABASE, PICTURES_DATABASE_STRUCTURE[0][0]);
                if (n4 != -1 && (abstractImageInfo = basicJpegArray[n3].getImageInfo()) != null) {
                    preparedStatement.setInt(1, n4);
                    int n5 = 2;
                    while (n5 <= PICTURES_DATABASE_STRUCTURE.length) {
                        switch (n5 - 1) {
                            case 1: {
                                preparedStatement.setString(n5, basicJpegArray[n3].getLocationName());
                                break;
                            }
                            case 2: {
                                preparedStatement.setInt(n5, 0);
                                break;
                            }
                            case 3: {
                                preparedStatement.setInt(n5, 0);
                                break;
                            }
                            case 4: {
                                preparedStatement.setInt(n5, (int)basicJpegArray[n3].length());
                                break;
                            }
                            case 5: {
                                preparedStatement.setTimestamp(n5, new Timestamp(abstractImageInfo.getDateTimeOriginal().getTime()));
                                break;
                            }
                            case 6: {
                                preparedStatement.setString(n5, SHUTTER_FMT.format(abstractImageInfo.getShutter().floatValue()));
                                break;
                            }
                            case 7: {
                                preparedStatement.setString(n5, APERTURE_FMT.format(abstractImageInfo.getFNumber()));
                                break;
                            }
                            case 8: {
                                preparedStatement.setString(n5, abstractImageInfo.isFlash() ? "Y" : "N");
                                break;
                            }
                            case 9: {
                                preparedStatement.setString(n5, FOCAL_FMT.format(abstractImageInfo.getFocalLength()));
                                break;
                            }
                            case 10: {
                                preparedStatement.setString(n5, abstractImageInfo.getQuality());
                                break;
                            }
                            case 11: {
                                preparedStatement.setString(n5, abstractImageInfo.getMake());
                                break;
                            }
                            case 12: {
                                preparedStatement.setString(n5, abstractImageInfo.getModel());
                                break;
                            }
                            case 13: {
                                preparedStatement.setString(n5, abstractImageInfo.getResolutionX() + "x" + abstractImageInfo.getResolutionY());
                                break;
                            }
                            case 14: {
                                preparedStatement.setString(n5, "");
                                break;
                            }
                            default: {
                                preparedStatement.setObject(n5, null);
                            }
                        }
                        ++n5;
                    }
                    preparedStatement.executeUpdate();
                    statement.executeUpdate(string2 + n4 + ',' + n + ')');
                }
            }
            catch (SQLException sQLException) {
                Access.printChainedSqlException(sQLException);
            }
            ++n3;
        }
        try {
            preparedStatement.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    public File[] getAlbumContents(int n) {
        String string = SQL_SELECT + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + SQL_WHERE + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string2 = SQL_SELECT + PICTURES_DATABASE_STRUCTURE[1][0] + SQL_FROM + PICTURES_DATABASE + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
        File[] fileArray = new File[]{};
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            Statement statement2 = this.getAvailableConnection().createStatement();
            while (resultSet.next()) {
                try {
                    ResultSet resultSet2 = statement2.executeQuery(string2 + resultSet.getInt(1));
                    if (resultSet2.next()) {
                        File[] fileArray2 = new File[fileArray.length + 1];
                        System.arraycopy(fileArray, 0, fileArray2, 0, fileArray.length);
                        fileArray2[fileArray.length] = new File(resultSet2.getString(1).trim());
                        fileArray = fileArray2;
                    }
                    resultSet2.close();
                }
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                }
            }
            statement2.close();
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return fileArray;
    }

    public String getNameOfAlbum(int n) {
        String string = SQL_SELECT + ALBUM_DATABASE_STRUCTURE[1][0] + SQL_FROM + ALBUM_DATABASE + SQL_WHERE + ALBUM_DATABASE_STRUCTURE[0][0] + "=";
        String string2 = "Not found";
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            if (resultSet.next()) {
                string2 = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query " + string + n);
        }
        return string2;
    }

    public int getAlbumsCount(int n) {
        String string = "SELECT COUNT(*) FROM Groups WHERE " + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
        int n2 = 0;
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query " + string + n);
        }
        return n2;
    }

    public int[] getAlbumsId(int n) {
        String string = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[1][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[0][0] + "=";
        int[] nArray = new int[]{};
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            while (resultSet.next()) {
                int[] nArray2 = nArray;
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray2.length] = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return nArray;
    }

    public synchronized boolean renameAlbumTo(int n, String string) {
        String string2 = "UPDATE Album SET " + ALBUM_DATABASE_STRUCTURE[1][0] + "=?" + SQL_WHERE + ALBUM_DATABASE_STRUCTURE[0][0] + '=';
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2 + n);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string2 + n);
            return false;
        }
        return true;
    }

    public synchronized void deleteAlbumFrom(int[] nArray, int n) {
        String string = "DELETE  FROM Groups WHERE " + GROUPS_DATABASE_STRUCTURE[0][0] + "=?" + " AND " + GROUPS_DATABASE_STRUCTURE[1][0] + "=?";
        String string2 = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[1][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[1][0] + '=';
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string);
            int n2 = 0;
            while (n2 < nArray.length) {
                try {
                    preparedStatement.setInt(1, nArray[n2]);
                    preparedStatement.setInt(2, n);
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For query " + string + " p1=" + nArray[n2] + " p2=" + n);
                }
                ++n2;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("Couldn't prepare statement " + string);
            return;
        }
        boolean bl = false;
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string2 + n);
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query " + string2 + n);
        }
        if (!bl) {
            this.deleteAlbum(n);
        }
    }

    public synchronized void deleteAlbum(int n) {
        ResultSet resultSet;
        Statement statement;
        String string = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[1][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
        String string2 = SQL_SELECT + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + SQL_WHERE + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string3 = "DELETE  FROM Groups WHERE " + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
        String string4 = " OR " + GROUPS_DATABASE_STRUCTURE[1][0] + '=';
        String string5 = "DELETE  FROM Album WHERE " + ALBUM_DATABASE_STRUCTURE[0][0] + '=';
        String string6 = "DELETE  FROM Connection WHERE " + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        try {
            statement = this.getAvailableConnection().createStatement();
            resultSet = statement.executeQuery(string + n);
            while (resultSet.next()) {
                this.deleteAlbum(resultSet.getInt(1));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query " + string + n);
        }
        try {
            statement = this.getAvailableConnection().createStatement();
            resultSet = statement.executeQuery(string2 + n);
            while (resultSet.next()) {
                this.deletePicture(resultSet.getInt(1));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query " + string2 + n);
        }
        try {
            statement = this.getAvailableConnection().createStatement();
            statement.executeUpdate(string3 + n + string4 + n);
            statement.executeUpdate(string5 + n);
            statement.executeUpdate(string6 + n);
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For queries " + string3 + n + string4 + n + '\n' + string5 + n + '\n' + string6 + n);
        }
    }

    public synchronized void deletePicture(int n, String string) {
        String string2 = "SELECT Connection." + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + ',' + PICTURES_DATABASE + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + " AND " + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string3 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
        String string4 = "DELETE  FROM Connection WHERE " + CONNECTION_DATABASE_STRUCTURE[0][0] + '=';
        String string5 = " AND " + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string2 + n + string3 + Access.SQLQuote(string));
            if (resultSet.next()) {
                Statement statement2 = this.getAvailableConnection().createStatement();
                statement.executeUpdate(string4 + resultSet.getInt(1) + string5 + n);
                statement2.close();
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For queries " + string2 + n + string3 + string + "'\n" + string4 + '?' + string5 + n);
            sQLException.printStackTrace();
        }
    }

    public synchronized void deletePicture(int n) {
        String string = "DELETE  FROM Pictures WHERE " + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            statement.executeUpdate(string + n);
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For queries " + string + n);
        }
    }

    public synchronized void setPictureComment(int n, String string) {
        String string2 = "UPDATE Pictures SET " + PICTURES_DATABASE_STRUCTURE[14][0] + "=? " + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2 + n);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string2 + n);
        }
    }

    public synchronized void setPictureComment(int n, String string, String string2) {
        String string3 = "UPDATE Connection,Pictures SET " + PICTURES_DATABASE_STRUCTURE[14][0] + "=? " + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + " AND " + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string4 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=?";
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string3 + n + string4);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string3 + n + string4 + string + '\'');
        }
    }

    public synchronized void renamePictureTo(int n, String string, String string2) {
        String string3 = "UPDATE Connection,Pictures SET " + PICTURES_DATABASE_STRUCTURE[1][0] + "=? " + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + " AND " + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string4 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string3 + n + string4 + Access.SQLQuote(string));
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string3 + n + string4 + string + "'(?)" + string2);
        }
    }

    public synchronized String getPictureComment(int n, String string) {
        String string2 = "SELECT Pictures." + PICTURES_DATABASE_STRUCTURE[14][0] + SQL_FROM + CONNECTION_DATABASE + ',' + PICTURES_DATABASE + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + " AND " + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string3 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
        String string4 = null;
        if (n < 0) {
            return string4;
        }
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string2 + n + string3 + Access.SQLQuote(string));
            if (resultSet.next() && (string4 = resultSet.getString(1)) != null) {
                string4 = string4.trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For queries " + string2 + n + string3 + string + '\'');
            sQLException.printStackTrace();
        }
        return string4;
    }

    public Connection getAvailableConnection() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("No suitable JDBC driver, or JDBC settings set not properly");
        }
        return this.connection;
    }

    public void closeAllConnections() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    protected void finalize() throws Throwable {
        this.closeAllConnections();
        super.finalize();
    }

    public static String SQLQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        char[] cArray = string.toCharArray();
        stringBuffer.append('\'');
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\'') {
                stringBuffer.append(cArray, n2, n - n2 + 1).append(cArray[n]);
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < n) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static void printChainedSqlException(SQLException sQLException) {
        System.err.println("*** SQLException caught ***");
        while (sQLException != null) {
            System.err.println("state:      " + sQLException.getSQLState());
            System.err.println("message:    " + sQLException.getMessage());
            System.err.println("error code: " + sQLException.getErrorCode());
            sQLException = sQLException.getNextException();
            if (sQLException == null) continue;
            System.err.println("ooooo>>>");
        }
        System.err.println("*****************");
    }

    private static boolean checkForWarning(SQLWarning sQLWarning) throws SQLException {
        if (sQLWarning != null) {
            System.err.println("*** SQLWarning ***");
            while (sQLWarning != null) {
                System.err.println("state:      " + sQLWarning.getSQLState());
                System.err.println("message:    " + sQLWarning.getMessage());
                System.err.println("error code: " + sQLWarning.getErrorCode());
                sQLWarning = sQLWarning.getNextWarning();
                if (sQLWarning == null) continue;
                System.err.println("ooooo>>>");
            }
            System.err.println("********===********");
            return true;
        }
        return false;
    }
}

