/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import photoorganizer.HtmlProducer;
import photoorganizer.Lex;

class Lexer {
    static final char CPERCENT = '%';
    static final char CEXLAM = '!';
    static final char[] LEX_MARKER = new char[]{'!', '%'};
    char[] stream;
    int p;
    int state;
    ResourceBundle mnemonicsBundle;
    Hashtable mnemonics;
    static final int STATE_IN_HTML = 0;
    static final int STATE_IN_MARKER = 1;
    static final int STATE_IN_LEXEM = 2;
    static final int STATE_IN_ = 3;
    static final String DELIMS = " -/,\\()<>\"'" + LEX_MARKER[0];

    Lexer(String string) {
        InputStream inputStream = null;
        try {
            int n;
            try {
                inputStream = new URL(string).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            byte[] byArray = new byte[4096];
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            while ((n = inputStream.read(byArray)) >= 0) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            this.stream = stringBuffer.toString().toCharArray();
            inputStream.close();
        }
        catch (IOException iOException) {
            this.stream = "<html><body bgcolor=\"#F1D0F2\" link=\"#0000FF\" vlink=\"#800080\"><p align=\"center\"><h2>No publishing template HTML defined</h2></p><p><small><strong>Open Settings/WebPublishing and check template location.</stron></small></p><!--!%loop--><a href=\"!%webp!%tnof\"><img src=\"!%tnfn\" alt=\"!%tntt\" border=0 style=\"border: 0px none\"></a><br><!--!%endl--></body></html>".toCharArray();
        }
        this.mnemonics = new Hashtable(HtmlProducer.LEXEM_MENMONICS.length);
        int n = 0;
        while (n < HtmlProducer.LEXEM_MENMONICS.length) {
            this.mnemonics.put(HtmlProducer.LEXEM_MENMONICS[n], new Integer(n));
            ++n;
        }
        this.state = 0;
    }

    Lex getNextLex() {
        int n = this.p;
        int n2 = LEX_MARKER.length;
        while (this.p < this.stream.length) {
            switch (this.state) {
                case 0: {
                    if (n2 <= 0 || this.stream[this.p] != LEX_MARKER[LEX_MARKER.length - n2]) break;
                    this.state = 1;
                    --n2;
                    return new Lex(new String(this.stream, n, this.p - n), 0);
                }
                case 1: {
                    if (n2 == 0) {
                        this.state = 2;
                        n2 = LEX_MARKER.length;
                        break;
                    }
                    if (this.stream[this.p] == LEX_MARKER[LEX_MARKER.length - n2]) {
                        --n2;
                        break;
                    }
                    this.state = 0;
                    n2 = LEX_MARKER.length;
                    break;
                }
                case 2: {
                    if (DELIMS.indexOf(this.stream[this.p]) < 0) break;
                    String string = new String(this.stream, n + LEX_MARKER.length, this.p - n - LEX_MARKER.length).toLowerCase();
                    Integer n3 = (Integer)this.mnemonics.get(string);
                    this.state = 0;
                    if (n3 == null) break;
                    return new Lex(string, n3);
                }
            }
            ++this.p;
        }
        return new Lex(new String(this.stream, n, this.stream.length - n), -1);
    }
}

