//----------------------------------------------------------
#include <vcl\vcl.h>
#include <math.h>
#include <assert.h>
#pragma hdrstop

#include "FrmDxf2X.h"
#include "FrmSplsh.h"
#include "D3dUtil.h"
#include "D3dInOut.h"
#include "DxfColor.h"
//----------------------------------------------------------
#pragma link "FrmCnv"
#pragma resource "*.dfm"
TDxfXCnvForm *DxfXCnvForm;
//----------------------------------------------------------
#include "_Convert.cpp"
#include "_B2Frame.cpp"
#include "_ColMesh.cpp"
//----------------------------------------------------------
static void OnProgress(long now, long total) {
  TProgressRange max = ::DxfXCnvForm->ProgressBar->Max;
  TProgressRange pos = TProgressRange(float(now)/total*max);
  ::DxfXCnvForm->ProgressBar->Position = pos;
  Application->ProcessMessages(); //   
  // Abort    .
}//---------------------------------------------------------
__fastcall TDxfXCnvForm::TDxfXCnvForm(TComponent* Owner)
   : TConvertForm(Owner)
{
  DxfModel = new TDxfMeshModel;
  DxfModel->OnProgress = OnProgress;
  Direct3DRMCreate(&IRM);
  assert(IRM);
}//---------------------------------------------------------
__fastcall TDxfXCnvForm::~TDxfXCnvForm() {
  delete DxfModel;
  IRM->Release();
  CountTable.Clear();
}//---------------------------------------------------------
void __fastcall TDxfXCnvForm::WMHelp(TMessage &Message) {
  if (!FileExists(Application->HelpFile))
     SplashForm->ShowModal();
  else Application->HelpCommand(HELP_CONTENTS,0);
}//---------------------------------------------------------
void __fastcall TDxfXCnvForm::btnAbortClick(TObject*) {
  DxfModel->Aborted = true;
  ProgressBar->Position = 0;
}//---------------------------------------------------------
