/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import java.io.IOException;
import java.io.OutputStream;

public class RGBSunRasterEncoder
extends SpecificEncoder {
    public void doImageEncode() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        adaptiveRasterImage.setRGBDefault(true);
        try {
            this.writeImage();
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected void writeImage() throws IOException, JimiException {
        SunRasterHeader sunRasterHeader = this.getHeader();
        sunRasterHeader.setDepth(24);
        sunRasterHeader.setType(3);
        this.writeHeader();
        OutputStream outputStream = this.getOutputStream();
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        int n = adaptiveRasterImage.getHeight();
        int n2 = adaptiveRasterImage.getWidth();
        int n3 = n2 * 3;
        if (n3 % 2 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n) {
            adaptiveRasterImage.getChannelRGB(n4, byArray, 0);
            outputStream.write(byArray);
            ++n4;
        }
    }
}

