/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.util.x11.XpmParser;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.InputStream;

public class XPMDecoder
extends JimiDecoderBase {
    protected XpmParser parser_;
    protected AdaptiveRasterImage jimiImage_;
    protected int state_;

    public boolean driveDecoder() throws JimiException {
        try {
            if (!this.parser_.parse()) {
                throw new JimiException("Image does not parse.");
            }
            this.xpmInitialize(this.parser_.getWidth(), this.parser_.getHeight(), this.parser_.getPixmap(), this.parser_.getColorTable());
        }
        catch (JimiException jimiException) {
            this.state_ = 1;
            throw jimiException;
        }
        catch (RuntimeException runtimeException) {
            this.state_ = 1;
            throw new JimiException(runtimeException.getMessage());
        }
        this.state_ = 4;
        this.jimiImage_.addFullCoverage();
        return false;
    }

    public void freeDecoder() {
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.jimiImage_;
    }

    public int getState() {
        return this.state_;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.parser_ = new XpmParser(inputStream);
        this.jimiImage_ = adaptiveRasterImage;
        this.state_ = 0;
    }

    protected void xpmInitialize(int n, int n2, byte[] byArray, Color[] colorArray) throws JimiException {
        int n3 = colorArray.length;
        int n4 = 3 * n3;
        byte[] byArray2 = new byte[n4];
        int n5 = -1;
        int n6 = 0;
        while (n6 < n3) {
            if (colorArray[n6] == null) {
                n5 = n6;
            } else {
                byArray2[3 * n6] = (byte)colorArray[n6].getRed();
                byArray2[3 * n6 + 1] = (byte)colorArray[n6].getGreen();
                byArray2[3 * n6 + 2] = (byte)colorArray[n6].getBlue();
            }
            ++n6;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, n3, byArray2, 0, false, n5);
        this.jimiImage_.setSize(n, n2);
        this.jimiImage_.setColorModel(indexColorModel);
        this.jimiImage_.setPixels();
        this.jimiImage_.setChannel(0, 0, 0, n, n2, byArray, 0, n);
    }
}

