//----------------------------------------------------------
#ifndef MMakerH
#define MMakerH
#include "LinkList.hpp"
//----------------------------------------------------------
#ifndef _DWORD_DEFINED
#define DWORD unsigned long
#endif
//----------------------------------------------------------
// V E C T O R
//----------------------------------------------------------
#ifndef __D3DRMWIN_H__
struct VECTOR {
  float x, y, z;
  VECTOR () {x = y = z = 0.0;}
  VECTOR (float f) {x = y = z = f;}
  VECTOR (float a, float b, float c) {x = a; y = b; z = c;}
  friend int operator == (const VECTOR& a, const VECTOR& b){
     return a.x==b.x && a.y==b.y && a.z == b.z;
  }
};//--------------------------------------------------------
#else
#define VECTOR D3DVECTOR
#endif // __D3DRMWIN_H__
//----------------------------------------------------------
typedef LinkList<DWORD>  TIndexList;
typedef LinkIter<DWORD>  TIndexIter;
typedef LinkList<VECTOR> TVertList;
typedef LinkIter<VECTOR> TVertIter;
//----------------------------------------------------------
// T F a c e
//----------------------------------------------------------
class TFace : public TIndexList {
  DWORD dwUnique;
public:
  TFace() : TIndexList() {
     dwUnique = 0;
     Color    = 7; // AutoCAD white color
  }
  int      Color;
  bool     Valid();
  DWORD    Unique() const { return dwUnique; }
  DWORD    AddVertex(DWORD vindex);
  TFace& operator = (const TFace& n);
  friend int operator == (const TFace& a, const TFace& b);
};//--------------------------------------------------------
typedef LinkList<TFace>  TFaceList;
typedef LinkIter<TFace>  TFaceIter;
//----------------------------------------------------------
// T M e s h M a k e r
//----------------------------------------------------------
class TMeshMaker {
  DWORD flist_len;
public:
  DWORD BadCount, DupCount;
  TMeshMaker(){
     flist_len = 0;
     flist = NULL;
     vlist = NULL;
  }
  ~TMeshMaker(){Clear();}
  void  Clear();
  int   MakeMeshLists(bool DoubleSided = false);
  DWORD AddVertex(VECTOR &Vec);
  DWORD AddFace(TFace &Face);
  DWORD vcount() { return VertList.count(); }
  DWORD *flist;
  VECTOR *vlist;
  TVertList VertList;
  TFaceList FaceList;
};//--------------------------------------------------------
#endif