__fastcall TVport::TVport(TComponent* Owner)
  : TGraphicControl(Owner) {
  Width = 100; Height = 75;
}//---------------------------------------------------------
__fastcall TVport::~TVport() {
  RELEASE(IRMVport);
}//---------------------------------------------------------
void __fastcall TVport::Init(LPDIRECT3DRM IRM,
  LPDIRECT3DRMDEVICE Idevice,
  LPDIRECT3DRMFRAME  Icamera)
{
  if (!Idevice || !IRM || !Icamera) return;
  TRY(IRM->CreateViewport(Idevice, Icamera,
                      Left, Top, Width, Height, &IRMVport));
  Restore();
  IRMVport->SetName(Name.c_str());
}//---------------------------------------------------------
void __fastcall TVport::Update() {
  if (IRMVport)
  IRMVport->ForceUpdate(Left, Top, Width, Height);
}//---------------------------------------------------------
void __fastcall TVport::SetBounds(int ALeft, int ATop,
                   int AWidth, int AHeight)
{
  TGraphicControl::SetBounds(ALeft, ATop, AWidth, AHeight);
  if (!IRMVport) return;
  IRMVport->Configure(Left, Top, Width, Height);
}//---------------------------------------------------------
void __fastcall TVport::Save() {
  ViewportData.Save(IRMVport);
}//---------------------------------------------------------
void __fastcall TVport::Restore() {
  ViewportData.Restore(IRMVport);
}//---------------------------------------------------------
void __fastcall TVport::Release() {
  ViewportData.Save(IRMVport);
  RELEASE(IRMVport);
}//---------------------------------------------------------
LPDIRECT3DRMFRAME __fastcall TVport::GetCamera() {
  if (!IRMVport) return NULL;
  LPDIRECT3DRMFRAME Icamera = NULL, result;
  IRMVport->GetCamera(&Icamera);
  result = Icamera;
  RELEASE(Icamera);
  return result;
}//---------------------------------------------------------
void __fastcall TVport::SetCamera(LPDIRECT3DRMFRAME Icamera,
  bool update)
{
  if (!Icamera || !IRMVport) return;
  TRY(IRMVport->SetCamera(Icamera));
  if (Parent && update) {
     TD3dView* D3dView = dynamic_cast<TD3dView*>(Owner);
     if (D3dView) D3dView->Refresh();
  }
}//---------------------------------------------------------
void __fastcall TVport::SetCameraTransform(LPDIRECT3DRMFRAME
  Iframe, bool update)
{
  if (!Iframe || !IRMVport) return;
  D3DVECTOR pos, dir, up;
  LPDIRECT3DRMFRAME Iscene = NULL, Icamera;
  Icamera = GetCamera();
  if (!Icamera) return;
  Iframe->GetScene(&Iscene);
  TRY(Iframe->GetPosition(Iscene, &pos));
  TRY(Iframe->GetOrientation(Iscene, &dir, &up));
  Icamera->SetPosition(Iscene,    pos.x, pos.y, pos.z);
  Icamera->SetOrientation(Iscene, dir.x, dir.y, dir.z,
                                   up.x,  up.y,  up.z);
  RELEASE(Iscene);
  if (Parent && update) {
     TD3dView* D3dView = dynamic_cast<TD3dView*>(Owner);
     if (D3dView) D3dView->Refresh();
  }
}//---------------------------------------------------------
TCanvas* __fastcall TVport::GetGDI() {
  TD3dView* D3dView = dynamic_cast<TD3dView*>(Owner);
  if (D3dView) D3dView->FlipToGDISurface();
  return Canvas;
}//---------------------------------------------------------
void __fastcall TVport::Vec2xy(LPD3DVECTOR pVec,
  int& x, int& y)
{
  D3DVECTOR scene_pos;
  D3DRMVECTOR4D plane_pos;
  TD3dView* D3dView = dynamic_cast<TD3dView*>(Owner);
  if (!D3dView || !D3dView->IcsFrame) return;
  D3dView->IcsFrame->Transform(&scene_pos, pVec);
  x = 0; y = 0;
  if (!IRMVport) return;
  IRMVport->Transform(&plane_pos, &scene_pos);
  D3DVALUE w = plane_pos.w;
  if ((w != 0) && (plane_pos.z > 0) && (plane_pos.z < w)) {
     x = int(plane_pos.x/w);   y = int(plane_pos.y/w);
  }
}//---------------------------------------------------------
void __fastcall TVport::MoveTo3D(LPD3DVECTOR pVec) {
  int x, y; Vec2xy(pVec, x, y); GDI->MoveTo(x, y);
}//---------------------------------------------------------
void __fastcall TVport::MoveTo3D(D3DVALUE x,
  D3DVALUE y, D3DVALUE z)
{
  int ix, iy; D3DVECTOR Vec;
  Vec.x = x; Vec.y = y; Vec.z = z;
  Vec2xy(&Vec, ix, iy); GDI->MoveTo(ix, iy);
}//---------------------------------------------------------
void __fastcall TVport::LineTo3D(LPD3DVECTOR pVec) {
  if ((GDI->PenPos.x == 0) && (GDI->PenPos.y == 0)) return;
  int x, y; Vec2xy(pVec, x, y);
  if (x && y) GDI->LineTo(x, y);
}//---------------------------------------------------------
void __fastcall TVport::LineTo3D(D3DVALUE x,
  D3DVALUE y, D3DVALUE z)
{
  if ((GDI->PenPos.x == 0) && (GDI->PenPos.y == 0)) return;
  int ix, iy; D3DVECTOR Vec;
  Vec.x = x; Vec.y = y; Vec.z = z;
  Vec2xy(&Vec, ix, iy);
  if (ix && iy) GDI->LineTo(ix, iy);
}//---------------------------------------------------------
void __fastcall TVport::Line3D(LPD3DVECTOR pVec1,
  LPD3DVECTOR pVec2)
{
  MoveTo3D(pVec1); LineTo3D(pVec2);
}//---------------------------------------------------------
void __fastcall TVport::TextOut3D(LPD3DVECTOR pVec,
  char *t)
{
  int x, y;
  Vec2xy(pVec, x, y);
  if (x && y) GDI->TextOut(x, y, t);
}//---------------------------------------------------------
