//----------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FrmWrap.h"
//----------------------------------------------------------
#pragma resource "*.dfm"
TWrapForm *WrapForm;
//----------------------------------------------------------
__fastcall TWrapForm::TWrapForm(TComponent* Owner)
    : TForm(Owner) {
}//---------------------------------------------------------
void __fastcall TWrapForm::SetNone() {
  Caption = "Wrap: No Selection";
  EnableControls(false);
}//---------------------------------------------------------
void __fastcall TWrapForm::Manage(void* object) {
  FObject = NULL;
  Wrap    = NULL;
  appdata = NULL;
  AnsiString cname = RMClassName(object);
  if (cname == "Face") {
     appdata = (TAppData*) ASOBJECT(object)->GetAppData();
     if (appdata) Wrap = appdata->Wrap;
     Caption = "Face Wrap";
     FObject = object;
     GetWrapData();
  }
  else
  if (cname == "Builder") {
     appdata = (TAppData*) ASOBJECT(object)->GetAppData();
     if (appdata) Wrap = appdata->Wrap;
     Caption = "Builder Wrap";
     FObject = object;
     GetWrapData();
  }
  else SetNone();
}//---------------------------------------------------------
void __fastcall TWrapForm::GetWrapData() {
  if (!Visible) return;
  if (!Wrap) {
     EnableControls(false);
     if (FObject) btnNew->Enabled = true;
     return;
  }
  EnableControls(true);
  btnNew->Enabled = false;
  DecimalSeparator = '.';
  edOX->Text = FloatToStrF(Wrap->ox, ffFixed, 15, 2);
  edOY->Text = FloatToStrF(Wrap->oy, ffFixed, 15, 2);
  edOZ->Text = FloatToStrF(Wrap->oz, ffFixed, 15, 2);
  edZX->Text = FloatToStrF(Wrap->dx, ffFixed, 15, 2);
  edZY->Text = FloatToStrF(Wrap->dy, ffFixed, 15, 2);
  edZZ->Text = FloatToStrF(Wrap->dz, ffFixed, 15, 2);
  edYX->Text = FloatToStrF(Wrap->ux, ffFixed, 15, 2);
  edYY->Text = FloatToStrF(Wrap->uy, ffFixed, 15, 2);
  edYZ->Text = FloatToStrF(Wrap->uz, ffFixed, 15, 2);
  edTX->Text = FloatToStrF(Wrap->ou, ffFixed, 15, 2);
  edTY->Text = FloatToStrF(Wrap->ov, ffFixed, 15, 2);
  edSX->Text = FloatToStrF(Wrap->su, ffFixed, 15, 2);
  edSY->Text = FloatToStrF(Wrap->sv, ffFixed, 15, 2);
  TypeCombo->ItemIndex = Wrap->type;
}//---------------------------------------------------------
void __fastcall TWrapForm::EnableControls(bool enable) {
  for (int i = 0; i < ComponentCount; i++) {
     TControl *Control =
            dynamic_cast<TControl*>(Components[i]);
     if (Control) Control->Enabled = enable;
  }
}//---------------------------------------------------------
void __fastcall TWrapForm::FormActivate(TObject*) {
  GetWrapData();
}//---------------------------------------------------------
void __fastcall TWrapForm::btnNewClick(TObject *) {
  if (Wrap) return;
  Wrap = new TWrap;
  Wrap->IObject = ASOBJECT(FObject);
  if (!appdata) {
     appdata = new TAppData;
     TRY(Wrap->IObject->SetAppData((DWORD)appdata));
     TRY(Wrap->IObject->AddDestroyCallback(
                                     AppDataDestroy, NULL));
  }
  Wrap->ReApply();
  appdata->Wrap = Wrap;
  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TWrapForm::btnReApplyClick(TObject*) {
  try {
     DecimalSeparator = '.';
     Wrap->ox = edOX->Text.ToDouble();
     Wrap->oy = edOY->Text.ToDouble();
     Wrap->oz = edOZ->Text.ToDouble();
     Wrap->dx = edZX->Text.ToDouble();
     Wrap->dy = edZY->Text.ToDouble();
     Wrap->dz = edZZ->Text.ToDouble();
     Wrap->ux = edYX->Text.ToDouble();
     Wrap->uy = edYY->Text.ToDouble();
     Wrap->uz = edYZ->Text.ToDouble();
     Wrap->ou = edTX->Text.ToDouble();
     Wrap->ov = edTY->Text.ToDouble();
     Wrap->su = edSX->Text.ToDouble();
     Wrap->sv = edSY->Text.ToDouble();
     Wrap->type = D3DRMWRAPTYPE(TypeCombo->ItemIndex);
     Wrap->ReApply();
  } catch (Exception &exception) {
     Application->ShowException(&exception);
  }
  Application->MainForm->Update();
}//---------------------------------------------------------
void __fastcall TWrapForm::FormKeyDown(TObject*, WORD &Key,
  TShiftState)
{
  if (Key == VK_ESCAPE) Close();
}//---------------------------------------------------------
