//----------------------------------------------------------
#ifndef FrmSaveH
#define FrmSaveH
#include <vcl\Classes.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\Forms.hpp>
#include <vcl\ExtCtrls.hpp>
#include <vcl\Buttons.hpp>
#include <d3drmwin.h>
#ifndef D3DRMXOFSAVE_TEMPLATES // DirectX < 3
#define D3DRMXOFSAVE_TEMPLATES 16
#endif
//----------------------------------------------------------
class TSaveForm : public TForm
{
__published:  // IDE-managed Components
  TRadioGroup *FormatGroup;
   TRadioButton *Text;
   TRadioButton *Binary;
   TRadioButton *Compressed;
  TGroupBox *OptionsGroup;
   TCheckBox *All;
   TCheckBox *Normals;
   TCheckBox *Materials;
   TCheckBox *Templates;
   TCheckBox *TextureNames;
   TCheckBox *TextureCoordinates;
   TBitBtn *btnOk;
   TBitBtn *btnCancel;
  TBevel *Bevel1;
  void __fastcall AllClick(TObject *Sender);
  void __fastcall btnOkClick(TObject *Sender);
  
  void __fastcall btnCancelClick(TObject *Sender);
   
private:    // User declarations
  D3DRMXOFFORMAT   SAVED_XOFFORMAT;
  D3DRMSAVEOPTIONS SAVED_OPTIONS;
  void __fastcall SetOptions(D3DRMSAVEOPTIONS ops);
  D3DRMSAVEOPTIONS __fastcall GetOptions();
  void __fastcall SetFormat(D3DRMXOFFORMAT Format);
  D3DRMXOFFORMAT __fastcall GetFormat();
public:     // User declarations
  __fastcall TSaveForm(TComponent* Owner);
  void __fastcall Execute();
__published:
  __property D3DRMSAVEOPTIONS Options = {read=GetOptions, write=SetOptions};
  __property D3DRMXOFFORMAT Format = {read=GetFormat, write=SetFormat};
};
//----------------------------------------------------------
extern TSaveForm *SaveForm;
//----------------------------------------------------------
#endif
