//----------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FrmSave.h"
//----------------------------------------------------------
#pragma resource "*.dfm"
TSaveForm *SaveForm;
//----------------------------------------------------------
__fastcall TSaveForm::TSaveForm(TComponent* Owner)
  : TForm(Owner) {
  SAVED_XOFFORMAT = GetFormat();
  SAVED_OPTIONS   = GetOptions();
}//---------------------------------------------------------
void __fastcall TSaveForm::SetOptions(D3DRMSAVEOPTIONS ops){
  All->Checked          = (ops & D3DRMXOFSAVE_ALL);
  Normals->Checked      = (ops & D3DRMXOFSAVE_NORMALS);
  Materials->Enabled    = (ops & D3DRMXOFSAVE_MATERIALS);
  TextureNames->Enabled = (ops & D3DRMXOFSAVE_TEXTURENAMES);
  Templates->Checked    = (ops & D3DRMXOFSAVE_TEMPLATES);
  TextureCoordinates->Enabled =
                    (ops & D3DRMXOFSAVE_TEXTURECOORDINATES);
  SAVED_OPTIONS = GetOptions();
}//---------------------------------------------------------
void __fastcall TSaveForm::SetFormat(D3DRMXOFFORMAT Format){
  if (Format == D3DRMXOF_BINARY) Binary->Checked  = true;
  if (Format == D3DRMXOF_TEXT)   Text->Checked    = true;
  if (Format == D3DRMXOF_COMPRESSED)
     if (Compressed->Enabled) Compressed->Checked = true;
  SAVED_XOFFORMAT = GetFormat();
}//---------------------------------------------------------
D3DRMSAVEOPTIONS __fastcall TSaveForm::GetOptions() {
  D3DRMSAVEOPTIONS result = 0;
  if (Normals->Checked)
     result = (result | D3DRMXOFSAVE_NORMALS);
  if (Materials->Checked)
     result = (result | D3DRMXOFSAVE_MATERIALS);
  if (TextureCoordinates->Checked)
     result = (result | D3DRMXOFSAVE_TEXTURECOORDINATES);
  if (TextureNames->Checked)
     result = (result | D3DRMXOFSAVE_TEXTURENAMES);
  if (Templates->Checked)
     result = (result | D3DRMXOFSAVE_TEMPLATES);
  return result;
}//---------------------------------------------------------
D3DRMXOFFORMAT __fastcall TSaveForm::GetFormat() {
  if (Binary->Checked)     return D3DRMXOF_BINARY;
  if (Text->Checked)       return D3DRMXOF_TEXT;
  if (Compressed->Checked) return D3DRMXOF_COMPRESSED;
  return D3DRMXOF_BINARY;
}//---------------------------------------------------------
void __fastcall TSaveForm::AllClick(TObject*) {
  if (All->Checked) {
     Normals->Checked            = true;
     Normals->Enabled            = false;
     Materials->Checked          = true;
     Materials->Enabled          = false;
     TextureCoordinates->Checked = true;
     TextureCoordinates->Enabled = false;
     TextureNames->Checked       = true;
     TextureNames->Enabled       = false;
  } else {
     Normals->Enabled            = true;
     Materials->Enabled          = true;
     TextureCoordinates->Enabled = true;
     TextureNames->Enabled       = true;
  }
}//---------------------------------------------------------
void __fastcall TSaveForm::btnOkClick(TObject*) {
  SAVED_XOFFORMAT = GetFormat();
  SAVED_OPTIONS   = GetOptions();
}//---------------------------------------------------------
void __fastcall TSaveForm::btnCancelClick(TObject*) {
   SetFormat(SAVED_XOFFORMAT);
   SetOptions(SAVED_OPTIONS);
}//---------------------------------------------------------
